/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gluten.vectorized;

import java.io.FilterInputStream;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.zip.CheckedInputStream;
import org.apache.gluten.exception.GlutenException;
import org.apache.gluten.vectorized.JniByteInputStream;
import org.apache.gluten.vectorized.LowCopyFileSegmentJniByteInputStream;
import org.apache.gluten.vectorized.LowCopyNettyJniByteInputStream;
import org.apache.gluten.vectorized.OnHeapJniByteInputStream;
import org.apache.spark.storage.BufferReleasingInputStream;
import org.apache.spark.storage.SparkInputStreamUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JniByteInputStreams {
    private static final Logger LOG = LoggerFactory.getLogger(JniByteInputStreams.class);
    private static final Field FIELD_FilterInputStream_in;

    private JniByteInputStreams() {
    }

    public static JniByteInputStream create(InputStream in) {
        InputStream unwrapped = JniByteInputStreams.unwrapSparkInputStream(in);
        if (LowCopyNettyJniByteInputStream.isSupported(unwrapped)) {
            return new LowCopyNettyJniByteInputStream(in);
        }
        if (LowCopyFileSegmentJniByteInputStream.isSupported(unwrapped)) {
            return new LowCopyFileSegmentJniByteInputStream(in);
        }
        return new OnHeapJniByteInputStream(in);
    }

    static InputStream unwrapSparkInputStream(InputStream in) {
        InputStream unwrapped = in;
        if (unwrapped instanceof BufferReleasingInputStream) {
            BufferReleasingInputStream brin = (BufferReleasingInputStream)unwrapped;
            unwrapped = SparkInputStreamUtil.unwrapBufferReleasingInputStream(brin);
        }
        if (unwrapped instanceof CheckedInputStream) {
            CheckedInputStream cin = (CheckedInputStream)unwrapped;
            try {
                unwrapped = (InputStream)FIELD_FilterInputStream_in.get(cin);
            }
            catch (IllegalAccessException e) {
                throw new GlutenException(e);
            }
        }
        return unwrapped;
    }

    static {
        try {
            FIELD_FilterInputStream_in = FilterInputStream.class.getDeclaredField("in");
            FIELD_FilterInputStream_in.setAccessible(true);
        }
        catch (NoSuchFieldException e) {
            throw new GlutenException(e);
        }
    }
}

