/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gluten.vectorized;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.gluten.shaded.com.google.common.base.Preconditions;
import org.apache.spark.sql.execution.unsafe.JniUnsafeByteBuffer;
import org.apache.spark.sql.execution.unsafe.UnsafeByteArray;

public class ColumnarBatchSerializeResult
implements Serializable {
    public static final ColumnarBatchSerializeResult EMPTY = new ColumnarBatchSerializeResult(true, 0L, Collections.emptyList());
    private final boolean isOffHeap;
    private final long numRows;
    private final long sizeInBytes;
    private final List<byte[]> onHeapData;
    private final List<UnsafeByteArray> offHeapData;

    public ColumnarBatchSerializeResult(boolean isOffHeap, long numRows, List<JniUnsafeByteBuffer> serialized) {
        this.numRows = numRows;
        this.isOffHeap = isOffHeap;
        if (isOffHeap) {
            this.onHeapData = null;
            this.offHeapData = serialized.stream().map(JniUnsafeByteBuffer::toUnsafeByteArray).collect(Collectors.toList());
            this.sizeInBytes = this.offHeapData.stream().mapToInt(unsafe -> Math.toIntExact(unsafe.size())).sum();
        } else {
            this.onHeapData = serialized.stream().map(JniUnsafeByteBuffer::toByteArray).collect(Collectors.toList());
            this.offHeapData = null;
            this.sizeInBytes = this.onHeapData.stream().mapToInt(bytes -> ((byte[])bytes).length).sum();
        }
    }

    public boolean isOffHeap() {
        return this.isOffHeap;
    }

    public long numRows() {
        return this.numRows;
    }

    public long sizeInBytes() {
        return this.sizeInBytes;
    }

    public List<byte[]> onHeapData() {
        Preconditions.checkState(!this.isOffHeap);
        return this.onHeapData;
    }

    public List<UnsafeByteArray> offHeapData() {
        Preconditions.checkState(this.isOffHeap);
        return this.offHeapData;
    }
}

