/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gluten.vectorized;

import java.io.IOException;
import org.apache.gluten.columnarbatch.ColumnarBatches;
import org.apache.gluten.iterator.ClosableIterator;
import org.apache.gluten.runtime.Runtime;
import org.apache.gluten.runtime.RuntimeAware;
import org.apache.gluten.vectorized.ColumnarBatchInIterator;
import org.apache.spark.sql.vectorized.ColumnarBatch;

public class ColumnarBatchOutIterator
extends ClosableIterator<ColumnarBatch>
implements RuntimeAware {
    private final Runtime runtime;
    private final long iterHandle;

    public ColumnarBatchOutIterator(Runtime runtime, long iterHandle) {
        this.runtime = runtime;
        this.iterHandle = iterHandle;
    }

    @Override
    public long rtHandle() {
        return this.runtime.getHandle();
    }

    public long itrHandle() {
        return this.iterHandle;
    }

    private native boolean nativeHasNext(long var1);

    private native long nativeNext(long var1);

    private native long nativeSpill(long var1, long var3);

    private native void nativeClose(long var1);

    private native boolean nativeAddIteratorSplits(long var1, ColumnarBatchInIterator[] var3);

    private native void nativeNoMoreSplits(long var1);

    @Override
    public boolean hasNext0() throws IOException {
        return this.nativeHasNext(this.iterHandle);
    }

    @Override
    public ColumnarBatch next0() throws IOException {
        long batchHandle = this.nativeNext(this.iterHandle);
        if (batchHandle == -1L) {
            return null;
        }
        return ColumnarBatches.create(batchHandle);
    }

    public long spill(long size) {
        if (!this.closed.get()) {
            return this.nativeSpill(this.iterHandle, size);
        }
        return 0L;
    }

    public boolean addIteratorSplits(ColumnarBatchInIterator[] batchItr) {
        if (this.closed.get()) {
            throw new IllegalStateException("Cannot add splits to a closed iterator");
        }
        return this.nativeAddIteratorSplits(this.iterHandle, batchItr);
    }

    public void noMoreSplits() {
        if (this.closed.get()) {
            throw new IllegalStateException("Cannot call noMoreSplits on a closed iterator");
        }
        this.nativeNoMoreSplits(this.iterHandle);
    }

    @Override
    public void close0() {
        this.runtime.memoryManager().hold();
        this.nativeClose(this.iterHandle);
    }
}

