/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gluten.vectorized;

import java.util.Iterator;
import org.apache.gluten.columnarbatch.ColumnarBatches;
import org.apache.spark.sql.vectorized.ColumnarBatch;

public class ColumnarBatchInIterator {
    private final String backendName;
    private final Iterator<ColumnarBatch> delegated;

    public ColumnarBatchInIterator(String backendName, Iterator<ColumnarBatch> delegated) {
        this.backendName = backendName;
        this.delegated = delegated;
    }

    public boolean hasNext() {
        return this.delegated.hasNext();
    }

    public long next() {
        ColumnarBatch next = this.delegated.next();
        ColumnarBatches.checkOffloaded(next);
        return ColumnarBatches.getNativeHandle(this.backendName, next);
    }
}

