/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gluten.vectorized;

import java.math.BigDecimal;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.gluten.memory.arrow.alloc.ArrowBufferAllocators;
import org.apache.gluten.shaded.org.apache.arrow.memory.BufferAllocator;
import org.apache.gluten.shaded.org.apache.arrow.vector.BigIntVector;
import org.apache.gluten.shaded.org.apache.arrow.vector.BitVector;
import org.apache.gluten.shaded.org.apache.arrow.vector.DateDayVector;
import org.apache.gluten.shaded.org.apache.arrow.vector.DecimalVector;
import org.apache.gluten.shaded.org.apache.arrow.vector.DensityAwareVector;
import org.apache.gluten.shaded.org.apache.arrow.vector.FieldVector;
import org.apache.gluten.shaded.org.apache.arrow.vector.Float4Vector;
import org.apache.gluten.shaded.org.apache.arrow.vector.Float8Vector;
import org.apache.gluten.shaded.org.apache.arrow.vector.IntVector;
import org.apache.gluten.shaded.org.apache.arrow.vector.NullVector;
import org.apache.gluten.shaded.org.apache.arrow.vector.SmallIntVector;
import org.apache.gluten.shaded.org.apache.arrow.vector.TimeStampMicroTZVector;
import org.apache.gluten.shaded.org.apache.arrow.vector.TimeStampMicroVector;
import org.apache.gluten.shaded.org.apache.arrow.vector.TimeStampVector;
import org.apache.gluten.shaded.org.apache.arrow.vector.TinyIntVector;
import org.apache.gluten.shaded.org.apache.arrow.vector.ValueVector;
import org.apache.gluten.shaded.org.apache.arrow.vector.VarBinaryVector;
import org.apache.gluten.shaded.org.apache.arrow.vector.VarCharVector;
import org.apache.gluten.shaded.org.apache.arrow.vector.VariableWidthVector;
import org.apache.gluten.shaded.org.apache.arrow.vector.VectorLoader;
import org.apache.gluten.shaded.org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.gluten.shaded.org.apache.arrow.vector.complex.ListVector;
import org.apache.gluten.shaded.org.apache.arrow.vector.complex.MapVector;
import org.apache.gluten.shaded.org.apache.arrow.vector.complex.StructVector;
import org.apache.gluten.shaded.org.apache.arrow.vector.holders.NullableVarBinaryHolder;
import org.apache.gluten.shaded.org.apache.arrow.vector.holders.NullableVarCharHolder;
import org.apache.gluten.shaded.org.apache.arrow.vector.ipc.message.ArrowRecordBatch;
import org.apache.gluten.shaded.org.apache.arrow.vector.types.pojo.Field;
import org.apache.gluten.shaded.org.apache.arrow.vector.types.pojo.Schema;
import org.apache.gluten.vectorized.ArrowColumnVector;
import org.apache.gluten.vectorized.ArrowColumnarRow;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.SpecializedGetters;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.DateTimeUtils;
import org.apache.spark.sql.catalyst.util.MapData;
import org.apache.spark.sql.execution.vectorized.WritableColumnVector;
import org.apache.spark.sql.execution.vectorized.WritableColumnVectorShim;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.utils.SparkArrowUtil;
import org.apache.spark.sql.utils.SparkSchemaUtil;
import org.apache.spark.sql.vectorized.ArrowColumnarArray;
import org.apache.spark.sql.vectorized.ArrowColumnarMap;
import org.apache.spark.unsafe.Platform;
import org.apache.spark.unsafe.types.UTF8String;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ArrowWritableColumnVector
extends WritableColumnVectorShim {
    private static final boolean bigEndianPlatform = ByteOrder.nativeOrder().equals(ByteOrder.BIG_ENDIAN);
    private static final Logger LOG = LoggerFactory.getLogger(ArrowWritableColumnVector.class);
    private ArrowVectorAccessor accessor;
    private ArrowVectorWriter writer;
    private int ordinal;
    private ValueVector vector;
    private ValueVector dictionaryVector;
    public static AtomicLong vectorCount = new AtomicLong(0L);
    private AtomicLong refCnt = new AtomicLong(0L);
    private boolean closed = false;

    public static ArrowWritableColumnVector[] allocateColumns(int capacity, StructType schema) {
        String timeZoneId = SparkSchemaUtil.getLocalTimezoneID();
        Schema arrowSchema = SparkArrowUtil.toArrowSchema(schema, timeZoneId);
        VectorSchemaRoot newRoot = VectorSchemaRoot.create(arrowSchema, ArrowBufferAllocators.contextInstance());
        List<FieldVector> fieldVectors = newRoot.getFieldVectors();
        ArrowWritableColumnVector[] vectors = new ArrowWritableColumnVector[fieldVectors.size()];
        for (int i = 0; i < fieldVectors.size(); ++i) {
            vectors[i] = new ArrowWritableColumnVector(fieldVectors.get(i), i, capacity, true);
        }
        return vectors;
    }

    public static ArrowWritableColumnVector[] allocateColumns(int valueCount, long[] totalSizes, StructType schema) {
        String timeZoneId = SparkSchemaUtil.getLocalTimezoneID();
        Schema arrowSchema = SparkArrowUtil.toArrowSchema(schema, timeZoneId);
        VectorSchemaRoot newRoot = VectorSchemaRoot.create(arrowSchema, ArrowBufferAllocators.contextInstance());
        List<FieldVector> fieldVectors = newRoot.getFieldVectors();
        ArrowWritableColumnVector[] vectors = new ArrowWritableColumnVector[fieldVectors.size()];
        for (int i = 0; i < fieldVectors.size(); ++i) {
            vectors[i] = new ArrowWritableColumnVector(fieldVectors.get(i), null, i, valueCount, totalSizes[i], true);
        }
        return vectors;
    }

    public static ArrowWritableColumnVector[] loadColumns(int capacity, List<FieldVector> fieldVectors, List<FieldVector> dictionaryVectors) {
        if (fieldVectors.size() != dictionaryVectors.size()) {
            throw new IllegalArgumentException("Mismatched field vectors and dictionary vectors. Field vector count: " + fieldVectors.size() + ", dictionary vector count: " + dictionaryVectors.size());
        }
        ArrowWritableColumnVector[] vectors = new ArrowWritableColumnVector[fieldVectors.size()];
        for (int i = 0; i < fieldVectors.size(); ++i) {
            vectors[i] = new ArrowWritableColumnVector(fieldVectors.get(i), dictionaryVectors.get(i), i, capacity, false);
        }
        return vectors;
    }

    public static ArrowWritableColumnVector[] loadColumns(int capacity, List<FieldVector> fieldVectors) {
        ArrowWritableColumnVector[] vectors = new ArrowWritableColumnVector[fieldVectors.size()];
        for (int i = 0; i < fieldVectors.size(); ++i) {
            vectors[i] = new ArrowWritableColumnVector(fieldVectors.get(i), i, capacity, false);
        }
        return vectors;
    }

    public static ArrowWritableColumnVector[] loadColumns(int capacity, Schema arrowSchema, ArrowRecordBatch recordBatch, BufferAllocator allocator) {
        VectorSchemaRoot root = VectorSchemaRoot.create(arrowSchema, allocator);
        VectorLoader loader = new VectorLoader(root);
        loader.load(recordBatch);
        return ArrowWritableColumnVector.loadColumns(capacity, root.getFieldVectors());
    }

    @Deprecated
    public ArrowWritableColumnVector(ValueVector vector, int ordinal, int capacity, boolean init) {
        this(vector, null, ordinal, capacity, init);
    }

    public ArrowWritableColumnVector(ValueVector vector, ValueVector dicionaryVector, int ordinal, int capacity, boolean init) {
        super(capacity, SparkArrowUtil.fromArrowField(vector.getField()));
        vectorCount.getAndIncrement();
        this.refCnt.getAndIncrement();
        this.ordinal = ordinal;
        this.vector = vector;
        this.dictionaryVector = dicionaryVector;
        if (init) {
            vector.setInitialCapacity(capacity);
            vector.allocateNew();
        }
        this.writer = this.createVectorWriter(vector);
        this.createVectorAccessor(vector, dicionaryVector);
    }

    public ArrowWritableColumnVector(ValueVector vector, ValueVector dicionaryVector, int ordinal, int valueCount, long totalBytes, boolean init) {
        super(valueCount, SparkArrowUtil.fromArrowField(vector.getField()));
        vectorCount.getAndIncrement();
        this.refCnt.getAndIncrement();
        this.ordinal = ordinal;
        this.vector = vector;
        this.dictionaryVector = dicionaryVector;
        if (init) {
            if (vector instanceof VariableWidthVector) {
                ((VariableWidthVector)vector).allocateNew(totalBytes, this.capacity);
            } else if (vector instanceof DensityAwareVector) {
                double density = vector instanceof ListVector ? Math.sqrt(1.0 * (double)totalBytes / (double)valueCount) : 1.0 * (double)totalBytes / (double)valueCount;
                ((DensityAwareVector)((Object)vector)).setInitialCapacity(this.capacity, density);
                vector.allocateNew();
            } else {
                vector.setInitialCapacity(this.capacity);
                vector.allocateNew();
            }
        }
        this.writer = this.createVectorWriter(vector);
        this.createVectorAccessor(vector, dicionaryVector);
    }

    public ArrowWritableColumnVector(int capacity, DataType dataType) {
        super(capacity, dataType);
        vectorCount.getAndIncrement();
        this.refCnt.getAndIncrement();
        String timeZoneId = SparkSchemaUtil.getLocalTimezoneID();
        List<Field> fields = Arrays.asList(SparkArrowUtil.toArrowField("col", dataType, true, timeZoneId));
        Schema arrowSchema = new Schema(fields);
        VectorSchemaRoot root = VectorSchemaRoot.create(arrowSchema, ArrowBufferAllocators.contextInstance());
        List<FieldVector> fieldVectors = root.getFieldVectors();
        this.vector = fieldVectors.get(0);
        this.vector.setInitialCapacity(capacity);
        this.vector.allocateNew();
        this.writer = this.createVectorWriter(this.vector);
        this.createVectorAccessor(this.vector, null);
    }

    public ValueVector getValueVector() {
        return this.vector;
    }

    public void setValueCount(int numRows) {
        this.vector.setValueCount(numRows);
    }

    private void createVectorAccessor(ValueVector vector, ValueVector dictionary) {
        if (dictionary != null) {
            if (!(vector instanceof IntVector)) {
                throw new IllegalArgumentException("Expect int32 index vector. Found: " + String.valueOf((Object)vector.getMinorType()));
            }
            IntVector index = (IntVector)vector;
            if (dictionary instanceof VarBinaryVector) {
                this.accessor = new DictionaryEncodedBinaryAccessor(index, (VarBinaryVector)dictionary);
            } else if (dictionary instanceof VarCharVector) {
                this.accessor = new DictionaryEncodedStringAccessor(index, (VarCharVector)dictionary);
            } else {
                throw new IllegalArgumentException("Unrecognized index value type: " + String.valueOf((Object)dictionary.getMinorType()));
            }
            return;
        }
        if (vector instanceof BitVector) {
            this.accessor = new BooleanAccessor((BitVector)vector);
        } else if (vector instanceof TinyIntVector) {
            this.accessor = new ByteAccessor((TinyIntVector)vector);
        } else if (vector instanceof SmallIntVector) {
            this.accessor = new ShortAccessor((SmallIntVector)vector);
        } else if (vector instanceof IntVector) {
            this.accessor = new IntAccessor((IntVector)vector);
        } else if (vector instanceof BigIntVector) {
            this.accessor = new LongAccessor((BigIntVector)vector);
        } else if (vector instanceof Float4Vector) {
            this.accessor = new FloatAccessor((Float4Vector)vector);
        } else if (vector instanceof Float8Vector) {
            this.accessor = new DoubleAccessor((Float8Vector)vector);
        } else if (vector instanceof DecimalVector) {
            this.accessor = new DecimalAccessor((DecimalVector)vector);
        } else if (vector instanceof VarCharVector) {
            this.accessor = new StringAccessor((VarCharVector)vector);
        } else if (vector instanceof VarBinaryVector) {
            this.accessor = new BinaryAccessor((VarBinaryVector)vector);
        } else if (vector instanceof DateDayVector) {
            this.accessor = new DateAccessor((DateDayVector)vector);
        } else if (vector instanceof TimeStampMicroVector || vector instanceof TimeStampMicroTZVector) {
            this.accessor = new TimestampMicroAccessor((TimeStampVector)vector);
        } else if (vector instanceof MapVector) {
            MapVector mapVector = (MapVector)vector;
            this.accessor = new MapAccessor(mapVector);
            this.reallocateChildColumns(2);
            StructVector structVector = (StructVector)mapVector.getDataVector();
            FieldVector keyChild = structVector.getChild("key");
            FieldVector valueChild = structVector.getChild("value");
            this.childColumns[0] = new ArrowWritableColumnVector(keyChild, 0, structVector.size(), false);
            this.childColumns[1] = new ArrowWritableColumnVector(valueChild, 1, structVector.size(), false);
        } else if (vector instanceof ListVector) {
            ListVector listVector = (ListVector)vector;
            this.accessor = new ArrayAccessor(listVector);
            this.reallocateChildColumns(1);
            this.childColumns[0] = new ArrowWritableColumnVector(listVector.getDataVector(), 0, listVector.size(), false);
        } else if (vector instanceof StructVector) {
            StructVector structVector = (StructVector)vector;
            this.accessor = new StructAccessor(structVector);
            this.reallocateChildColumns(structVector.size());
            for (int i = 0; i < this.childColumns.length; ++i) {
                this.childColumns[i] = new ArrowWritableColumnVector(structVector.getVectorById(i), i, structVector.size(), false);
            }
        } else if (vector instanceof NullVector) {
            NullVector nullVector = (NullVector)vector;
            this.accessor = new NullAccessor(nullVector);
        } else {
            throw new UnsupportedOperationException("Unsupported vector " + String.valueOf((Object)vector.getMinorType()));
        }
    }

    private void reallocateChildColumns(int width) {
        if (this.childColumns != null) {
            for (WritableColumnVector column : this.childColumns) {
                column.close();
            }
        }
        this.childColumns = new ArrowWritableColumnVector[width];
    }

    private ArrowVectorWriter createVectorWriter(ValueVector vector) {
        if (vector instanceof BitVector) {
            return new BooleanWriter((BitVector)vector);
        }
        if (vector instanceof TinyIntVector) {
            return new ByteWriter((TinyIntVector)vector);
        }
        if (vector instanceof SmallIntVector) {
            return new ShortWriter((SmallIntVector)vector);
        }
        if (vector instanceof IntVector) {
            return new IntWriter((IntVector)vector);
        }
        if (vector instanceof BigIntVector) {
            return new LongWriter((BigIntVector)vector);
        }
        if (vector instanceof Float4Vector) {
            return new FloatWriter((Float4Vector)vector);
        }
        if (vector instanceof Float8Vector) {
            return new DoubleWriter((Float8Vector)vector);
        }
        if (vector instanceof DecimalVector) {
            return new DecimalWriter((DecimalVector)vector);
        }
        if (vector instanceof VarCharVector) {
            return new StringWriter((VarCharVector)vector);
        }
        if (vector instanceof VarBinaryVector) {
            return new BinaryWriter((VarBinaryVector)vector);
        }
        if (vector instanceof DateDayVector) {
            return new DateWriter((DateDayVector)vector);
        }
        if (vector instanceof TimeStampMicroVector || vector instanceof TimeStampMicroTZVector) {
            return new TimestampMicroWriter((TimeStampVector)vector);
        }
        if (vector instanceof MapVector) {
            MapVector mapVector = (MapVector)vector;
            StructVector entries = (StructVector)mapVector.getDataVector();
            ArrowVectorWriter keyWriter = this.createVectorWriter(entries.getChild("key"));
            ArrowVectorWriter valueWriter = this.createVectorWriter(entries.getChild("value"));
            return new MapWriter(mapVector, entries, keyWriter, valueWriter);
        }
        if (vector instanceof ListVector) {
            ListVector listVector = (ListVector)vector;
            ArrowVectorWriter elementVector = this.createVectorWriter(listVector.getDataVector());
            return new ArrayWriter(listVector, elementVector);
        }
        if (vector instanceof StructVector) {
            StructVector structVector = (StructVector)vector;
            ArrowVectorWriter[] children = new ArrowVectorWriter[structVector.size()];
            for (int ordinal = 0; ordinal < structVector.size(); ++ordinal) {
                children[ordinal] = this.createVectorWriter(structVector.getChildByOrdinal(ordinal));
            }
            return new StructWriter(structVector, children);
        }
        if (vector instanceof NullVector) {
            return new NullWriter((NullVector)vector);
        }
        throw new UnsupportedOperationException("Unsupported data type: " + String.valueOf((Object)vector.getMinorType()));
    }

    @Override
    protected void reserveInternal(int newCapacity) {
        ValueVector vector = this.getValueVector();
        int curCapacity = vector.getValueCapacity();
        while (curCapacity < newCapacity) {
            vector.reAlloc();
            curCapacity = vector.getValueCapacity();
        }
    }

    @Override
    public ArrowWritableColumnVector reserveNewColumn(int capacity, DataType type) {
        return new ArrowWritableColumnVector(capacity, type);
    }

    public void retain() {
        this.refCnt.getAndIncrement();
    }

    public long refCnt() {
        return this.refCnt.get();
    }

    public void close() {
        if (this.closed) {
            return;
        }
        if (this.refCnt.decrementAndGet() > 0L) {
            return;
        }
        this.closed = true;
        vectorCount.getAndDecrement();
        super.close();
        this.vector.close();
        if (this.dictionaryVector != null) {
            this.dictionaryVector.close();
        }
    }

    public static String stat() {
        return "vectorCounter is " + vectorCount.get();
    }

    public MapData getMapInternal(int rowId) {
        return this.accessor.getMap(rowId);
    }

    public ArrayData getArrayInternal(int rowId) {
        return this.accessor.getArray(rowId);
    }

    public ArrowColumnarRow getStructInternal(int rowId) {
        if (this.isNullAt(rowId)) {
            return null;
        }
        ArrowWritableColumnVector[] writableColumns = new ArrowWritableColumnVector[this.childColumns.length];
        for (int i = 0; i < writableColumns.length; ++i) {
            writableColumns[i] = (ArrowWritableColumnVector)this.childColumns[i];
        }
        return new ArrowColumnarRow(writableColumns, rowId);
    }

    public boolean hasNull() {
        return this.accessor.getNullCount() > 0;
    }

    public int numNulls() {
        return this.accessor.getNullCount();
    }

    @Override
    public void putNotNull(int rowId) {
        this.writer.setNotNull(rowId);
    }

    @Override
    public void putNull(int rowId) {
        ++this.numNulls;
        this.writer.setNull(rowId);
    }

    @Override
    public void putNulls(int rowId, int count) {
        this.numNulls += count;
        this.writer.setNulls(rowId, count);
    }

    @Override
    public void putNotNulls(int rowId, int count) {
        this.writer.setNotNulls(rowId, count);
    }

    @Override
    public boolean isNullAt(int rowId) {
        return this.accessor.isNullAt(rowId);
    }

    @Override
    public void putBoolean(int rowId, boolean value) {
        this.writer.setBoolean(rowId, value);
    }

    @Override
    public void putBooleans(int rowId, int count, boolean value) {
        this.writer.setBooleans(rowId, count, value);
    }

    @Override
    public boolean getBoolean(int rowId) {
        return this.accessor.getBoolean(rowId);
    }

    public boolean[] getBooleans(int rowId, int count) {
        return this.accessor.getBooleans(rowId, count);
    }

    @Override
    public void putByte(int rowId, byte value) {
        this.writer.setByte(rowId, value);
    }

    @Override
    public void putBytes(int rowId, int count, byte value) {
        this.writer.setBytes(rowId, count, value);
    }

    @Override
    public void putBytes(int rowId, int count, byte[] src, int srcIndex) {
        this.writer.setBytes(rowId, count, src, srcIndex);
    }

    public void appendString(byte[] value, int srcIndex, int count) {
        this.writer.setBytes(this.elementsAppended, count, value, srcIndex);
        ++this.elementsAppended;
    }

    public void appendDecimal(BigDecimal value) {
        this.writer.setBytes(this.elementsAppended, value);
        ++this.elementsAppended;
    }

    @Override
    public byte getByte(int rowId) {
        return this.accessor.getByte(rowId);
    }

    public byte[] getBytes(int rowId, int count) {
        return this.accessor.getBytes(rowId, count);
    }

    @Override
    protected UTF8String getBytesAsUTF8String(int rowId, int count) {
        return UTF8String.fromBytes((byte[])this.getBytes(rowId, count));
    }

    @Override
    public void putShort(int rowId, short value) {
        this.writer.setShort(rowId, value);
    }

    @Override
    public void putShorts(int rowId, int count, short value) {
        this.writer.setShorts(rowId, count, value);
    }

    @Override
    public void putShorts(int rowId, int count, short[] src, int srcIndex) {
        this.writer.setShorts(rowId, count, src, srcIndex);
    }

    @Override
    public void putShorts(int rowId, int count, byte[] src, int srcIndex) {
        this.writer.setShorts(rowId, count, src, srcIndex);
    }

    @Override
    public short getShort(int rowId) {
        return this.accessor.getShort(rowId);
    }

    public short[] getShorts(int rowId, int count) {
        return this.accessor.getShorts(rowId, count);
    }

    @Override
    public void putInt(int rowId, int value) {
        this.writer.setInt(rowId, value);
    }

    @Override
    public void putInts(int rowId, int count, int value) {
        this.writer.setInts(rowId, count, value);
    }

    @Override
    public void putInts(int rowId, int count, int[] src, int srcIndex) {
        this.writer.setInts(rowId, count, src, srcIndex);
    }

    @Override
    public void putInts(int rowId, int count, byte[] src, int srcIndex) {
        this.writer.setInts(rowId, count, src, srcIndex);
    }

    @Override
    public void putIntsLittleEndian(int rowId, int count, byte[] src, int srcIndex) {
        this.writer.setIntsLittleEndian(rowId, count, src, srcIndex);
    }

    @Override
    public int getInt(int rowId) {
        return this.accessor.getInt(rowId);
    }

    public int[] getInts(int rowId, int count) {
        return this.accessor.getInts(rowId, count);
    }

    @Override
    public int getDictId(int rowId) {
        assert (this.dictionary == null);
        return this.accessor.getInt(rowId);
    }

    @Override
    public void putLong(int rowId, long value) {
        this.writer.setLong(rowId, value);
    }

    @Override
    public void putLongs(int rowId, int count, long value) {
        this.writer.setLongs(rowId, count, value);
    }

    @Override
    public void putLongs(int rowId, int count, long[] src, int srcIndex) {
        this.writer.setLongs(rowId, count, src, srcIndex);
    }

    @Override
    public void putLongs(int rowId, int count, byte[] src, int srcIndex) {
        this.writer.setLongs(rowId, count, src, srcIndex);
    }

    @Override
    public void putLongsLittleEndian(int rowId, int count, byte[] src, int srcIndex) {
        this.writer.setLongsLittleEndian(rowId, count, src, srcIndex);
    }

    @Override
    public long getLong(int rowId) {
        return this.accessor.getLong(rowId);
    }

    public long[] getLongs(int rowId, int count) {
        return this.accessor.getLongs(rowId, count);
    }

    @Override
    public void putFloat(int rowId, float value) {
        this.writer.setFloat(rowId, value);
    }

    @Override
    public void putFloats(int rowId, int count, float value) {
        this.writer.setFloats(rowId, count, value);
    }

    @Override
    public void putFloats(int rowId, int count, float[] src, int srcIndex) {
        this.writer.setFloats(rowId, count, src, srcIndex);
    }

    @Override
    public void putFloats(int rowId, int count, byte[] src, int srcIndex) {
        this.writer.setFloats(rowId, count, src, srcIndex);
    }

    @Override
    public void putFloatsLittleEndian(int rowId, int count, byte[] src, int srcIndex) {
    }

    @Override
    public float getFloat(int rowId) {
        return this.accessor.getFloat(rowId);
    }

    public float[] getFloats(int rowId, int count) {
        return this.accessor.getFloats(rowId, count);
    }

    @Override
    public void putDouble(int rowId, double value) {
        this.writer.setDouble(rowId, value);
    }

    @Override
    public void putDoubles(int rowId, int count, double value) {
        this.writer.setDoubles(rowId, count, value);
    }

    @Override
    public void putDoubles(int rowId, int count, double[] src, int srcIndex) {
        this.writer.setDoubles(rowId, count, src, srcIndex);
    }

    @Override
    public void putDoublesLittleEndian(int rowId, int count, byte[] src, int srcIndex) {
    }

    @Override
    public void putDoubles(int rowId, int count, byte[] src, int srcIndex) {
        this.writer.setDoubles(rowId, count, src, srcIndex);
    }

    @Override
    public double getDouble(int rowId) {
        return this.accessor.getDouble(rowId);
    }

    public double[] getDoubles(int rowId, int count) {
        return this.accessor.getDoubles(rowId, count);
    }

    @Override
    public int getArrayLength(int rowId) {
        return this.accessor.getArrayLength(rowId);
    }

    @Override
    public int getArrayOffset(int rowId) {
        return this.accessor.getArrayOffset(rowId);
    }

    @Override
    public void putArray(int rowId, int offset, int length) {
        this.writer.setArray(rowId, offset, length);
    }

    @Override
    public int putByteArray(int rowId, byte[] value, int offset, int length) {
        this.writer.setBytes(rowId, length, value, offset);
        return length;
    }

    public Decimal getDecimal(int rowId, int precision, int scale) {
        if (this.isNullAt(rowId)) {
            return null;
        }
        return this.accessor.getDecimal(rowId, precision, scale);
    }

    public UTF8String getUTF8String(int rowId) {
        if (this.isNullAt(rowId)) {
            return null;
        }
        if (this.dataType() instanceof ArrayType) {
            UTF8String ret_0 = this.accessor.getUTF8String(rowId);
            for (int i = 0; i < ((ArrayAccessor)this.accessor).getArrayLength(rowId); ++i) {
                ret_0 = UTF8String.concat((UTF8String[])new UTF8String[]{ret_0, this.getArray(rowId).getUTF8String(i)});
            }
            return ret_0;
        }
        return this.accessor.getUTF8String(rowId);
    }

    public byte[] getBinary(int rowId) {
        if (this.isNullAt(rowId)) {
            return null;
        }
        return this.accessor.getBinary(rowId);
    }

    public void write(SpecializedGetters input, int ordinal) {
        this.writer.write(input, ordinal);
    }

    public void writeUnsafe(SpecializedGetters input, int ordinal) {
        this.writer.writeUnsafe(input, ordinal);
    }

    public void finishWrite() {
        this.writer.finish();
    }

    private static abstract class ArrowVectorWriter {
        private final ValueVector vector;
        protected int count = 0;

        ArrowVectorWriter(ValueVector vector) {
            this.vector = vector;
        }

        final void close() {
            this.vector.close();
        }

        void setNull(int rowId) {
            throw new UnsupportedOperationException();
        }

        void setNotNull(int rowId) {
        }

        void setNulls(int rowId, int count) {
            throw new UnsupportedOperationException();
        }

        void setNotNulls(int rowId, int count) {
            throw new UnsupportedOperationException();
        }

        void setBoolean(int rowId, boolean value) {
            throw new UnsupportedOperationException();
        }

        void setBooleans(int rowId, int count, boolean value) {
            throw new UnsupportedOperationException();
        }

        void setByte(int rowId, byte value) {
            throw new UnsupportedOperationException();
        }

        void setBytes(int rowId, int count, byte value) {
            throw new UnsupportedOperationException();
        }

        void setBytes(int rowId, int count, byte[] src, int srcIndex) {
            throw new UnsupportedOperationException();
        }

        void setShort(int rowId, short value) {
            throw new UnsupportedOperationException();
        }

        void setShorts(int rowId, int count, short value) {
            throw new UnsupportedOperationException();
        }

        void setShorts(int rowId, int count, short[] src, int srcIndex) {
            throw new UnsupportedOperationException();
        }

        void setShorts(int rowId, int count, byte[] src, int srcIndex) {
            throw new UnsupportedOperationException();
        }

        void setInt(int rowId, int value) {
            throw new UnsupportedOperationException();
        }

        void setInts(int rowId, int count, int value) {
            throw new UnsupportedOperationException();
        }

        void setInts(int rowId, int count, int[] src, int srcIndex) {
            throw new UnsupportedOperationException();
        }

        void setInts(int rowId, int count, byte[] src, int srcIndex) {
            throw new UnsupportedOperationException();
        }

        void setIntsLittleEndian(int rowId, int count, byte[] src, int srcIndex) {
            throw new UnsupportedOperationException();
        }

        void setLong(int rowId, long value) {
            throw new UnsupportedOperationException();
        }

        void setLongs(int rowId, int count, long value) {
            throw new UnsupportedOperationException();
        }

        void setLongs(int rowId, int count, long[] src, int srcIndex) {
            throw new UnsupportedOperationException();
        }

        void setLongs(int rowId, int count, byte[] src, int srcIndex) {
            throw new UnsupportedOperationException();
        }

        void setLongsLittleEndian(int rowId, int count, byte[] src, int srcIndex) {
            throw new UnsupportedOperationException();
        }

        void setFloat(int rowId, float value) {
            throw new UnsupportedOperationException();
        }

        void setFloats(int rowId, int count, float value) {
            throw new UnsupportedOperationException();
        }

        void setFloats(int rowId, int count, float[] src, int srcIndex) {
            throw new UnsupportedOperationException();
        }

        void setFloats(int rowId, int count, byte[] src, int srcIndex) {
            throw new UnsupportedOperationException();
        }

        void setDouble(int rowId, double value) {
            throw new UnsupportedOperationException();
        }

        void setDoubles(int rowId, int count, double value) {
            throw new UnsupportedOperationException();
        }

        void setDoubles(int rowId, int count, double[] src, int srcIndex) {
            throw new UnsupportedOperationException();
        }

        void setDoubles(int rowId, int count, byte[] src, int srcIndex) {
            throw new UnsupportedOperationException();
        }

        void setArray(int rowId, int offset, int length) {
            throw new UnsupportedOperationException();
        }

        void setByteArray(int rowId, byte[] value, int offset, int length) {
            throw new UnsupportedOperationException();
        }

        void appendBytes(byte[] value, int offset, int length) {
            throw new UnsupportedOperationException();
        }

        void setBytes(int rowId, BigDecimal value) {
            throw new UnsupportedOperationException();
        }

        abstract void setValueNullSafe(SpecializedGetters var1, int var2);

        abstract void unsafeSetValueNullSafe(SpecializedGetters var1, int var2);

        void write(SpecializedGetters input, int ordinal) {
            if (input.isNullAt(ordinal)) {
                this.setNull(this.count);
            } else {
                this.setValueNullSafe(input, ordinal);
            }
            ++this.count;
        }

        void writeUnsafe(SpecializedGetters input, int ordinal) {
            if (input.isNullAt(ordinal)) {
                this.setNull(this.count);
            } else {
                this.unsafeSetValueNullSafe(input, ordinal);
            }
            ++this.count;
        }

        void finish() {
            this.vector.setValueCount(this.count);
        }

        void reset() {
            this.vector.reset();
            this.count = 0;
        }
    }

    private static class DictionaryEncodedBinaryAccessor
    extends ArrowVectorAccessor {
        private final IntVector index;
        private final VarBinaryVector dictionary;

        DictionaryEncodedBinaryAccessor(IntVector index, VarBinaryVector dictionary) {
            super(index);
            this.index = index;
            this.dictionary = dictionary;
        }

        @Override
        final byte[] getBinary(int rowId) {
            int idx = this.index.get(rowId);
            return this.dictionary.getObject(idx);
        }
    }

    private static abstract class ArrowVectorAccessor {
        private final ValueVector vector;

        ArrowVectorAccessor(ValueVector vector) {
            this.vector = vector;
        }

        boolean isNullAt(int rowId) {
            return this.vector.isNull(rowId);
        }

        final int getNullCount() {
            return this.vector.getNullCount();
        }

        final void close() {
            this.vector.close();
        }

        boolean getBoolean(int rowId) {
            throw new UnsupportedOperationException();
        }

        boolean[] getBooleans(int rowId, int count) {
            throw new UnsupportedOperationException();
        }

        byte getByte(int rowId) {
            throw new UnsupportedOperationException();
        }

        byte[] getBytes(int rowId, int count) {
            throw new UnsupportedOperationException();
        }

        short getShort(int rowId) {
            throw new UnsupportedOperationException();
        }

        short[] getShorts(int rowId, int count) {
            throw new UnsupportedOperationException();
        }

        int getInt(int rowId) {
            throw new UnsupportedOperationException();
        }

        int[] getInts(int rowId, int count) {
            throw new UnsupportedOperationException();
        }

        long getLong(int rowId) {
            throw new UnsupportedOperationException();
        }

        long[] getLongs(int rowId, int count) {
            throw new UnsupportedOperationException();
        }

        float getFloat(int rowId) {
            throw new UnsupportedOperationException();
        }

        float[] getFloats(int rowId, int count) {
            throw new UnsupportedOperationException();
        }

        double getDouble(int rowId) {
            throw new UnsupportedOperationException();
        }

        double[] getDoubles(int rowId, int count) {
            throw new UnsupportedOperationException();
        }

        Decimal getDecimal(int rowId, int precision, int scale) {
            throw new UnsupportedOperationException();
        }

        UTF8String getUTF8String(int rowId) {
            throw new UnsupportedOperationException();
        }

        byte[] getBinary(int rowId) {
            throw new UnsupportedOperationException();
        }

        ArrayData getArray(int rowId) {
            throw new UnsupportedOperationException();
        }

        int getArrayLength(int rowId) {
            throw new UnsupportedOperationException();
        }

        int getArrayOffset(int rowId) {
            throw new UnsupportedOperationException();
        }

        MapData getMap(int rowId) {
            throw new UnsupportedOperationException();
        }
    }

    private static class DictionaryEncodedStringAccessor
    extends ArrowVectorAccessor {
        private final IntVector index;
        private final VarCharVector dictionary;
        private final NullableVarCharHolder stringResult = new NullableVarCharHolder();

        DictionaryEncodedStringAccessor(IntVector index, VarCharVector dictionary) {
            super(index);
            this.index = index;
            this.dictionary = dictionary;
        }

        @Override
        final UTF8String getUTF8String(int rowId) {
            int idx = this.index.get(rowId);
            this.dictionary.get(idx, this.stringResult);
            if (this.stringResult.isSet == 0) {
                return null;
            }
            return UTF8String.fromAddress(null, (long)(this.stringResult.buffer.memoryAddress() + (long)this.stringResult.start), (int)(this.stringResult.end - this.stringResult.start));
        }
    }

    private static class BooleanAccessor
    extends ArrowVectorAccessor {
        private final BitVector accessor;

        BooleanAccessor(BitVector vector) {
            super(vector);
            this.accessor = vector;
        }

        @Override
        final boolean getBoolean(int rowId) {
            return this.accessor.get(rowId) == 1;
        }

        @Override
        final UTF8String getUTF8String(int rowId) {
            return UTF8String.fromString((String)Boolean.toString(this.getBoolean(rowId)));
        }
    }

    private static class ByteAccessor
    extends ArrowVectorAccessor {
        private final TinyIntVector accessor;

        ByteAccessor(TinyIntVector vector) {
            super(vector);
            this.accessor = vector;
        }

        @Override
        final byte getByte(int rowId) {
            return this.accessor.get(rowId);
        }

        @Override
        final UTF8String getUTF8String(int rowId) {
            return UTF8String.fromString((String)Byte.toString(this.accessor.get(rowId)));
        }
    }

    private static class ShortAccessor
    extends ArrowVectorAccessor {
        private final SmallIntVector accessor;

        ShortAccessor(SmallIntVector vector) {
            super(vector);
            this.accessor = vector;
        }

        @Override
        final short getShort(int rowId) {
            return this.accessor.get(rowId);
        }

        @Override
        final UTF8String getUTF8String(int rowId) {
            return UTF8String.fromString((String)Short.toString(this.accessor.get(rowId)));
        }
    }

    private static class IntAccessor
    extends ArrowVectorAccessor {
        private final IntVector accessor;

        IntAccessor(IntVector vector) {
            super(vector);
            this.accessor = vector;
        }

        @Override
        final int getInt(int rowId) {
            return this.accessor.get(rowId);
        }

        @Override
        final UTF8String getUTF8String(int rowId) {
            return UTF8String.fromString((String)Integer.toString(this.accessor.get(rowId)));
        }
    }

    private static class LongAccessor
    extends ArrowVectorAccessor {
        private final BigIntVector accessor;

        LongAccessor(BigIntVector vector) {
            super(vector);
            this.accessor = vector;
        }

        @Override
        final long getLong(int rowId) {
            return this.accessor.get(rowId);
        }

        @Override
        final UTF8String getUTF8String(int rowId) {
            return UTF8String.fromString((String)Long.toString(this.accessor.get(rowId)));
        }
    }

    private static class FloatAccessor
    extends ArrowVectorAccessor {
        private final Float4Vector accessor;

        FloatAccessor(Float4Vector vector) {
            super(vector);
            this.accessor = vector;
        }

        @Override
        final float getFloat(int rowId) {
            return this.accessor.get(rowId);
        }

        @Override
        final UTF8String getUTF8String(int rowId) {
            return UTF8String.fromString((String)Float.toString(this.accessor.get(rowId)));
        }
    }

    private static class DoubleAccessor
    extends ArrowVectorAccessor {
        private final Float8Vector accessor;

        DoubleAccessor(Float8Vector vector) {
            super(vector);
            this.accessor = vector;
        }

        @Override
        final double getDouble(int rowId) {
            return this.accessor.get(rowId);
        }

        @Override
        final UTF8String getUTF8String(int rowId) {
            return UTF8String.fromString((String)Double.toString(this.accessor.get(rowId)));
        }
    }

    private static class DecimalAccessor
    extends ArrowVectorAccessor {
        private final DecimalVector accessor;
        int precision = 0;
        int scale = 0;

        DecimalAccessor(DecimalVector vector) {
            super(vector);
            this.accessor = vector;
            this.precision = vector.getPrecision();
            this.scale = vector.getScale();
        }

        @Override
        final Decimal getDecimal(int rowId, int _precision, int _scale) {
            if (this.isNullAt(rowId)) {
                return null;
            }
            return Decimal.apply((BigDecimal)this.accessor.getObject(rowId), (int)_precision, (int)_scale);
        }

        final Decimal getDecimal(int rowId) {
            if (this.isNullAt(rowId)) {
                return null;
            }
            return Decimal.apply((BigDecimal)this.accessor.getObject(rowId), (int)this.precision, (int)this.scale);
        }

        @Override
        final UTF8String getUTF8String(int rowId) {
            return UTF8String.fromString((String)this.getDecimal(rowId).toString());
        }
    }

    private static class StringAccessor
    extends ArrowVectorAccessor {
        private final VarCharVector accessor;
        private final NullableVarCharHolder stringResult = new NullableVarCharHolder();

        StringAccessor(VarCharVector vector) {
            super(vector);
            this.accessor = vector;
        }

        @Override
        final UTF8String getUTF8String(int rowId) {
            this.accessor.get(rowId, this.stringResult);
            if (this.stringResult.isSet == 0) {
                return null;
            }
            return UTF8String.fromAddress(null, (long)(this.stringResult.buffer.memoryAddress() + (long)this.stringResult.start), (int)(this.stringResult.end - this.stringResult.start));
        }
    }

    private static class BinaryAccessor
    extends ArrowVectorAccessor {
        private final VarBinaryVector accessor;
        private final NullableVarBinaryHolder stringResult = new NullableVarBinaryHolder();

        BinaryAccessor(VarBinaryVector vector) {
            super(vector);
            this.accessor = vector;
        }

        @Override
        final byte[] getBinary(int rowId) {
            return this.accessor.getObject(rowId);
        }

        @Override
        final UTF8String getUTF8String(int rowId) {
            this.accessor.get(rowId, this.stringResult);
            if (this.stringResult.isSet == 0) {
                return null;
            }
            return UTF8String.fromAddress(null, (long)(this.stringResult.buffer.memoryAddress() + (long)this.stringResult.start), (int)(this.stringResult.end - this.stringResult.start));
        }
    }

    private static class DateAccessor
    extends ArrowVectorAccessor {
        private final DateDayVector accessor;

        DateAccessor(DateDayVector vector) {
            super(vector);
            this.accessor = vector;
        }

        @Override
        final int getInt(int rowId) {
            return this.accessor.get(rowId);
        }

        @Override
        final UTF8String getUTF8String(int rowId) {
            java.sql.Date jDate = DateTimeUtils.toJavaDate((int)this.accessor.get(rowId));
            return UTF8String.fromString((String)((Date)jDate).toString());
        }
    }

    private static class TimestampMicroAccessor
    extends ArrowVectorAccessor {
        private final TimeStampVector accessor;

        TimestampMicroAccessor(TimeStampVector vector) {
            super(vector);
            this.accessor = vector;
        }

        @Override
        final long getLong(int rowId) {
            return this.accessor.get(rowId);
        }
    }

    private static class MapAccessor
    extends ArrowVectorAccessor {
        private final MapVector accessor;
        private final ArrowColumnVector keys;
        private final ArrowColumnVector values;

        MapAccessor(MapVector vector) {
            super(vector);
            this.accessor = vector;
            StructVector entries = (StructVector)vector.getDataVector();
            this.keys = new ArrowColumnVector(entries.getChild("key"));
            this.values = new ArrowColumnVector(entries.getChild("value"));
        }

        @Override
        final MapData getMap(int rowId) {
            int index = rowId * 4;
            int offset = this.accessor.getOffsetBuffer().getInt(index);
            int length = this.accessor.getInnerValueCountAt(rowId);
            return new ArrowColumnarMap(this.keys, this.values, offset, length);
        }

        @Override
        int getArrayOffset(int rowId) {
            int index = rowId * 4;
            return this.accessor.getOffsetBuffer().getInt(index);
        }

        @Override
        int getArrayLength(int rowId) {
            return this.accessor.getInnerValueCountAt(rowId);
        }
    }

    private static class ArrayAccessor
    extends ArrowVectorAccessor {
        private final ListVector accessor;
        private final ArrowColumnVector elements;

        ArrayAccessor(ListVector vector) {
            super(vector);
            this.accessor = vector;
            this.elements = new ArrowColumnVector(vector.getDataVector());
        }

        @Override
        boolean isNullAt(int rowId) {
            if (this.accessor.getValueCount() > 0 && this.accessor.getValidityBuffer().capacity() == 0L) {
                return false;
            }
            return super.isNullAt(rowId);
        }

        @Override
        public int getArrayLength(int rowId) {
            int index = rowId * 4;
            int start = this.accessor.getOffsetBuffer().getInt(index);
            int end = this.accessor.getOffsetBuffer().getInt(index + 4);
            return end - start;
        }

        @Override
        public int getArrayOffset(int rowId) {
            int index = rowId * 4;
            return this.accessor.getOffsetBuffer().getInt(index);
        }

        @Override
        final ArrayData getArray(int rowId) {
            return new ArrowColumnarArray(this.elements, this.getArrayOffset(rowId), this.getArrayLength(rowId));
        }

        @Override
        final UTF8String getUTF8String(int rowId) {
            return UTF8String.fromString((String)("Array[" + this.getArrayOffset(rowId) + "-" + this.getArrayLength(rowId) + "]"));
        }
    }

    private static class StructAccessor
    extends ArrowVectorAccessor {
        StructAccessor(StructVector vector) {
            super(vector);
        }
    }

    private static class NullAccessor
    extends ArrowVectorAccessor {
        NullAccessor(NullVector vector) {
            super(vector);
        }
    }

    private static class BooleanWriter
    extends ArrowVectorWriter {
        private final BitVector writer;

        BooleanWriter(BitVector vector) {
            super(vector);
            this.writer = vector;
        }

        @Override
        final void setNull(int rowId) {
            this.writer.setNull(rowId);
        }

        @Override
        final void setNulls(int rowId, int count) {
            for (int i = 0; i < count; ++i) {
                this.writer.setNull(rowId + i);
            }
        }

        @Override
        final void setBoolean(int rowId, boolean value) {
            this.writer.setSafe(rowId, value ? 1 : 0);
        }

        @Override
        final void setBooleans(int rowId, int count, boolean value) {
            for (int i = 0; i < count; ++i) {
                this.writer.setSafe(rowId + i, value ? 1 : 0);
            }
        }

        @Override
        void setValueNullSafe(SpecializedGetters input, int ordinal) {
            this.setBoolean(this.count, input.getBoolean(ordinal));
        }

        @Override
        void unsafeSetValueNullSafe(SpecializedGetters input, int ordinal) {
            this.writer.set(this.count, input.getBoolean(ordinal) ? 1 : 0);
        }
    }

    private static class ByteWriter
    extends ArrowVectorWriter {
        private final TinyIntVector writer;

        ByteWriter(TinyIntVector vector) {
            super(vector);
            this.writer = vector;
        }

        @Override
        final void setNull(int rowId) {
            this.writer.setNull(rowId);
        }

        @Override
        final void setNulls(int rowId, int count) {
            for (int i = 0; i < count; ++i) {
                this.writer.setNull(rowId + i);
            }
        }

        @Override
        final void setByte(int rowId, byte value) {
            this.writer.setSafe(rowId, value);
        }

        @Override
        final void setBytes(int rowId, int count, byte value) {
            for (int i = 0; i < count; ++i) {
                this.writer.setSafe(rowId + i, value);
            }
        }

        @Override
        final void setBytes(int rowId, int count, byte[] src, int srcIndex) {
            for (int i = 0; i < count; ++i) {
                this.writer.setSafe(rowId + i, src[srcIndex + i]);
            }
        }

        @Override
        void setValueNullSafe(SpecializedGetters input, int ordinal) {
            this.setByte(this.count, input.getByte(ordinal));
        }

        @Override
        void unsafeSetValueNullSafe(SpecializedGetters input, int ordinal) {
            this.writer.set(this.count, input.getByte(ordinal));
        }
    }

    private static class ShortWriter
    extends ArrowVectorWriter {
        private final SmallIntVector writer;

        ShortWriter(SmallIntVector vector) {
            super(vector);
            this.writer = vector;
        }

        @Override
        final void setNull(int rowId) {
            this.writer.setNull(rowId);
        }

        @Override
        final void setNulls(int rowId, int count) {
            for (int i = 0; i < count; ++i) {
                this.writer.setNull(rowId + i);
            }
        }

        @Override
        final void setShort(int rowId, short value) {
            this.writer.setSafe(rowId, value);
        }

        @Override
        final void setShorts(int rowId, int count, short value) {
            for (int i = 0; i < count; ++i) {
                this.writer.setSafe(rowId + i, value);
            }
        }

        @Override
        final void setShorts(int rowId, int count, short[] src, int srcIndex) {
            for (int i = 0; i < count; ++i) {
                this.writer.setSafe(rowId + i, src[srcIndex + i]);
            }
        }

        @Override
        final void setShorts(int rowId, int count, byte[] src, int srcIndex) {
            for (int i = 0; i < count; ++i) {
                this.writer.setSafe(rowId + i, src[srcIndex + i]);
            }
        }

        @Override
        void setValueNullSafe(SpecializedGetters input, int ordinal) {
            this.setShort(this.count, input.getShort(ordinal));
        }

        @Override
        void unsafeSetValueNullSafe(SpecializedGetters input, int ordinal) {
            this.writer.setSafe(this.count, input.getShort(ordinal));
        }
    }

    private static class IntWriter
    extends ArrowVectorWriter {
        private final IntVector writer;

        IntWriter(IntVector vector) {
            super(vector);
            this.writer = vector;
        }

        @Override
        final void setNull(int rowId) {
            this.writer.setNull(rowId);
        }

        @Override
        final void setNulls(int rowId, int count) {
            for (int i = 0; i < count; ++i) {
                this.writer.setNull(rowId + i);
            }
        }

        @Override
        final void setInt(int rowId, int value) {
            this.writer.setSafe(rowId, value);
        }

        @Override
        final void setInts(int rowId, int count, int value) {
            for (int i = 0; i < count; ++i) {
                this.writer.setSafe(rowId + i, value);
            }
        }

        @Override
        final void setInts(int rowId, int count, int[] src, int srcIndex) {
            for (int i = 0; i < count; ++i) {
                this.writer.setSafe(rowId + i, src[srcIndex + i]);
            }
        }

        @Override
        final void setInts(int rowId, int count, byte[] src, int srcIndex) {
            int srcOffset = srcIndex + Platform.BYTE_ARRAY_OFFSET;
            int i = 0;
            while (i < count) {
                this.writer.setSafe(rowId + i, Platform.getInt((Object)src, (long)srcOffset));
                ++i;
                srcOffset += 4;
            }
        }

        @Override
        void setIntsLittleEndian(int rowId, int count, byte[] src, int srcIndex) {
            int srcOffset = srcIndex + Platform.BYTE_ARRAY_OFFSET;
            int i = 0;
            while (i < count) {
                int tmp = Platform.getInt((Object)src, (long)srcOffset);
                if (bigEndianPlatform) {
                    tmp = Integer.reverseBytes(tmp);
                }
                this.writer.setSafe(rowId + i, tmp);
                ++i;
                srcOffset += 4;
            }
        }

        @Override
        void setValueNullSafe(SpecializedGetters input, int ordinal) {
            this.setInt(this.count, input.getInt(ordinal));
        }

        @Override
        void unsafeSetValueNullSafe(SpecializedGetters input, int ordinal) {
            this.writer.set(this.count, input.getInt(ordinal));
        }
    }

    private static class LongWriter
    extends ArrowVectorWriter {
        private final BigIntVector writer;

        LongWriter(BigIntVector vector) {
            super(vector);
            this.writer = vector;
        }

        @Override
        final void setNull(int rowId) {
            this.writer.setNull(rowId);
        }

        @Override
        final void setNulls(int rowId, int count) {
            for (int i = 0; i < count; ++i) {
                this.writer.setNull(rowId + i);
            }
        }

        @Override
        final void setLong(int rowId, long value) {
            this.writer.setSafe(rowId, value);
        }

        @Override
        final void setLongs(int rowId, int count, long value) {
            for (int i = 0; i < count; ++i) {
                this.writer.setSafe(rowId + i, value);
            }
        }

        @Override
        final void setLongs(int rowId, int count, long[] src, int srcIndex) {
            for (int i = 0; i < count; ++i) {
                this.writer.setSafe(rowId + i, src[srcIndex + i]);
            }
        }

        @Override
        final void setLongs(int rowId, int count, byte[] src, int srcIndex) {
            int srcOffset = srcIndex + Platform.BYTE_ARRAY_OFFSET;
            int i = 0;
            while (i < count) {
                this.writer.setSafe(rowId + i, Platform.getLong((Object)src, (long)srcOffset));
                ++i;
                srcOffset += 8;
            }
        }

        @Override
        final void setDouble(int rowId, double value) {
            long val = (long)value;
            this.writer.setSafe(rowId, val);
        }

        @Override
        void setValueNullSafe(SpecializedGetters input, int ordinal) {
            this.setLong(this.count, input.getLong(ordinal));
        }

        @Override
        void setLongsLittleEndian(int rowId, int count, byte[] src, int srcIndex) {
            int srcOffset = srcIndex + Platform.BYTE_ARRAY_OFFSET;
            int i = 0;
            while (i < count) {
                long tmp = Platform.getLong((Object)src, (long)srcOffset);
                if (bigEndianPlatform) {
                    tmp = Long.reverseBytes(tmp);
                }
                this.writer.setSafe(rowId + i, tmp);
                ++i;
                srcOffset += 8;
            }
        }

        @Override
        void unsafeSetValueNullSafe(SpecializedGetters input, int ordinal) {
            this.writer.set(this.count, input.getLong(ordinal));
        }
    }

    private static class FloatWriter
    extends ArrowVectorWriter {
        private final Float4Vector writer;

        FloatWriter(Float4Vector vector) {
            super(vector);
            this.writer = vector;
        }

        @Override
        final void setNull(int rowId) {
            this.writer.setNull(rowId);
        }

        @Override
        final void setNulls(int rowId, int count) {
            for (int i = 0; i < count; ++i) {
                this.writer.setNull(rowId + i);
            }
        }

        @Override
        final void setFloat(int rowId, float value) {
            this.writer.setSafe(rowId, value);
        }

        @Override
        final void setFloats(int rowId, int count, float value) {
            for (int i = 0; i < count; ++i) {
                this.writer.setSafe(rowId + i, value);
            }
        }

        @Override
        final void setFloats(int rowId, int count, float[] src, int srcIndex) {
            for (int i = 0; i < count; ++i) {
                this.writer.setSafe(rowId + i, src[srcIndex + i]);
            }
        }

        @Override
        void setValueNullSafe(SpecializedGetters input, int ordinal) {
            this.setFloat(this.count, input.getFloat(ordinal));
        }

        @Override
        void unsafeSetValueNullSafe(SpecializedGetters input, int ordinal) {
            this.writer.set(this.count, input.getFloat(ordinal));
        }
    }

    private static class DoubleWriter
    extends ArrowVectorWriter {
        private final Float8Vector writer;

        DoubleWriter(Float8Vector vector) {
            super(vector);
            this.writer = vector;
        }

        @Override
        final void setNull(int rowId) {
            this.writer.setNull(rowId);
        }

        @Override
        final void setNulls(int rowId, int count) {
            for (int i = 0; i < count; ++i) {
                this.writer.setNull(rowId + i);
            }
        }

        @Override
        final void setDouble(int rowId, double value) {
            this.writer.setSafe(rowId, value);
        }

        @Override
        final void setDoubles(int rowId, int count, double value) {
            for (int i = 0; i < count; ++i) {
                this.writer.setSafe(rowId + i, value);
            }
        }

        @Override
        final void setDoubles(int rowId, int count, double[] src, int srcIndex) {
            for (int i = 0; i < count; ++i) {
                this.writer.setSafe(rowId + i, src[srcIndex + i]);
            }
        }

        @Override
        void setValueNullSafe(SpecializedGetters input, int ordinal) {
            this.setDouble(this.count, input.getDouble(ordinal));
        }

        @Override
        void unsafeSetValueNullSafe(SpecializedGetters input, int ordinal) {
            this.writer.set(this.count, input.getDouble(ordinal));
        }
    }

    private static class DecimalWriter
    extends ArrowVectorWriter {
        private final DecimalVector writer;
        private final int precision;
        private final int scale;

        DecimalWriter(DecimalVector vector) {
            super(vector);
            this.writer = vector;
            DataType dataType = SparkArrowUtil.fromArrowField(vector.getField());
            DecimalType decimalType = (DecimalType)dataType;
            this.precision = decimalType.precision();
            this.scale = decimalType.scale();
        }

        @Override
        final void setNull(int rowId) {
            this.writer.setNull(rowId);
        }

        @Override
        final void setInt(int rowId, int value) {
            this.writer.setSafe(rowId, value);
        }

        @Override
        final void setLong(int rowId, long value) {
            this.writer.setSafe(rowId, value);
        }

        @Override
        final void setBytes(int rowId, BigDecimal value) {
            this.writer.setSafe(rowId, value);
        }

        @Override
        final void setBytes(int rowId, int count, byte[] src, int srcIndex) {
            if (count == src.length && srcIndex == 0) {
                this.writer.setBigEndianSafe(rowId, src);
                return;
            }
            throw new UnsupportedOperationException();
        }

        @Override
        void setValueNullSafe(SpecializedGetters input, int ordinal) {
            Decimal decimal = input.getDecimal(ordinal, this.precision, this.scale);
            if (decimal.changePrecision(this.precision, this.scale)) {
                this.setBytes(this.count, decimal.toJavaBigDecimal());
            } else {
                this.setNull(this.count);
            }
        }

        @Override
        void unsafeSetValueNullSafe(SpecializedGetters input, int ordinal) {
            Decimal decimal = input.getDecimal(ordinal, this.precision, this.scale);
            if (decimal.changePrecision(this.precision, this.scale)) {
                this.writer.set(this.count, decimal.toJavaBigDecimal());
            } else {
                this.setNull(this.count);
            }
        }
    }

    private static class StringWriter
    extends ArrowVectorWriter {
        private final VarCharVector writer;
        private int rowId;

        StringWriter(VarCharVector vector) {
            super(vector);
            this.writer = vector;
            this.rowId = 0;
        }

        @Override
        final void setNull(int rowId) {
            this.writer.setNull(rowId);
        }

        @Override
        final void setNulls(int rowId, int count) {
            for (int i = 0; i < count; ++i) {
                this.writer.setNull(rowId + i);
            }
        }

        @Override
        final void setBytes(int rowId, int count, byte[] src, int srcIndex) {
            this.writer.setSafe(rowId, src, srcIndex, count);
        }

        @Override
        final void appendBytes(byte[] value, int offset, int length) {
            this.writer.setSafe(this.rowId, value, offset, length);
            ++this.rowId;
        }

        @Override
        void setValueNullSafe(SpecializedGetters input, int ordinal) {
            UTF8String value = input.getUTF8String(ordinal);
            this.setBytes(this.count, value.numBytes(), value.getBytes(), 0);
        }

        @Override
        void unsafeSetValueNullSafe(SpecializedGetters input, int ordinal) {
            UTF8String value = input.getUTF8String(ordinal);
            this.writer.set(this.count, value.getBytes(), 0, value.numBytes());
        }
    }

    private static class BinaryWriter
    extends ArrowVectorWriter {
        private final VarBinaryVector writer;

        BinaryWriter(VarBinaryVector vector) {
            super(vector);
            this.writer = vector;
        }

        @Override
        final void setNull(int rowId) {
            this.writer.setNull(rowId);
        }

        @Override
        final void setNulls(int rowId, int count) {
            for (int i = 0; i < count; ++i) {
                this.writer.setNull(rowId + i);
            }
        }

        @Override
        final void setBytes(int rowId, int count, byte[] src, int srcIndex) {
            this.writer.setSafe(rowId, src, srcIndex, count);
        }

        @Override
        void setValueNullSafe(SpecializedGetters input, int ordinal) {
            byte[] value = input.getBinary(ordinal);
            this.setBytes(this.count, value.length, value, 0);
        }

        @Override
        void unsafeSetValueNullSafe(SpecializedGetters input, int ordinal) {
            byte[] value = input.getBinary(ordinal);
            this.writer.set(this.count, value, 0, value.length);
        }
    }

    private static class DateWriter
    extends ArrowVectorWriter {
        private final DateDayVector writer;

        DateWriter(DateDayVector vector) {
            super(vector);
            this.writer = vector;
        }

        @Override
        final void setInt(int rowId, int value) {
            this.writer.setSafe(rowId, value);
        }

        @Override
        void setInts(int rowId, int count, int value) {
            for (int i = 0; i < count; ++i) {
                this.writer.setSafe(rowId + i, value);
            }
        }

        @Override
        final void setNull(int rowId) {
            this.writer.setNull(rowId);
        }

        @Override
        final void setNulls(int rowId, int count) {
            for (int i = 0; i < count; ++i) {
                this.writer.setNull(rowId + i);
            }
        }

        @Override
        void setValueNullSafe(SpecializedGetters input, int ordinal) {
            this.setInt(this.count, input.getInt(ordinal));
        }

        @Override
        void unsafeSetValueNullSafe(SpecializedGetters input, int ordinal) {
            this.writer.set(this.count, input.getInt(ordinal));
        }
    }

    private static class TimestampMicroWriter
    extends ArrowVectorWriter {
        private final TimeStampVector writer;

        TimestampMicroWriter(TimeStampVector vector) {
            super(vector);
            this.writer = vector;
        }

        @Override
        void setLongs(int rowId, int count, long value) {
            for (int i = 0; i < count; ++i) {
                this.writer.setSafe(rowId + i, value);
            }
        }

        @Override
        void setLong(int rowId, long value) {
            this.writer.setSafe(rowId, value);
        }

        @Override
        final void setNull(int rowId) {
            this.writer.setNull(rowId);
        }

        @Override
        final void setNulls(int rowId, int count) {
            for (int i = 0; i < count; ++i) {
                this.writer.setNull(rowId + i);
            }
        }

        @Override
        void setValueNullSafe(SpecializedGetters input, int ordinal) {
            this.setLong(this.count, input.getLong(ordinal));
        }

        @Override
        void unsafeSetValueNullSafe(SpecializedGetters input, int ordinal) {
            this.writer.set(this.count, input.getLong(ordinal));
        }
    }

    private static class MapWriter
    extends ArrowVectorWriter {
        private final MapVector writer;
        private StructVector structVector;
        private final ArrowVectorWriter keyWriter;
        private final ArrowVectorWriter valueWriter;

        MapWriter(MapVector mapVector, StructVector structVector, ArrowVectorWriter mapWriter, ArrowVectorWriter valueWriter) {
            super(mapVector);
            this.writer = mapVector;
            this.structVector = structVector;
            this.keyWriter = mapWriter;
            this.valueWriter = valueWriter;
        }

        @Override
        void setNull(int rowId) {
        }

        @Override
        void setValueNullSafe(SpecializedGetters input, int ordinal) {
            MapData mapData = input.getMap(ordinal);
            this.writer.startNewValue(this.count);
            ArrayData keys = mapData.keyArray();
            ArrayData values = mapData.valueArray();
            for (int i = 0; i < mapData.numElements(); ++i) {
                this.structVector.setIndexDefined(i);
                this.keyWriter.write((SpecializedGetters)keys, i);
                this.valueWriter.write((SpecializedGetters)values, i);
            }
            this.writer.endValue(this.count, mapData.numElements());
        }

        @Override
        void unsafeSetValueNullSafe(SpecializedGetters input, int ordinal) {
            int i;
            MapData mapData = input.getMap(ordinal);
            this.writer.startNewValue(this.count);
            ArrayData keys = mapData.keyArray();
            ArrayData values = mapData.valueArray();
            for (i = 0; i < mapData.numElements(); ++i) {
                this.keyWriter.write((SpecializedGetters)keys, i);
            }
            for (i = 0; i < mapData.numElements(); ++i) {
                this.valueWriter.write((SpecializedGetters)values, i);
            }
            this.writer.endValue(this.count, mapData.numElements());
        }

        @Override
        void finish() {
            super.finish();
            this.keyWriter.finish();
            this.valueWriter.finish();
        }

        @Override
        void reset() {
            super.reset();
            this.keyWriter.reset();
            this.valueWriter.reset();
        }
    }

    private static class ArrayWriter
    extends ArrowVectorWriter {
        private final ListVector writer;
        private final ArrowVectorWriter elementWriter;

        ArrayWriter(ListVector vector, ArrowVectorWriter elementVector) {
            super(vector);
            this.writer = vector;
            this.elementWriter = elementVector;
        }

        @Override
        void setArray(int rowId, int offset, int length) {
            int index = rowId * 4;
            this.writer.getOffsetBuffer().setInt(index, offset);
            this.writer.getOffsetBuffer().setInt(index + 4, offset + length);
            this.writer.setNotNull(rowId);
        }

        @Override
        final void setNull(int rowId) {
            this.writer.setNull(rowId);
        }

        @Override
        void setValueNullSafe(SpecializedGetters input, int ordinal) {
            ArrayData arrayData = input.getArray(ordinal);
            this.writer.startNewValue(this.count);
            for (int i = 0; i < arrayData.numElements(); ++i) {
                this.elementWriter.write((SpecializedGetters)arrayData, i);
            }
            this.writer.endValue(this.count, arrayData.numElements());
        }

        @Override
        void unsafeSetValueNullSafe(SpecializedGetters input, int ordinal) {
            ArrayData arrayData = input.getArray(ordinal);
            this.writer.startNewValue(this.count);
            for (int i = 0; i < arrayData.numElements(); ++i) {
                this.elementWriter.write((SpecializedGetters)arrayData, i);
            }
            this.writer.endValue(this.count, arrayData.numElements());
        }

        @Override
        void finish() {
            super.finish();
            this.elementWriter.finish();
        }

        @Override
        void reset() {
            super.reset();
            this.elementWriter.reset();
        }
    }

    private static class StructWriter
    extends ArrowVectorWriter {
        private final StructVector writer;
        private final ArrowVectorWriter[] childrenWriter;

        StructWriter(StructVector vector, ArrowVectorWriter[] childrenWriter) {
            super(vector);
            this.writer = vector;
            this.childrenWriter = childrenWriter;
        }

        @Override
        void setNull(int rowId) {
            for (int i = 0; i < this.childrenWriter.length; ++i) {
                this.childrenWriter[i].setNull(rowId);
                ++this.childrenWriter[i].count;
            }
            this.writer.setNull(rowId);
        }

        @Override
        void setNotNull(int rowId) {
            this.writer.setIndexDefined(rowId);
        }

        @Override
        void setValueNullSafe(SpecializedGetters input, int ordinal) {
            InternalRow struct = input.getStruct(ordinal, this.childrenWriter.length);
            this.writer.setIndexDefined(this.count);
            for (int i = 0; i < struct.numFields(); ++i) {
                this.childrenWriter[i].write((SpecializedGetters)struct, i);
            }
        }

        @Override
        void unsafeSetValueNullSafe(SpecializedGetters input, int ordinal) {
            InternalRow struct = input.getStruct(ordinal, this.childrenWriter.length);
            this.writer.setIndexDefined(this.count);
            for (int i = 0; i < struct.numFields(); ++i) {
                this.childrenWriter[i].write((SpecializedGetters)struct, i);
            }
        }

        @Override
        void finish() {
            super.finish();
            Arrays.stream(this.childrenWriter).forEach(c -> c.finish());
        }

        @Override
        void reset() {
            super.reset();
            Arrays.stream(this.childrenWriter).forEach(c -> c.reset());
        }
    }

    private static class NullWriter
    extends ArrowVectorWriter {
        private final NullVector writer;

        NullWriter(NullVector vector) {
            super(vector);
            this.writer = vector;
        }

        @Override
        void setNull(int rowId) {
            this.writer.setValueCount(this.writer.getValueCount() + 1);
        }

        @Override
        void setValueNullSafe(SpecializedGetters input, int ordinal) {
            this.setNull(this.count);
        }

        @Override
        void unsafeSetValueNullSafe(SpecializedGetters input, int ordinal) {
            this.writer.setValueCount(this.writer.getValueCount() + 1);
        }
    }
}

