/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gluten.vectorized;

import java.math.BigDecimal;
import org.apache.gluten.shaded.org.apache.arrow.vector.BigIntVector;
import org.apache.gluten.shaded.org.apache.arrow.vector.BitVector;
import org.apache.gluten.shaded.org.apache.arrow.vector.DateDayVector;
import org.apache.gluten.shaded.org.apache.arrow.vector.DecimalVector;
import org.apache.gluten.shaded.org.apache.arrow.vector.DurationVector;
import org.apache.gluten.shaded.org.apache.arrow.vector.Float4Vector;
import org.apache.gluten.shaded.org.apache.arrow.vector.Float8Vector;
import org.apache.gluten.shaded.org.apache.arrow.vector.IntVector;
import org.apache.gluten.shaded.org.apache.arrow.vector.IntervalYearVector;
import org.apache.gluten.shaded.org.apache.arrow.vector.NullVector;
import org.apache.gluten.shaded.org.apache.arrow.vector.SmallIntVector;
import org.apache.gluten.shaded.org.apache.arrow.vector.TimeStampMicroTZVector;
import org.apache.gluten.shaded.org.apache.arrow.vector.TimeStampMicroVector;
import org.apache.gluten.shaded.org.apache.arrow.vector.TinyIntVector;
import org.apache.gluten.shaded.org.apache.arrow.vector.ValueVector;
import org.apache.gluten.shaded.org.apache.arrow.vector.VarBinaryVector;
import org.apache.gluten.shaded.org.apache.arrow.vector.VarCharVector;
import org.apache.gluten.shaded.org.apache.arrow.vector.complex.ListVector;
import org.apache.gluten.shaded.org.apache.arrow.vector.complex.MapVector;
import org.apache.gluten.shaded.org.apache.arrow.vector.complex.StructVector;
import org.apache.gluten.shaded.org.apache.arrow.vector.holders.NullableVarCharHolder;
import org.apache.spark.annotation.DeveloperApi;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.utils.SparkArrowUtil;
import org.apache.spark.sql.vectorized.ColumnVector;
import org.apache.spark.sql.vectorized.ColumnarArray;
import org.apache.spark.sql.vectorized.ColumnarMap;
import org.apache.spark.unsafe.types.UTF8String;

@DeveloperApi
public class ArrowColumnVector
extends ColumnVector {
    ArrowVectorAccessor accessor;
    ArrowColumnVector[] childColumns;

    public ValueVector getValueVector() {
        return this.accessor.vector;
    }

    public boolean hasNull() {
        return this.accessor.getNullCount() > 0;
    }

    public int numNulls() {
        return this.accessor.getNullCount();
    }

    public void close() {
        if (this.childColumns != null) {
            for (int i = 0; i < this.childColumns.length; ++i) {
                this.childColumns[i].close();
                this.childColumns[i] = null;
            }
            this.childColumns = null;
        }
        this.accessor.close();
    }

    public boolean isNullAt(int rowId) {
        return this.accessor.isNullAt(rowId);
    }

    public boolean getBoolean(int rowId) {
        return this.accessor.getBoolean(rowId);
    }

    public byte getByte(int rowId) {
        return this.accessor.getByte(rowId);
    }

    public short getShort(int rowId) {
        return this.accessor.getShort(rowId);
    }

    public int getInt(int rowId) {
        return this.accessor.getInt(rowId);
    }

    public long getLong(int rowId) {
        return this.accessor.getLong(rowId);
    }

    public float getFloat(int rowId) {
        return this.accessor.getFloat(rowId);
    }

    public double getDouble(int rowId) {
        return this.accessor.getDouble(rowId);
    }

    public Decimal getDecimal(int rowId, int precision, int scale) {
        if (this.isNullAt(rowId)) {
            return null;
        }
        return this.accessor.getDecimal(rowId, precision, scale);
    }

    public UTF8String getUTF8String(int rowId) {
        if (this.isNullAt(rowId)) {
            return null;
        }
        return this.accessor.getUTF8String(rowId);
    }

    public byte[] getBinary(int rowId) {
        if (this.isNullAt(rowId)) {
            return null;
        }
        return this.accessor.getBinary(rowId);
    }

    public ColumnarArray getArray(int rowId) {
        if (this.isNullAt(rowId)) {
            return null;
        }
        return this.accessor.getArray(rowId);
    }

    public ColumnarMap getMap(int rowId) {
        if (this.isNullAt(rowId)) {
            return null;
        }
        return this.accessor.getMap(rowId);
    }

    public ArrowColumnVector getChild(int ordinal) {
        return this.childColumns[ordinal];
    }

    ArrowColumnVector(DataType type) {
        super(type);
    }

    public ArrowColumnVector(ValueVector vector) {
        this(SparkArrowUtil.fromArrowField(vector.getField()));
        this.initAccessor(vector);
    }

    void initAccessor(ValueVector vector) {
        if (vector instanceof BitVector) {
            this.accessor = new BooleanAccessor((BitVector)vector);
        } else if (vector instanceof TinyIntVector) {
            this.accessor = new ByteAccessor((TinyIntVector)vector);
        } else if (vector instanceof SmallIntVector) {
            this.accessor = new ShortAccessor((SmallIntVector)vector);
        } else if (vector instanceof IntVector) {
            this.accessor = new IntAccessor((IntVector)vector);
        } else if (vector instanceof BigIntVector) {
            this.accessor = new LongAccessor((BigIntVector)vector);
        } else if (vector instanceof Float4Vector) {
            this.accessor = new FloatAccessor((Float4Vector)vector);
        } else if (vector instanceof Float8Vector) {
            this.accessor = new DoubleAccessor((Float8Vector)vector);
        } else if (vector instanceof DecimalVector) {
            this.accessor = new DecimalAccessor((DecimalVector)vector);
        } else if (vector instanceof VarCharVector) {
            this.accessor = new StringAccessor((VarCharVector)vector);
        } else if (vector instanceof VarBinaryVector) {
            this.accessor = new BinaryAccessor((VarBinaryVector)vector);
        } else if (vector instanceof DateDayVector) {
            this.accessor = new DateAccessor((DateDayVector)vector);
        } else if (vector instanceof TimeStampMicroTZVector) {
            this.accessor = new TimestampAccessor((TimeStampMicroTZVector)vector);
        } else if (vector instanceof TimeStampMicroVector) {
            this.accessor = new TimestampNTZAccessor((TimeStampMicroVector)vector);
        } else if (vector instanceof MapVector) {
            MapVector mapVector = (MapVector)vector;
            this.accessor = new MapAccessor(mapVector);
        } else if (vector instanceof ListVector) {
            ListVector listVector = (ListVector)vector;
            this.accessor = new ArrayAccessor(listVector);
        } else if (vector instanceof StructVector) {
            StructVector structVector = (StructVector)vector;
            this.accessor = new StructAccessor(structVector);
            this.childColumns = new ArrowColumnVector[structVector.size()];
            for (int i = 0; i < this.childColumns.length; ++i) {
                this.childColumns[i] = new ArrowColumnVector(structVector.getVectorById(i));
            }
        } else if (vector instanceof NullVector) {
            this.accessor = new NullAccessor((NullVector)vector);
        } else if (vector instanceof IntervalYearVector) {
            this.accessor = new IntervalYearAccessor((IntervalYearVector)vector);
        } else if (vector instanceof DurationVector) {
            this.accessor = new DurationAccessor((DurationVector)vector);
        } else {
            throw new UnsupportedOperationException();
        }
    }

    static abstract class ArrowVectorAccessor {
        final ValueVector vector;

        ArrowVectorAccessor(ValueVector vector) {
            this.vector = vector;
        }

        boolean isNullAt(int rowId) {
            return this.vector.isNull(rowId);
        }

        final int getNullCount() {
            return this.vector.getNullCount();
        }

        final void close() {
            this.vector.close();
        }

        boolean getBoolean(int rowId) {
            throw new UnsupportedOperationException();
        }

        byte getByte(int rowId) {
            throw new UnsupportedOperationException();
        }

        short getShort(int rowId) {
            throw new UnsupportedOperationException();
        }

        int getInt(int rowId) {
            throw new UnsupportedOperationException();
        }

        long getLong(int rowId) {
            throw new UnsupportedOperationException();
        }

        float getFloat(int rowId) {
            throw new UnsupportedOperationException();
        }

        double getDouble(int rowId) {
            throw new UnsupportedOperationException();
        }

        Decimal getDecimal(int rowId, int precision, int scale) {
            throw new UnsupportedOperationException();
        }

        UTF8String getUTF8String(int rowId) {
            throw new UnsupportedOperationException();
        }

        byte[] getBinary(int rowId) {
            throw new UnsupportedOperationException();
        }

        ColumnarArray getArray(int rowId) {
            throw new UnsupportedOperationException();
        }

        ColumnarMap getMap(int rowId) {
            throw new UnsupportedOperationException();
        }
    }

    static class BooleanAccessor
    extends ArrowVectorAccessor {
        private final BitVector accessor;

        BooleanAccessor(BitVector vector) {
            super(vector);
            this.accessor = vector;
        }

        @Override
        final boolean getBoolean(int rowId) {
            return this.accessor.get(rowId) == 1;
        }
    }

    static class ByteAccessor
    extends ArrowVectorAccessor {
        private final TinyIntVector accessor;

        ByteAccessor(TinyIntVector vector) {
            super(vector);
            this.accessor = vector;
        }

        @Override
        final byte getByte(int rowId) {
            return this.accessor.get(rowId);
        }
    }

    static class ShortAccessor
    extends ArrowVectorAccessor {
        private final SmallIntVector accessor;

        ShortAccessor(SmallIntVector vector) {
            super(vector);
            this.accessor = vector;
        }

        @Override
        final short getShort(int rowId) {
            return this.accessor.get(rowId);
        }
    }

    static class IntAccessor
    extends ArrowVectorAccessor {
        private final IntVector accessor;

        IntAccessor(IntVector vector) {
            super(vector);
            this.accessor = vector;
        }

        @Override
        final int getInt(int rowId) {
            return this.accessor.get(rowId);
        }
    }

    static class LongAccessor
    extends ArrowVectorAccessor {
        private final BigIntVector accessor;

        LongAccessor(BigIntVector vector) {
            super(vector);
            this.accessor = vector;
        }

        @Override
        final long getLong(int rowId) {
            return this.accessor.get(rowId);
        }
    }

    static class FloatAccessor
    extends ArrowVectorAccessor {
        private final Float4Vector accessor;

        FloatAccessor(Float4Vector vector) {
            super(vector);
            this.accessor = vector;
        }

        @Override
        final float getFloat(int rowId) {
            return this.accessor.get(rowId);
        }
    }

    static class DoubleAccessor
    extends ArrowVectorAccessor {
        private final Float8Vector accessor;

        DoubleAccessor(Float8Vector vector) {
            super(vector);
            this.accessor = vector;
        }

        @Override
        final double getDouble(int rowId) {
            return this.accessor.get(rowId);
        }
    }

    static class DecimalAccessor
    extends ArrowVectorAccessor {
        private final DecimalVector accessor;

        DecimalAccessor(DecimalVector vector) {
            super(vector);
            this.accessor = vector;
        }

        @Override
        final Decimal getDecimal(int rowId, int precision, int scale) {
            if (this.isNullAt(rowId)) {
                return null;
            }
            return Decimal.apply((BigDecimal)this.accessor.getObject(rowId), (int)precision, (int)scale);
        }
    }

    static class StringAccessor
    extends ArrowVectorAccessor {
        private final VarCharVector accessor;
        private final NullableVarCharHolder stringResult = new NullableVarCharHolder();

        StringAccessor(VarCharVector vector) {
            super(vector);
            this.accessor = vector;
        }

        @Override
        final UTF8String getUTF8String(int rowId) {
            this.accessor.get(rowId, this.stringResult);
            if (this.stringResult.isSet == 0) {
                return null;
            }
            return UTF8String.fromAddress(null, (long)(this.stringResult.buffer.memoryAddress() + (long)this.stringResult.start), (int)(this.stringResult.end - this.stringResult.start));
        }
    }

    static class BinaryAccessor
    extends ArrowVectorAccessor {
        private final VarBinaryVector accessor;

        BinaryAccessor(VarBinaryVector vector) {
            super(vector);
            this.accessor = vector;
        }

        @Override
        final byte[] getBinary(int rowId) {
            return this.accessor.getObject(rowId);
        }
    }

    static class DateAccessor
    extends ArrowVectorAccessor {
        private final DateDayVector accessor;

        DateAccessor(DateDayVector vector) {
            super(vector);
            this.accessor = vector;
        }

        @Override
        final int getInt(int rowId) {
            return this.accessor.get(rowId);
        }
    }

    static class TimestampAccessor
    extends ArrowVectorAccessor {
        private final TimeStampMicroTZVector accessor;

        TimestampAccessor(TimeStampMicroTZVector vector) {
            super(vector);
            this.accessor = vector;
        }

        @Override
        final long getLong(int rowId) {
            return this.accessor.get(rowId);
        }
    }

    static class TimestampNTZAccessor
    extends ArrowVectorAccessor {
        private final TimeStampMicroVector accessor;

        TimestampNTZAccessor(TimeStampMicroVector vector) {
            super(vector);
            this.accessor = vector;
        }

        @Override
        final long getLong(int rowId) {
            return this.accessor.get(rowId);
        }
    }

    static class MapAccessor
    extends ArrowVectorAccessor {
        private final MapVector accessor;
        private final ArrowColumnVector keys;
        private final ArrowColumnVector values;

        MapAccessor(MapVector vector) {
            super(vector);
            this.accessor = vector;
            StructVector entries = (StructVector)vector.getDataVector();
            this.keys = new ArrowColumnVector(entries.getChild("key"));
            this.values = new ArrowColumnVector(entries.getChild("value"));
        }

        @Override
        final ColumnarMap getMap(int rowId) {
            int index = rowId * 4;
            int offset = this.accessor.getOffsetBuffer().getInt(index);
            int length = this.accessor.getInnerValueCountAt(rowId);
            return new ColumnarMap((ColumnVector)this.keys, (ColumnVector)this.values, offset, length);
        }
    }

    static class ArrayAccessor
    extends ArrowVectorAccessor {
        private final ListVector accessor;
        private final ArrowColumnVector arrayData;

        ArrayAccessor(ListVector vector) {
            super(vector);
            this.accessor = vector;
            this.arrayData = new ArrowColumnVector(vector.getDataVector());
        }

        @Override
        final boolean isNullAt(int rowId) {
            if (this.accessor.getValueCount() > 0 && this.accessor.getValidityBuffer().capacity() == 0L) {
                return false;
            }
            return super.isNullAt(rowId);
        }

        @Override
        final ColumnarArray getArray(int rowId) {
            int start = this.accessor.getElementStartIndex(rowId);
            int end = this.accessor.getElementEndIndex(rowId);
            return new ColumnarArray((ColumnVector)this.arrayData, start, end - start);
        }
    }

    static class StructAccessor
    extends ArrowVectorAccessor {
        StructAccessor(StructVector vector) {
            super(vector);
        }
    }

    static class NullAccessor
    extends ArrowVectorAccessor {
        NullAccessor(NullVector vector) {
            super(vector);
        }
    }

    static class IntervalYearAccessor
    extends ArrowVectorAccessor {
        private final IntervalYearVector accessor;

        IntervalYearAccessor(IntervalYearVector vector) {
            super(vector);
            this.accessor = vector;
        }

        @Override
        int getInt(int rowId) {
            return this.accessor.get(rowId);
        }
    }

    static class DurationAccessor
    extends ArrowVectorAccessor {
        private final DurationVector accessor;

        DurationAccessor(DurationVector vector) {
            super(vector);
            this.accessor = vector;
        }

        @Override
        final long getLong(int rowId) {
            return DurationVector.get(this.accessor.getDataBuffer(), rowId);
        }
    }
}

