/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gluten.utils;

import io.netty.util.internal.PlatformDependent;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.commons.io.IOUtils;
import org.apache.gluten.backendsapi.BackendsApiManager;
import org.apache.gluten.runtime.Runtimes;
import org.apache.gluten.utils.VeloxBloomFilterJniWrapper;
import org.apache.spark.util.sketch.BloomFilter;
import org.apache.spark.util.sketch.IncompatibleMergeException;

public class VeloxBloomFilter
extends BloomFilter {
    private final VeloxBloomFilterJniWrapper jni = VeloxBloomFilterJniWrapper.create(Runtimes.contextInstance(BackendsApiManager.getBackendName(), "VeloxBloomFilter"));
    private final long handle;

    private VeloxBloomFilter(byte[] data) {
        this.handle = this.jni.init(data);
    }

    private VeloxBloomFilter(int capacity) {
        this.handle = this.jni.empty(capacity);
    }

    public static VeloxBloomFilter empty(int capacity) {
        return new VeloxBloomFilter(capacity);
    }

    public static VeloxBloomFilter readFrom(InputStream in) {
        try {
            byte[] data = IOUtils.toByteArray((InputStream)in);
            return new VeloxBloomFilter(data);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static VeloxBloomFilter readFrom(byte[] data) {
        return new VeloxBloomFilter(data);
    }

    public byte[] serialize() {
        byte[] byArray;
        ByteArrayOutputStream o = new ByteArrayOutputStream();
        try {
            this.writeTo(o);
            byArray = o.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    o.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        o.close();
        return byArray;
    }

    public double expectedFpp() {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public long bitSize() {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public boolean put(Object item) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public boolean putString(String item) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public boolean putLong(long item) {
        this.jni.insertLong(this.handle, item);
        return true;
    }

    public boolean putBinary(byte[] item) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public boolean isCompatible(BloomFilter other) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public BloomFilter mergeInPlace(BloomFilter other) throws IncompatibleMergeException {
        if (!(other instanceof VeloxBloomFilter)) {
            throw new IncompatibleMergeException("Cannot merge Velox bloom-filter with non-Velox bloom-filter");
        }
        VeloxBloomFilter from = (VeloxBloomFilter)other;
        if (!this.jni.isCompatibleWith(from.jni)) {
            throw new IncompatibleMergeException("Cannot merge Velox bloom-filters with different Velox runtimes");
        }
        this.jni.mergeFrom(this.handle, from.handle);
        return this;
    }

    public BloomFilter intersectInPlace(BloomFilter other) throws IncompatibleMergeException {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public boolean mightContain(Object item) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public boolean mightContainString(String item) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public boolean mightContainLong(long item) {
        return this.jni.mightContainLong(this.handle, item);
    }

    public static boolean mightContainLongOnSerializedBloom(ByteBuffer serializedBloom, long item) {
        return VeloxBloomFilter.mightContainLongOnSerializedBloom(PlatformDependent.directBufferAddress((ByteBuffer)serializedBloom), item);
    }

    public static boolean mightContainLongOnSerializedBloom(long address, long item) {
        return VeloxBloomFilterJniWrapper.mightContainLongOnSerializedBloom(address, item);
    }

    public ByteBuffer serializeToDirectBuffer() {
        byte[] serialized = this.serialize();
        ByteBuffer bb = ByteBuffer.allocateDirect(serialized.length);
        bb.put(serialized);
        return bb;
    }

    public boolean mightContainBinary(byte[] item) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public void writeTo(OutputStream out) throws IOException {
        byte[] data = this.jni.serialize(this.handle);
        out.write(data);
    }
}

