/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gluten.utils;

import io.substrait.proto.CrossRel;
import io.substrait.proto.JoinRel;
import io.substrait.proto.NamedStruct;
import io.substrait.proto.Type;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import org.apache.gluten.backendsapi.BackendsApiManager$;
import org.apache.gluten.expression.ConverterUtils$;
import org.apache.gluten.expression.ExpressionConverter$;
import org.apache.gluten.shaded.com.google.protobuf.Any;
import org.apache.gluten.shaded.com.google.protobuf.DoubleValue;
import org.apache.gluten.shaded.com.google.protobuf.GeneratedMessageV3;
import org.apache.gluten.shaded.com.google.protobuf.Int32Value;
import org.apache.gluten.shaded.com.google.protobuf.Int64Value;
import org.apache.gluten.shaded.com.google.protobuf.StringValue;
import org.apache.gluten.substrait.SubstraitContext;
import org.apache.gluten.substrait.expression.ExpressionNode;
import org.apache.gluten.substrait.type.ColumnTypeNode;
import org.apache.gluten.substrait.type.TypeBuilder;
import org.apache.gluten.substrait.type.TypeNode;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.plans.ExistenceJoin;
import org.apache.spark.sql.catalyst.plans.FullOuter$;
import org.apache.spark.sql.catalyst.plans.InnerLike;
import org.apache.spark.sql.catalyst.plans.JoinType;
import org.apache.spark.sql.catalyst.plans.LeftAnti$;
import org.apache.spark.sql.catalyst.plans.LeftOuter$;
import org.apache.spark.sql.catalyst.plans.LeftSemi$;
import org.apache.spark.sql.catalyst.plans.RightOuter$;
import scala.Function1;
import scala.Predef$;
import scala.collection.IterableOnceOps;
import scala.collection.JavaConverters$;
import scala.collection.Seq;

public final class SubstraitUtil$ {
    public static final SubstraitUtil$ MODULE$ = new SubstraitUtil$();

    public JoinRel.JoinType toSubstrait(JoinType sparkJoin) {
        JoinType joinType = sparkJoin;
        if (joinType instanceof InnerLike) {
            return JoinRel.JoinType.JOIN_TYPE_INNER;
        }
        if (FullOuter$.MODULE$.equals(joinType)) {
            return JoinRel.JoinType.JOIN_TYPE_OUTER;
        }
        if (LeftOuter$.MODULE$.equals(joinType) ? true : RightOuter$.MODULE$.equals(joinType)) {
            return JoinRel.JoinType.JOIN_TYPE_LEFT;
        }
        if (LeftSemi$.MODULE$.equals(joinType)) {
            return JoinRel.JoinType.JOIN_TYPE_LEFT_SEMI;
        }
        if (LeftAnti$.MODULE$.equals(joinType)) {
            return JoinRel.JoinType.JOIN_TYPE_LEFT_ANTI;
        }
        return JoinRel.JoinType.UNRECOGNIZED;
    }

    public CrossRel.JoinType toCrossRelSubstrait(JoinType sparkJoin) {
        JoinType joinType = sparkJoin;
        if (joinType instanceof InnerLike) {
            return CrossRel.JoinType.JOIN_TYPE_INNER;
        }
        if (LeftOuter$.MODULE$.equals(joinType) ? true : RightOuter$.MODULE$.equals(joinType)) {
            return CrossRel.JoinType.JOIN_TYPE_LEFT;
        }
        if (LeftSemi$.MODULE$.equals(joinType) ? true : joinType instanceof ExistenceJoin) {
            return CrossRel.JoinType.JOIN_TYPE_LEFT_SEMI;
        }
        if (FullOuter$.MODULE$.equals(joinType)) {
            return CrossRel.JoinType.JOIN_TYPE_OUTER;
        }
        return CrossRel.JoinType.UNRECOGNIZED;
    }

    public Any createEnhancement(scala.collection.immutable.Seq<Attribute> output) {
        scala.collection.immutable.Seq inputTypeNodes = (scala.collection.immutable.Seq)output.map((Function1 & Serializable)attr -> ConverterUtils$.MODULE$.getTypeNode(attr.dataType(), attr.nullable()));
        return BackendsApiManager$.MODULE$.getTransformerApiInstance().packPBMessage(TypeBuilder.makeStruct(Predef$.MODULE$.boolean2Boolean(false), (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)inputTypeNodes).asJava()).toProtobuf());
    }

    public ExpressionNode toSubstraitExpression(Expression expr, scala.collection.immutable.Seq<Attribute> attributeSeq, SubstraitContext context) {
        return ExpressionConverter$.MODULE$.replaceWithExpressionTransformer(expr, attributeSeq).doTransform(context);
    }

    public NamedStruct.Builder createNameStructBuilder(List<TypeNode> types, List<String> names, List<ColumnTypeNode> columnTypeNodes) {
        Type.Struct.Builder structBuilder = Type.Struct.newBuilder();
        ((IterableOnceOps)JavaConverters$.MODULE$.asScalaBufferConverter(types).asScala()).foreach((Function1 & Serializable)t2 -> structBuilder.addTypes(t2.toProtobuf()));
        NamedStruct.Builder namedStructBuilder = NamedStruct.newBuilder();
        namedStructBuilder.setStruct(structBuilder.build());
        ((IterableOnceOps)JavaConverters$.MODULE$.asScalaBufferConverter(names).asScala()).foreach((Function1 & Serializable)n -> namedStructBuilder.addNames((String)n));
        ((IterableOnceOps)JavaConverters$.MODULE$.asScalaBufferConverter(columnTypeNodes).asScala()).foreach((Function1 & Serializable)c -> namedStructBuilder.addColumnTypes(c.toProtobuf()));
        return namedStructBuilder;
    }

    public NamedStruct toNameStruct(List<Attribute> output) {
        List<TypeNode> typeList = ConverterUtils$.MODULE$.collectAttributeTypeNodes(output);
        List<String> nameList = ConverterUtils$.MODULE$.collectAttributeNamesWithExprId(output);
        return this.createNameStructBuilder(typeList, nameList, Collections.emptyList()).build();
    }

    public Any convertJavaObjectToAny(Object obj) {
        GeneratedMessageV3 generatedMessageV3;
        if (obj == null) {
            return null;
        }
        Object object = obj;
        if (object instanceof String) {
            String string = (String)object;
            generatedMessageV3 = StringValue.newBuilder().setValue(string).build();
        } else if (object instanceof Integer) {
            Integer n = (Integer)object;
            generatedMessageV3 = Int32Value.newBuilder().setValue(Predef$.MODULE$.Integer2int(n)).build();
        } else if (object instanceof Long) {
            Long l = (Long)object;
            generatedMessageV3 = Int64Value.newBuilder().setValue(Predef$.MODULE$.Long2long(l)).build();
        } else if (object instanceof Double) {
            Double d = (Double)object;
            generatedMessageV3 = DoubleValue.newBuilder().setValue(Predef$.MODULE$.Double2double(d)).build();
        } else {
            generatedMessageV3 = StringValue.newBuilder().setValue(obj.toString()).build();
        }
        StringValue msg = generatedMessageV3;
        return BackendsApiManager$.MODULE$.getTransformerApiInstance().packPBMessage(msg);
    }

    private SubstraitUtil$() {
    }
}

