/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gluten.utils;

import java.io.Serializable;
import org.apache.gluten.utils.PartitionsUtil;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.execution.datasources.FilePartition;
import org.apache.spark.sql.execution.datasources.HadoopFsRelation;
import org.apache.spark.sql.execution.datasources.PartitionDirectory;
import org.apache.spark.sql.execution.datasources.PartitionedFile;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.util.collection.BitSet;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple8;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.SeqOps;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.PriorityQueue;
import scala.collection.mutable.PriorityQueue$;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

public final class PartitionsUtil$
implements Serializable {
    public static final PartitionsUtil$ MODULE$ = new PartitionsUtil$();

    public Seq<FilePartition> regeneratePartition(Seq<FilePartition> inputPartitions, double smallFileThreshold) {
        ArrayBuffer[] partitions = (ArrayBuffer[])Array$.MODULE$.fill(inputPartitions.size(), (Function0 & Serializable)() -> ArrayBuffer$.MODULE$.empty(), ClassTag$.MODULE$.apply(ArrayBuffer.class));
        Seq filesSorted = (Seq)((SeqOps)((IterableOps)inputPartitions.flatMap((Function1 & Serializable)x$7 -> Predef$.MODULE$.wrapRefArray((Object[])x$7.files()))).map((Function1 & Serializable)f -> new Tuple2(f, (Object)BoxesRunTime.boxToLong((long)f.length())))).sortBy((Function1 & Serializable)x$8 -> BoxesRunTime.boxToLong((long)x$8._2$mcJ$sp()), Ordering.Long$.MODULE$.reverse());
        Ordering sizeFirstOrdering = package$.MODULE$.Ordering().by((Function1 & Serializable)x0$1 -> {
            Tuple3 tuple3 = x0$1;
            if (tuple3 != null) {
                long size = BoxesRunTime.unboxToLong((Object)tuple3._1());
                int numFiles = BoxesRunTime.unboxToInt((Object)tuple3._2());
                return new Tuple2.mcJI.sp(size, numFiles);
            }
            throw new MatchError((Object)tuple3);
        }, Ordering$.MODULE$.Tuple2((Ordering)Ordering.Long$.MODULE$, (Ordering)Ordering.Int$.MODULE$)).reverse();
        if (smallFileThreshold > 0.0) {
            double smallFileTotalSize = (double)BoxesRunTime.unboxToLong((Object)((IterableOnceOps)filesSorted.map((Function1 & Serializable)x$9 -> BoxesRunTime.boxToLong((long)x$9._2$mcJ$sp()))).sum((Numeric)Numeric.LongIsIntegral$.MODULE$)) * smallFileThreshold;
            Ordering numFirstOrdering = package$.MODULE$.Ordering().by((Function1 & Serializable)x0$2 -> {
                Tuple3 tuple3 = x0$2;
                if (tuple3 != null) {
                    long size = BoxesRunTime.unboxToLong((Object)tuple3._1());
                    int numFiles = BoxesRunTime.unboxToInt((Object)tuple3._2());
                    return new Tuple2.mcIJ.sp(numFiles, size);
                }
                throw new MatchError((Object)tuple3);
            }, Ordering$.MODULE$.Tuple2((Ordering)Ordering.Int$.MODULE$, (Ordering)Ordering.Long$.MODULE$)).reverse();
            PriorityQueue heapByFileNum = PartitionsUtil$.initializeHeap$1(numFirstOrdering, inputPartitions);
            IntRef numSmallFiles = IntRef.create((int)0);
            LongRef smallFileSize = LongRef.create((long)0L);
            filesSorted.reverseIterator().takeWhile((Function1 & Serializable)f -> BoxesRunTime.boxToBoolean((boolean)PartitionsUtil$.$anonfun$regeneratePartition$9(smallFileSize, smallFileTotalSize, f))).foreach((Function1 & Serializable)x0$3 -> {
                PartitionsUtil$.$anonfun$regeneratePartition$10(heapByFileNum, numSmallFiles, smallFileSize, partitions, x0$3);
                return BoxedUnit.UNIT;
            });
            PriorityQueue heapByFileSize = PriorityQueue$.MODULE$.empty(sizeFirstOrdering);
            while (heapByFileNum.nonEmpty()) {
                heapByFileSize.enqueue((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple3[]{(Tuple3)heapByFileNum.dequeue()}));
            }
            ((IterableOnceOps)filesSorted.take(filesSorted.size() - numSmallFiles.elem)).foreach((Function1 & Serializable)x0$4 -> {
                PartitionsUtil$.$anonfun$regeneratePartition$11(heapByFileSize, partitions, x0$4);
                return BoxedUnit.UNIT;
            });
        } else {
            PriorityQueue heapByFileSize = PartitionsUtil$.initializeHeap$1(sizeFirstOrdering, inputPartitions);
            filesSorted.foreach((Function1 & Serializable)x0$5 -> {
                PartitionsUtil$.$anonfun$regeneratePartition$12(heapByFileSize, partitions, x0$5);
                return BoxedUnit.UNIT;
            });
        }
        return Predef$.MODULE$.copyArrayToImmutableIndexedSeq(ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zipWithIndex$extension(Predef$.MODULE$.refArrayOps((Object[])partitions))), (Function1 & Serializable)x0$6 -> {
            Tuple2 tuple2 = x0$6;
            if (tuple2 != null) {
                ArrayBuffer p = (ArrayBuffer)tuple2._1();
                int idx = tuple2._2$mcI$sp();
                return new FilePartition(idx, (PartitionedFile[])p.toArray(ClassTag$.MODULE$.apply(PartitionedFile.class)));
            }
            throw new MatchError((Object)tuple2);
        }, ClassTag$.MODULE$.apply(FilePartition.class)));
    }

    public PartitionsUtil apply(HadoopFsRelation relation, StructType requiredSchema, PartitionDirectory[] selectedPartitions, Seq<Attribute> output, boolean bucketedScan, Option<BitSet> optionalBucketSet, Option<Object> optionalNumCoalescedBuckets, boolean disableBucketedScan) {
        return new PartitionsUtil(relation, requiredSchema, selectedPartitions, output, bucketedScan, optionalBucketSet, optionalNumCoalescedBuckets, disableBucketedScan);
    }

    public Option<Tuple8<HadoopFsRelation, StructType, PartitionDirectory[], Seq<Attribute>, Object, Option<BitSet>, Option<Object>, Object>> unapply(PartitionsUtil x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some((Object)new Tuple8((Object)x$0.relation(), (Object)x$0.requiredSchema(), (Object)x$0.selectedPartitions(), x$0.output(), (Object)BoxesRunTime.boxToBoolean((boolean)x$0.bucketedScan()), x$0.optionalBucketSet(), x$0.optionalNumCoalescedBuckets(), (Object)BoxesRunTime.boxToBoolean((boolean)x$0.disableBucketedScan())));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(PartitionsUtil$.class);
    }

    private static final void addToBucket$1(PriorityQueue heap, PartitionedFile file, long fileSize, ArrayBuffer[] partitions$1) {
        Tuple3 tuple3 = (Tuple3)heap.dequeue();
        if (tuple3 == null) {
            throw new MatchError((Object)tuple3);
        }
        long size = BoxesRunTime.unboxToLong((Object)tuple3._1());
        int numFiles = BoxesRunTime.unboxToInt((Object)tuple3._2());
        int idx = BoxesRunTime.unboxToInt((Object)tuple3._3());
        Tuple3 tuple32 = new Tuple3((Object)BoxesRunTime.boxToLong((long)size), (Object)BoxesRunTime.boxToInteger((int)numFiles), (Object)BoxesRunTime.boxToInteger((int)idx));
        long size2 = BoxesRunTime.unboxToLong((Object)tuple32._1());
        int numFiles2 = BoxesRunTime.unboxToInt((Object)tuple32._2());
        int idx2 = BoxesRunTime.unboxToInt((Object)tuple32._3());
        partitions$1[idx2].$plus$eq((Object)file);
        heap.enqueue((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)BoxesRunTime.boxToLong((long)(size2 + fileSize)), (Object)BoxesRunTime.boxToInteger((int)(numFiles2 + 1)), (Object)BoxesRunTime.boxToInteger((int)idx2))}));
    }

    private static final PriorityQueue initializeHeap$1(Ordering ordering, Seq inputPartitions$1) {
        PriorityQueue heap = PriorityQueue$.MODULE$.empty(ordering);
        inputPartitions$1.indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> heap.enqueue((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)BoxesRunTime.boxToLong((long)0L), (Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToInteger((int)i))})));
        return heap;
    }

    public static final /* synthetic */ boolean $anonfun$regeneratePartition$9(LongRef smallFileSize$1, double smallFileTotalSize$1, Tuple2 f) {
        return (double)(f._2$mcJ$sp() + smallFileSize$1.elem) <= smallFileTotalSize$1;
    }

    public static final /* synthetic */ void $anonfun$regeneratePartition$10(PriorityQueue heapByFileNum$1, IntRef numSmallFiles$1, LongRef smallFileSize$1, ArrayBuffer[] partitions$1, Tuple2 x0$3) {
        Tuple2 tuple2 = x0$3;
        if (tuple2 != null) {
            PartitionedFile file = (PartitionedFile)tuple2._1();
            long fileSize = tuple2._2$mcJ$sp();
            PartitionsUtil$.addToBucket$1(heapByFileNum$1, file, fileSize, partitions$1);
            ++numSmallFiles$1.elem;
            smallFileSize$1.elem += fileSize;
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$regeneratePartition$11(PriorityQueue heapByFileSize$1, ArrayBuffer[] partitions$1, Tuple2 x0$4) {
        Tuple2 tuple2 = x0$4;
        if (tuple2 != null) {
            PartitionedFile file = (PartitionedFile)tuple2._1();
            long fileSize = tuple2._2$mcJ$sp();
            PartitionsUtil$.addToBucket$1(heapByFileSize$1, file, fileSize, partitions$1);
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$regeneratePartition$12(PriorityQueue heapByFileSize$2, ArrayBuffer[] partitions$1, Tuple2 x0$5) {
        Tuple2 tuple2 = x0$5;
        if (tuple2 != null) {
            PartitionedFile file = (PartitionedFile)tuple2._1();
            long fileSize = tuple2._2$mcJ$sp();
            PartitionsUtil$.addToBucket$1(heapByFileSize$2, file, fileSize, partitions$1);
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    private PartitionsUtil$() {
    }
}

