/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gluten.utils;

import java.io.Serializable;
import java.util.Map;
import org.apache.gluten.config.GlutenConfig$;
import org.apache.gluten.sql.shims.SparkShimLoader$;
import org.apache.gluten.utils.ExceptionUtils$;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.parquet.crypto.ParquetCryptoRuntimeException;
import org.apache.parquet.format.converter.ParquetMetadataConverter;
import org.apache.parquet.hadoop.metadata.BlockMetaData;
import org.apache.parquet.hadoop.metadata.ColumnChunkMetaData;
import org.apache.parquet.hadoop.metadata.CompressionCodecName;
import org.apache.parquet.hadoop.metadata.FileMetaData;
import org.apache.parquet.hadoop.metadata.ParquetMetadata;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.catalyst.util.RebaseDateTime;
import org.apache.spark.sql.execution.datasources.DataSourceUtils$;
import org.apache.spark.sql.execution.datasources.parquet.ParquetFooterReaderShim$;
import org.apache.spark.sql.execution.datasources.parquet.ParquetOptions;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.StringContext;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.runtime.BoxedUnit;
import scala.runtime.NonLocalReturnControl;

public final class ParquetMetadataUtils$
implements Logging {
    public static final ParquetMetadataUtils$ MODULE$ = new ParquetMetadataUtils$();
    private static transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        Logging.$init$((Logging)MODULE$);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(Map<String, String> context, Function0<BoxedUnit> body) {
        Logging.withLogContext$((Logging)this, context, body);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public Option<String> validateMetadata(Seq<String> rootPaths, Configuration hadoopConf, ParquetOptions parquetOptions, int fileLimit) {
        None$ none$;
        Object object = new Object();
        try {
            if (!GlutenConfig$.MODULE$.get().parquetMetadataValidationEnabled()) {
                none$ = None$.MODULE$;
            } else {
                rootPaths.foreach((Function1 & Serializable)rootPath -> {
                    ParquetMetadataUtils$.$anonfun$validateMetadata$1(hadoopConf, parquetOptions, fileLimit, object, rootPath);
                    return BoxedUnit.UNIT;
                });
                none$ = None$.MODULE$;
            }
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                none$ = (Option)ex.value();
            }
            throw ex;
        }
        return none$;
    }

    public Option<String> validateCodec(ParquetMetadata footer) {
        java.util.List blocks = footer.getBlocks();
        if (blocks.isEmpty()) {
            return None$.MODULE$;
        }
        CompressionCodecName codec = ((ColumnChunkMetaData)((BlockMetaData)blocks.get(0)).getColumns().get(0)).getCodec();
        Seq<CompressionCodecName> unsupportedCodec = SparkShimLoader$.MODULE$.getSparkShims().unsupportedCodec();
        if (unsupportedCodec.contains((Object)codec)) {
            return new Some((Object)("Unsupported codec " + codec.name() + "."));
        }
        return None$.MODULE$;
    }

    private Option<String> checkForUnexpectedMetadataWithLimit(FileSystem fs, Path path, Configuration conf, ParquetOptions parquetOptions, int fileLimit) {
        RemoteIterator filesIterator = fs.listFiles(path, true);
        for (int checkedFileCount = 0; filesIterator.hasNext() && checkedFileCount < fileLimit; ++checkedFileCount) {
            LocatedFileStatus fileStatus = (LocatedFileStatus)filesIterator.next();
            Option<String> metadataUnsupported = this.isUnsupportedMetadata(fileStatus, conf, parquetOptions);
            if (!metadataUnsupported.isDefined()) continue;
            return metadataUnsupported;
        }
        return None$.MODULE$;
    }

    private Option<String> isUnsupportedMetadata(LocatedFileStatus fileStatus, Configuration conf, ParquetOptions parquetOptions) {
        Option option;
        Object object = new Object();
        try {
            ParquetMetadata parquetMetadata;
            try {
                parquetMetadata = ParquetFooterReaderShim$.MODULE$.readFooter(conf, (FileStatus)fileStatus, ParquetMetadataConverter.NO_FILTER);
            }
            catch (Throwable throwable) {
                Exception exception;
                Throwable throwable2 = throwable;
                if (throwable2 instanceof Exception && ExceptionUtils$.MODULE$.hasCause(exception = (Exception)throwable2, ParquetCryptoRuntimeException.class)) {
                    return new Some((Object)"Encrypted Parquet footer detected.");
                }
                if (throwable2 instanceof RuntimeException) {
                    return None$.MODULE$;
                }
                throw throwable;
            }
            ParquetMetadata footer = parquetMetadata;
            .colon.colon validationChecks = new .colon.colon(this.validateCodec(footer), (List)new .colon.colon(this.isTimezoneFoundInMetadata(footer, parquetOptions), (List)Nil$.MODULE$));
            validationChecks.foreach((Function1 & Serializable)check -> {
                ParquetMetadataUtils$.$anonfun$isUnsupportedMetadata$1(object, check);
                return BoxedUnit.UNIT;
            });
            if (SparkShimLoader$.MODULE$.getSparkShims().isParquetFileEncrypted(footer)) {
                return new Some((Object)"Encrypted Parquet file detected.");
            }
            option = None$.MODULE$;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                option = (Option)ex.value();
            }
            throw ex;
        }
        return option;
    }

    private Option<String> isTimezoneFoundInMetadata(ParquetMetadata footer, ParquetOptions parquetOptions) {
        FileMetaData footerFileMetaData = footer.getFileMetaData();
        String datetimeRebaseModeInRead = parquetOptions.datetimeRebaseModeInRead();
        String int96RebaseModeInRead = parquetOptions.int96RebaseModeInRead();
        Map map = footerFileMetaData.getKeyValueMetaData();
        RebaseDateTime.RebaseSpec datetimeRebaseSpec = DataSourceUtils$.MODULE$.datetimeRebaseSpec((Function1 & Serializable)x$1 -> (String)map.get(x$1), datetimeRebaseModeInRead);
        Map map2 = footerFileMetaData.getKeyValueMetaData();
        RebaseDateTime.RebaseSpec int96RebaseSpec = DataSourceUtils$.MODULE$.int96RebaseSpec((Function1 & Serializable)x$1 -> (String)map2.get(x$1), int96RebaseModeInRead);
        if (datetimeRebaseSpec.originTimeZone().nonEmpty()) {
            return new Some((Object)"Legacy timezone found.");
        }
        if (int96RebaseSpec.originTimeZone().nonEmpty()) {
            return new Some((Object)"Legacy timezone found.");
        }
        return None$.MODULE$;
    }

    public static final /* synthetic */ void $anonfun$validateMetadata$1(Configuration hadoopConf$1, ParquetOptions parquetOptions$1, int fileLimit$1, Object nonLocalReturnKey1$1, String rootPath) {
        FileSystem fs = new Path(rootPath).getFileSystem(hadoopConf$1);
        try {
            Option<String> maybeReason = MODULE$.checkForUnexpectedMetadataWithLimit(fs, new Path(rootPath), hadoopConf$1, parquetOptions$1, fileLimit$1);
            if (maybeReason.isDefined()) {
                throw new NonLocalReturnControl(nonLocalReturnKey1$1, maybeReason);
            }
        }
        catch (Exception e) {
            MODULE$.logWarning((Function0<String>)(Function0 & Serializable)() -> "Catch exception when validating parquet file metadata", (Throwable)e);
        }
    }

    public static final /* synthetic */ void $anonfun$isUnsupportedMetadata$1(Object nonLocalReturnKey2$1, Option check) {
        if (check.isDefined()) {
            throw new NonLocalReturnControl(nonLocalReturnKey2$1, (Object)check);
        }
    }

    private ParquetMetadataUtils$() {
    }
}

