/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gluten.utils;

import java.io.Serializable;
import java.net.URI;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.arrow.c.ArrowSchema;
import org.apache.arrow.c.CDataDictionaryProvider;
import org.apache.arrow.c.Data;
import org.apache.arrow.dataset.file.FileFormat;
import org.apache.arrow.dataset.file.FileSystemDatasetFactory;
import org.apache.arrow.dataset.jni.NativeMemoryPool;
import org.apache.arrow.dataset.scanner.FragmentScanOptions;
import org.apache.gluten.shaded.org.apache.arrow.memory.BufferAllocator;
import org.apache.gluten.shaded.org.apache.arrow.vector.ipc.message.ArrowRecordBatch;
import org.apache.gluten.shaded.org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.gluten.shaded.org.apache.arrow.vector.types.pojo.Field;
import org.apache.gluten.shaded.org.apache.arrow.vector.types.pojo.Schema;
import org.apache.gluten.vectorized.ArrowWritableColumnVector;
import org.apache.hadoop.fs.FileStatus;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.execution.vectorized.ArrowColumnVectorUtils;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.utils.SparkArrowUtil$;
import org.apache.spark.sql.utils.SparkSchemaUtil$;
import org.apache.spark.sql.vectorized.ColumnVector;
import org.apache.spark.sql.vectorized.ColumnarBatch;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.StringContext;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.Buffer;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

public final class ArrowUtil$
implements Logging {
    public static final ArrowUtil$ MODULE$ = new ArrowUtil$();
    private static final String defaultTimeZoneId;
    private static transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        Logging.$init$((Logging)MODULE$);
        defaultTimeZoneId = SparkSchemaUtil$.MODULE$.getLocalTimezoneID();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(Map<String, String> context, Function0<BoxedUnit> body) {
        Logging.withLogContext$((Logging)this, context, body);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private String defaultTimeZoneId() {
        return defaultTimeZoneId;
    }

    private ArrowType getResultType(DataType dataType) {
        return this.getResultType(dataType, this.defaultTimeZoneId());
    }

    private ArrowType getResultType(DataType dataType, String timeZoneId) {
        DataType dataType2 = dataType;
        return SparkArrowUtil$.MODULE$.toArrowType(dataType, timeZoneId);
    }

    public Schema toArrowSchema(scala.collection.immutable.Seq<Attribute> attributes) {
        scala.collection.immutable.Seq fields = (scala.collection.immutable.Seq)attributes.map((Function1 & Serializable)attr -> Field.nullable(attr.name() + "#" + attr.exprId().id(), MODULE$.getResultType(attr.dataType())));
        return new Schema((Iterable)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)fields.toList()).asJava());
    }

    public Schema toArrowSchema(ArrowSchema cSchema, BufferAllocator allocator, CDataDictionaryProvider provider) {
        Schema schema = Data.importSchema(allocator, cSchema, provider);
        List<Field> originFields = schema.getFields();
        ArrayList<Field> fields = new ArrayList<Field>(originFields.size());
        originFields.forEach(field -> {
            DataType dt = SparkArrowUtil$.MODULE$.fromArrowField((Field)field);
            fields.add(SparkArrowUtil$.MODULE$.toArrowField(field.getName(), dt, true, SparkSchemaUtil$.MODULE$.getLocalTimezoneID()));
        });
        return new Schema(fields);
    }

    public Schema toSchema(ColumnarBatch batch) {
        ArrayList<Field> fields = new ArrayList<Field>(batch.numCols());
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), batch.numCols()).foreach((Function1)(JFunction1.mcZI.sp & Serializable)i -> {
            ColumnVector col = batch.column(i);
            ColumnVector columnVector = col;
            if (!(columnVector instanceof ArrowWritableColumnVector)) {
                throw new UnsupportedOperationException("Unexpected vector type: " + col.getClass().toString());
            }
            ArrowWritableColumnVector arrowWritableColumnVector = (ArrowWritableColumnVector)columnVector;
            return fields.add(arrowWritableColumnVector.getValueVector().getField());
        });
        return new Schema(fields);
    }

    private String rewriteUri(String encodeUri) {
        Object object;
        String sch;
        URI uri;
        block13: {
            String string;
            block12: {
                block11: {
                    block10: {
                        String decodedUri = encodeUri;
                        uri = URI.create(decodedUri);
                        String string2 = uri.getScheme();
                        String string3 = "s3";
                        if (!(string2 == null ? string3 != null : !string2.equals(string3))) break block10;
                        String string4 = uri.getScheme();
                        String string5 = "s3a";
                        if (string4 != null ? !string4.equals(string5) : string5 != null) break block11;
                    }
                    String s3Rewritten = new URI("s3", uri.getAuthority(), uri.getPath(), uri.getQuery(), uri.getFragment()).toString();
                    return s3Rewritten;
                }
                String string6 = uri.getScheme();
                switch (string6 == null ? 0 : string6.hashCode()) {
                    case 3143036: {
                        if (!"file".equals(string6)) break;
                        string = "file";
                        break block12;
                    }
                    case 3197641: {
                        if (!"hdfs".equals(string6)) break;
                        string = "hdfs";
                        break block12;
                    }
                }
                throw new MatchError((Object)string6);
            }
            sch = string;
            String string7 = uri.getScheme();
            switch (string7 == null ? 0 : string7.hashCode()) {
                case 3143036: {
                    if (!"file".equals(string7)) break;
                    object = "//" + uri.getSchemeSpecificPart();
                    break block13;
                }
                case 3197641: {
                    if (!"hdfs".equals(string7)) break;
                    object = uri.getSchemeSpecificPart();
                    break block13;
                }
            }
            throw new MatchError((Object)string7);
        }
        Object ssp = object;
        URI rewritten = new URI(sch, (String)ssp, uri.getFragment());
        return rewritten.toString();
    }

    public FileSystemDatasetFactory makeArrowDiscovery(String encodedUri, FileFormat format, Optional<FragmentScanOptions> option, BufferAllocator allocator, NativeMemoryPool pool) {
        FileSystemDatasetFactory factory = new FileSystemDatasetFactory(allocator, pool, format, this.rewriteUri(encodedUri), option);
        return factory;
    }

    public Schema readArrowSchema(String file, FileFormat format, FragmentScanOptions option, BufferAllocator allocator, NativeMemoryPool pool) {
        FileSystemDatasetFactory factory = this.makeArrowDiscovery(file, format, Optional.of(option), allocator, pool);
        Schema schema = factory.inspect();
        factory.close();
        return schema;
    }

    public String[] readArrowFileColumnNames(String file, FileFormat format, FragmentScanOptions option, BufferAllocator allocator, NativeMemoryPool pool) {
        Buffer fileFields = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(this.readArrowSchema(URLDecoder.decode(file, "UTF-8"), format, option, allocator, pool).getFields()).asScala();
        return (String[])((IterableOnceOps)fileFields.map((Function1 & Serializable)x$1 -> x$1.getName())).toArray(ClassTag$.MODULE$.apply(String.class));
    }

    public Option<StructType> readSchema(FileStatus file, FileFormat format, FragmentScanOptions option, BufferAllocator allocator, NativeMemoryPool pool) {
        Option option2;
        FileSystemDatasetFactory factory = this.makeArrowDiscovery(file.getPath().toString(), format, Optional.of(option), allocator, pool);
        Schema schema = factory.inspect();
        try {
            option2 = Option$.MODULE$.apply((Object)SparkSchemaUtil$.MODULE$.fromArrowSchema(schema));
        }
        finally {
            factory.close();
        }
        return option2;
    }

    public Option<StructType> readSchema(scala.collection.immutable.Seq<FileStatus> files, FileFormat format, FragmentScanOptions option, BufferAllocator allocator, NativeMemoryPool pool) {
        if (files.isEmpty()) {
            throw new IllegalArgumentException("No input file specified");
        }
        return this.readSchema((FileStatus)files.head(), format, option, allocator, pool);
    }

    public ArrowWritableColumnVector[] loadMissingColumns(int rowCount, StructType missingSchema) {
        ArrowWritableColumnVector[] vectors = ArrowWritableColumnVector.allocateColumns(rowCount, missingSchema);
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])vectors), (Function1 & Serializable)vector -> {
            ArrowUtil$.$anonfun$loadMissingColumns$1(rowCount, vector);
            return BoxedUnit.UNIT;
        });
        return vectors;
    }

    public ArrowWritableColumnVector[] loadPartitionColumns(int rowCount, StructType partitionSchema, InternalRow partitionValues) {
        ArrowWritableColumnVector[] partitionColumns = ArrowWritableColumnVector.allocateColumns(rowCount, partitionSchema);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), partitionColumns.length).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            ArrowColumnVectorUtils.populate(partitionColumns[i], partitionValues, i);
            partitionColumns[i].setValueCount(rowCount);
            partitionColumns[i].setIsConstant();
        });
        return partitionColumns;
    }

    public ColumnarBatch loadBatch(BufferAllocator allocator, ArrowRecordBatch input, Schema dataSchema, ArrowWritableColumnVector[] partitionVectors, ArrowWritableColumnVector[] nullVectors) {
        ArrowWritableColumnVector[] arrowWritableColumnVectorArray;
        ArrowWritableColumnVector[] arrowWritableColumnVectorArray2;
        int rowCount = input.getLength();
        try {
            arrowWritableColumnVectorArray2 = ArrowWritableColumnVector.loadColumns(rowCount, dataSchema, input, allocator);
        }
        finally {
            input.close();
        }
        ArrowWritableColumnVector[] vectors = arrowWritableColumnVectorArray2;
        if (ArrayOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.refArrayOps((Object[])nullVectors))) {
            ArrayBuffer finalVectors = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
            finalVectors.appendAll((IterableOnce)Predef$.MODULE$.wrapRefArray((Object[])vectors));
            finalVectors.appendAll((IterableOnce)Predef$.MODULE$.wrapRefArray((Object[])nullVectors));
            arrowWritableColumnVectorArray = (ArrowWritableColumnVector[])finalVectors.toArray(ClassTag$.MODULE$.apply(ArrowWritableColumnVector.class));
        } else {
            arrowWritableColumnVectorArray = vectors;
        }
        ArrowWritableColumnVector[] totalVectors = arrowWritableColumnVectorArray;
        ColumnarBatch batch = new ColumnarBatch((ColumnVector[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])totalVectors), (Function1 & Serializable)x$2 -> x$2, ClassTag$.MODULE$.apply(ColumnVector.class))), ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])partitionVectors), (Function1 & Serializable)vector -> {
            vector.setValueCount(rowCount);
            return vector;
        }, ClassTag$.MODULE$.apply(ColumnVector.class)), ClassTag$.MODULE$.apply(ColumnVector.class)), rowCount);
        return batch;
    }

    public ArrowWritableColumnVector[] loadBatch$default$4() {
        return (ArrowWritableColumnVector[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(ArrowWritableColumnVector.class));
    }

    public ArrowWritableColumnVector[] loadBatch$default$5() {
        return (ArrowWritableColumnVector[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(ArrowWritableColumnVector.class));
    }

    public static final /* synthetic */ void $anonfun$loadMissingColumns$1(int rowCount$1, ArrowWritableColumnVector vector) {
        vector.putNulls(0, rowCount$1);
        vector.setValueCount(rowCount$1);
    }

    private ArrowUtil$() {
    }
}

