/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gluten.utils;

import java.io.Serializable;
import org.apache.arrow.c.ArrowArray;
import org.apache.arrow.c.ArrowSchema;
import org.apache.arrow.c.CDataDictionaryProvider;
import org.apache.arrow.c.Data;
import org.apache.gluten.columnarbatch.ColumnarBatches;
import org.apache.gluten.exception.GlutenException;
import org.apache.gluten.shaded.org.apache.arrow.memory.BufferAllocator;
import org.apache.gluten.shaded.org.apache.arrow.vector.FieldVector;
import org.apache.gluten.shaded.org.apache.arrow.vector.VectorLoader;
import org.apache.gluten.shaded.org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.gluten.shaded.org.apache.arrow.vector.VectorUnloader;
import org.apache.gluten.shaded.org.apache.arrow.vector.dictionary.DictionaryProvider;
import org.apache.gluten.shaded.org.apache.arrow.vector.ipc.message.ArrowRecordBatch;
import org.apache.gluten.shaded.org.apache.arrow.vector.types.pojo.Field;
import org.apache.gluten.shaded.org.apache.arrow.vector.types.pojo.Schema;
import org.apache.gluten.utils.ArrowUtil$;
import org.apache.gluten.vectorized.ArrowWritableColumnVector;
import org.apache.spark.sql.utils.SparkVectorUtil$;
import org.apache.spark.sql.vectorized.ColumnVector;
import org.apache.spark.sql.vectorized.ColumnarBatch;
import scala.Function1;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.reflect.ClassTag$;

public final class ArrowAbiUtil$ {
    public static final ArrowAbiUtil$ MODULE$ = new ArrowAbiUtil$();

    public void importIntoVectorSchemaRoot(BufferAllocator allocator, ArrowArray array, VectorSchemaRoot root, DictionaryProvider provider) {
        Data.importIntoVectorSchemaRoot(allocator, array, root, provider);
    }

    public ArrowRecordBatch importToArrowRecordBatch(BufferAllocator allocator, ArrowSchema cSchema, ArrowArray cArray) {
        VectorSchemaRoot vsr = this.importToVectorSchemaRoot(allocator, cSchema, cArray);
        VectorUnloader unloader = new VectorUnloader(vsr);
        return unloader.getRecordBatch();
    }

    public ColumnarBatch importToSparkColumnarBatch(BufferAllocator allocator, ArrowSchema cSchema, ArrowArray cArray) {
        VectorSchemaRoot vsr = this.importToVectorSchemaRoot(allocator, cSchema, cArray);
        return this.toSparkColumnarBatch(vsr);
    }

    private VectorSchemaRoot importToVectorSchemaRoot(BufferAllocator allocator, ArrowSchema cSchema, ArrowArray cArray) {
        VectorSchemaRoot vectorSchemaRoot;
        CDataDictionaryProvider dictProvider = new CDataDictionaryProvider();
        VectorSchemaRoot vsr = Data.importVectorSchemaRoot(allocator, cArray, cSchema, dictProvider);
        try {
            vectorSchemaRoot = vsr;
        }
        finally {
            dictProvider.close();
        }
        return vectorSchemaRoot;
    }

    public ColumnarBatch importToSparkColumnarBatch(BufferAllocator allocator, Schema schema, ArrowArray cArray) {
        VectorSchemaRoot vsr = this.toVectorSchemaRoot(allocator, schema, cArray);
        return this.toSparkColumnarBatch(vsr);
    }

    private ColumnarBatch toSparkColumnarBatch(VectorSchemaRoot vsr) {
        int rowCount = vsr.getRowCount();
        ColumnVector[] vectors = (ColumnVector[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrowWritableColumnVector.loadColumns(rowCount, vsr.getFieldVectors())), (Function1 & Serializable)v -> {
            v.setValueCount(rowCount);
            return v;
        }, ClassTag$.MODULE$.apply(ColumnVector.class));
        return new ColumnarBatch(vectors, rowCount);
    }

    private VectorSchemaRoot toVectorSchemaRoot(BufferAllocator allocator, Schema schema, ArrowArray array) {
        VectorSchemaRoot vectorSchemaRoot;
        VectorSchemaRoot vsr = VectorSchemaRoot.create(schema, allocator);
        try (CDataDictionaryProvider provider = new CDataDictionaryProvider();){
            if (array != null) {
                Data.importIntoVectorSchemaRoot(allocator, array, vsr, provider);
            }
            vectorSchemaRoot = vsr;
        }
        return vectorSchemaRoot;
    }

    public Schema importToSchema(BufferAllocator allocator, ArrowSchema cSchema) {
        Schema schema;
        CDataDictionaryProvider dictProvider = new CDataDictionaryProvider();
        Schema schema2 = Data.importSchema(allocator, cSchema, dictProvider);
        try {
            schema = schema2;
        }
        finally {
            dictProvider.close();
        }
        return schema;
    }

    public void exportField(BufferAllocator allocator, Field field, ArrowSchema out) {
        try (CDataDictionaryProvider dictProvider = new CDataDictionaryProvider();){
            Data.exportField(allocator, field, dictProvider, out);
        }
    }

    public void exportSchema(BufferAllocator allocator, Schema schema, ArrowSchema out) {
        try (CDataDictionaryProvider dictProvider = new CDataDictionaryProvider();){
            Data.exportSchema(allocator, schema, dictProvider, out);
        }
    }

    public void exportFromSparkColumnarBatch(BufferAllocator allocator, ColumnarBatch batch, ArrowSchema cSchema, ArrowArray cArray) {
        ColumnarBatches.checkLoaded(batch);
        Schema schema = ArrowUtil$.MODULE$.toSchema(batch);
        try (ArrowRecordBatch rb = SparkVectorUtil$.MODULE$.toArrowRecordBatch(batch);){
            this.exportFromArrowRecordBatch(allocator, rb, schema, cSchema, cArray);
        }
    }

    public void exportFromArrowRecordBatch(BufferAllocator allocator, ArrowRecordBatch arrowBatch, Schema schema, ArrowSchema cSchema, ArrowArray cArray) {
        try (VectorSchemaRoot vsr = this.toVectorSchemaRoot(allocator, schema, arrowBatch);){
            try {
                Data.exportVectorSchemaRoot(allocator, vsr, new CDataDictionaryProvider(), cArray, cSchema);
            }
            catch (Exception e) {
                throw new GlutenException(String.format("error exporting columnar batch with schema: %s, vectors: %s", vsr.getSchema(), vsr.getFieldVectors()), e);
            }
        }
    }

    private VectorSchemaRoot toVectorSchemaRoot(BufferAllocator allocator, Schema schema, ArrowRecordBatch arrowBatch) {
        if (arrowBatch.getNodes().size() == 0) {
            return VectorSchemaRoot.of(new FieldVector[0]);
        }
        VectorSchemaRoot root = VectorSchemaRoot.create(schema, allocator);
        VectorLoader loader = new VectorLoader(root);
        loader.load(arrowBatch);
        return root;
    }

    private ArrowAbiUtil$() {
    }
}

