/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gluten.substrait.type;

import java.util.List;
import org.apache.gluten.substrait.type.BinaryTypeNode;
import org.apache.gluten.substrait.type.BooleanTypeNode;
import org.apache.gluten.substrait.type.DateTypeNode;
import org.apache.gluten.substrait.type.DecimalTypeNode;
import org.apache.gluten.substrait.type.FP32TypeNode;
import org.apache.gluten.substrait.type.FP64TypeNode;
import org.apache.gluten.substrait.type.FixedBinaryTypeNode;
import org.apache.gluten.substrait.type.FixedCharTypeNode;
import org.apache.gluten.substrait.type.I16TypeNode;
import org.apache.gluten.substrait.type.I32TypeNode;
import org.apache.gluten.substrait.type.I64TypeNode;
import org.apache.gluten.substrait.type.I8TypeNode;
import org.apache.gluten.substrait.type.IntervalYearTypeNode;
import org.apache.gluten.substrait.type.ListNode;
import org.apache.gluten.substrait.type.MapNode;
import org.apache.gluten.substrait.type.NothingNode;
import org.apache.gluten.substrait.type.StringTypeNode;
import org.apache.gluten.substrait.type.StructNode;
import org.apache.gluten.substrait.type.TimestampTypeNode;
import org.apache.gluten.substrait.type.TypeNode;

public class TypeBuilder {
    private TypeBuilder() {
    }

    public static TypeNode makeFP32(Boolean nullable) {
        return new FP32TypeNode(nullable);
    }

    public static TypeNode makeFP64(Boolean nullable) {
        return new FP64TypeNode(nullable);
    }

    public static TypeNode makeBoolean(Boolean nullable) {
        return new BooleanTypeNode(nullable);
    }

    public static TypeNode makeString(Boolean nullable) {
        return new StringTypeNode(nullable);
    }

    public static TypeNode makeFixedChar(Boolean nullable, int length) {
        return new FixedCharTypeNode(nullable, length);
    }

    public static TypeNode makeFixedBinary(Boolean nullable, int length) {
        return new FixedBinaryTypeNode(nullable, length);
    }

    public static TypeNode makeBinary(Boolean nullable) {
        return new BinaryTypeNode(nullable);
    }

    public static TypeNode makeI8(Boolean nullable) {
        return new I8TypeNode(nullable);
    }

    public static TypeNode makeI16(Boolean nullable) {
        return new I16TypeNode(nullable);
    }

    public static TypeNode makeI32(Boolean nullable) {
        return new I32TypeNode(nullable);
    }

    public static TypeNode makeI64(Boolean nullable) {
        return new I64TypeNode(nullable);
    }

    public static TypeNode makeDate(Boolean nullable) {
        return new DateTypeNode(nullable);
    }

    public static TypeNode makeIntervalYear(Boolean nullable) {
        return new IntervalYearTypeNode(nullable);
    }

    public static TypeNode makeDecimal(Boolean nullable, Integer precision, Integer scale) {
        return new DecimalTypeNode(nullable, precision, scale);
    }

    public static TypeNode makeTimestamp(Boolean nullable) {
        return new TimestampTypeNode(nullable);
    }

    public static TypeNode makeStruct(Boolean nullable, List<TypeNode> types, List<String> names) {
        return new StructNode(nullable, types, names);
    }

    public static TypeNode makeStruct(Boolean nullable, List<TypeNode> types) {
        return new StructNode(nullable, types);
    }

    public static TypeNode makeMap(Boolean nullable, TypeNode keyType, TypeNode valType) {
        return new MapNode(nullable, keyType, valType);
    }

    public static TypeNode makeList(Boolean nullable, TypeNode nestedType) {
        return new ListNode(nullable, nestedType);
    }

    public static TypeNode makeNothing() {
        return new NothingNode();
    }
}

