/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gluten.substrait.type;

import io.substrait.proto.Type;
import java.util.ArrayList;
import java.util.List;
import org.apache.gluten.substrait.type.TypeNode;

public class StructNode
extends TypeNode {
    private final List<TypeNode> types = new ArrayList<TypeNode>();
    private final List<String> names = new ArrayList<String>();

    public StructNode(Boolean nullable, List<TypeNode> types, List<String> names) {
        super(nullable);
        this.types.addAll(types);
        this.names.addAll(names);
    }

    public StructNode(Boolean nullable, List<TypeNode> types) {
        super(nullable);
        this.types.addAll(types);
    }

    public List<TypeNode> getFieldTypes() {
        return this.types;
    }

    public List<String> getNames() {
        return this.names;
    }

    @Override
    public Type toProtobuf() {
        Type.Struct.Builder structBuilder = Type.Struct.newBuilder();
        structBuilder.setNullability(this.nullable != false ? Type.Nullability.NULLABILITY_NULLABLE : Type.Nullability.NULLABILITY_REQUIRED);
        for (TypeNode typeNode : this.types) {
            structBuilder.addTypes(typeNode.toProtobuf());
        }
        for (String name : this.names) {
            structBuilder.addNames(name);
        }
        Type.Builder builder = Type.newBuilder();
        builder.setStruct(structBuilder.build());
        return builder.build();
    }
}

