/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gluten.substrait.type;

import io.substrait.proto.Type;
import java.util.ArrayList;
import org.apache.gluten.substrait.type.TypeBuilder;
import org.apache.gluten.substrait.type.TypeNode;

public class MapNode
extends TypeNode {
    private final TypeNode keyType;
    private final TypeNode valType;

    public MapNode(Boolean nullable, TypeNode keyType, TypeNode valType) {
        super(nullable);
        this.keyType = keyType;
        this.valType = valType;
    }

    public TypeNode getNestedType() {
        ArrayList<TypeNode> types = new ArrayList<TypeNode>();
        types.add(this.keyType);
        types.add(this.valType);
        return TypeBuilder.makeStruct(false, types);
    }

    public TypeNode getKeyType() {
        return this.keyType;
    }

    public TypeNode getValueType() {
        return this.valType;
    }

    @Override
    public Type toProtobuf() {
        Type.Map.Builder mapBuilder = Type.Map.newBuilder();
        mapBuilder.setKey(this.keyType.toProtobuf());
        mapBuilder.setValue(this.valType.toProtobuf());
        mapBuilder.setNullability(this.nullable != false ? Type.Nullability.NULLABILITY_NULLABLE : Type.Nullability.NULLABILITY_REQUIRED);
        Type.Builder builder = Type.newBuilder();
        builder.setMap(mapBuilder.build());
        return builder.build();
    }
}

