/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gluten.substrait.rel;

import io.substrait.proto.Rel;
import io.substrait.proto.RelCommon;
import io.substrait.proto.SortField;
import io.substrait.proto.TopNRel;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.gluten.substrait.extensions.AdvancedExtensionNode;
import org.apache.gluten.substrait.rel.RelNode;

public class TopNNode
implements RelNode,
Serializable {
    private final RelNode input;
    private final Long count;
    private final List<SortField> sorts = new ArrayList<SortField>();
    private final AdvancedExtensionNode extensionNode;

    public TopNNode(RelNode input, Long count, List<SortField> sorts) {
        this.input = input;
        this.count = count;
        this.sorts.addAll(sorts);
        this.extensionNode = null;
    }

    public TopNNode(RelNode input, Long count, List<SortField> sorts, AdvancedExtensionNode extensionNode) {
        this.input = input;
        this.count = count;
        this.sorts.addAll(sorts);
        this.extensionNode = extensionNode;
    }

    @Override
    public Rel toProtobuf() {
        RelCommon.Builder relCommonBuilder = RelCommon.newBuilder();
        relCommonBuilder.setDirect(RelCommon.Direct.newBuilder());
        TopNRel.Builder topNBuilder = TopNRel.newBuilder();
        if (this.input != null) {
            topNBuilder.setInput(this.input.toProtobuf());
        }
        topNBuilder.setN(this.count);
        for (int i = 0; i < this.sorts.size(); ++i) {
            topNBuilder.addSorts(i, this.sorts.get(i));
        }
        if (this.extensionNode != null) {
            topNBuilder.setAdvancedExtension(this.extensionNode.toProtobuf());
        }
        Rel.Builder relBuilder = Rel.newBuilder();
        relBuilder.setTopN(topNBuilder.build());
        return relBuilder.build();
    }
}

