/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gluten.substrait.rel;

import io.substrait.proto.ReadRel;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.gluten.substrait.rel.SplitInfo;

public class StreamKafkaSourceNode
implements SplitInfo {
    private final String topic;
    private final Integer partition;
    private final Long startOffset;
    private final Long endOffset;
    private final Long pollTimeoutMs;
    private final Boolean failOnDataLoss;
    private final Boolean includeHeaders;
    private final Map<String, Object> kafkaParams;

    public StreamKafkaSourceNode(String topic, Integer partition, Long startOffset, Long endOffset, Long pollTimeoutMs, Boolean failOnDataLoss, Boolean includeHeaders, Map<String, Object> kafkaParams) {
        this.topic = topic;
        this.partition = partition;
        this.startOffset = startOffset;
        this.endOffset = endOffset;
        this.pollTimeoutMs = pollTimeoutMs;
        this.failOnDataLoss = failOnDataLoss;
        this.includeHeaders = includeHeaders;
        this.kafkaParams = kafkaParams;
    }

    @Override
    public List<String> preferredLocations() {
        return Collections.emptyList();
    }

    @Override
    public ReadRel.StreamKafka toProtobuf() {
        ReadRel.StreamKafka.Builder builder = ReadRel.StreamKafka.newBuilder();
        ReadRel.StreamKafka.TopicPartition.Builder topicPartition = ReadRel.StreamKafka.TopicPartition.newBuilder();
        topicPartition.setTopic(this.topic);
        topicPartition.setPartition(this.partition);
        builder.setTopicPartition(topicPartition.build());
        builder.setStartOffset(this.startOffset);
        builder.setEndOffset(this.endOffset);
        builder.setPollTimeoutMs(this.pollTimeoutMs);
        builder.setFailOnDataLoss(this.failOnDataLoss);
        builder.setIncludeHeaders(this.includeHeaders);
        this.kafkaParams.forEach((k, v) -> builder.putParams((String)k, v.toString()));
        return builder.build();
    }
}

