/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gluten.substrait.rel;

import io.substrait.proto.Rel;
import io.substrait.proto.RelCommon;
import io.substrait.proto.SortField;
import io.substrait.proto.SortRel;
import java.io.Serializable;
import java.util.List;
import org.apache.gluten.substrait.extensions.AdvancedExtensionNode;
import org.apache.gluten.substrait.rel.RelNode;

public class SortRelNode
implements RelNode,
Serializable {
    private final RelNode input;
    private final List<SortField> sorts;
    private final AdvancedExtensionNode extensionNode;

    public SortRelNode(RelNode input, List<SortField> sorts, AdvancedExtensionNode extensionNode) {
        this.input = input;
        this.sorts = sorts;
        this.extensionNode = extensionNode;
    }

    public SortRelNode(RelNode input, List<SortField> sorts) {
        this.input = input;
        this.sorts = sorts;
        this.extensionNode = null;
    }

    @Override
    public Rel toProtobuf() {
        RelCommon.Builder relCommonBuilder = RelCommon.newBuilder();
        relCommonBuilder.setDirect(RelCommon.Direct.newBuilder());
        SortRel.Builder sortBuilder = SortRel.newBuilder();
        sortBuilder.setCommon(relCommonBuilder.build());
        if (this.input != null) {
            sortBuilder.setInput(this.input.toProtobuf());
        }
        for (int i = 0; i < this.sorts.size(); ++i) {
            sortBuilder.addSorts(i, this.sorts.get(i));
        }
        if (this.extensionNode != null) {
            sortBuilder.setAdvancedExtension(this.extensionNode.toProtobuf());
        }
        Rel.Builder builder = Rel.newBuilder();
        builder.setSort(sortBuilder.build());
        return builder.build();
    }
}

