/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gluten.substrait.rel;

import io.substrait.proto.NamedStruct;
import io.substrait.proto.ReadRel;
import io.substrait.proto.Rel;
import io.substrait.proto.RelCommon;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.gluten.substrait.expression.ExpressionNode;
import org.apache.gluten.substrait.extensions.AdvancedExtensionNode;
import org.apache.gluten.substrait.rel.RelNode;
import org.apache.gluten.substrait.type.ColumnTypeNode;
import org.apache.gluten.substrait.type.TypeNode;
import org.apache.gluten.utils.SubstraitUtil;

public class ReadRelNode
implements RelNode,
Serializable {
    private final List<TypeNode> types = new ArrayList<TypeNode>();
    private final List<String> names = new ArrayList<String>();
    private final List<ColumnTypeNode> columnTypeNodes = new ArrayList<ColumnTypeNode>();
    private final ExpressionNode filterNode;
    private final AdvancedExtensionNode extensionNode;
    private boolean streamKafka = false;

    ReadRelNode(List<TypeNode> types, List<String> names, ExpressionNode filterNode, List<ColumnTypeNode> columnTypeNodes, AdvancedExtensionNode extensionNode) {
        this.types.addAll(types);
        this.names.addAll(names);
        this.filterNode = filterNode;
        this.columnTypeNodes.addAll(columnTypeNodes);
        this.extensionNode = extensionNode;
    }

    public void setStreamKafka(boolean streamKafka) {
        this.streamKafka = streamKafka;
    }

    @Override
    public Rel toProtobuf() {
        RelCommon.Builder relCommonBuilder = RelCommon.newBuilder();
        relCommonBuilder.setDirect(RelCommon.Direct.newBuilder());
        NamedStruct.Builder nStructBuilder = SubstraitUtil.createNameStructBuilder(this.types, this.names, this.columnTypeNodes);
        ReadRel.Builder readBuilder = ReadRel.newBuilder();
        readBuilder.setCommon(relCommonBuilder.build());
        readBuilder.setBaseSchema(nStructBuilder.build());
        readBuilder.setStreamKafka(this.streamKafka);
        if (this.filterNode != null) {
            readBuilder.setFilter(this.filterNode.toProtobuf());
        }
        if (this.extensionNode != null) {
            readBuilder.setAdvancedExtension(this.extensionNode.toProtobuf());
        }
        Rel.Builder builder = Rel.newBuilder();
        builder.setRead(readBuilder.build());
        return builder.build();
    }
}

