/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gluten.substrait.plan;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.gluten.shaded.com.google.common.base.Preconditions;
import org.apache.gluten.substrait.SubstraitContext;
import org.apache.gluten.substrait.extensions.AdvancedExtensionNode;
import org.apache.gluten.substrait.extensions.ExtensionBuilder;
import org.apache.gluten.substrait.extensions.FunctionMappingNode;
import org.apache.gluten.substrait.plan.PlanNode;
import org.apache.gluten.substrait.rel.RelNode;
import org.apache.gluten.substrait.type.TypeNode;

public class PlanBuilder {
    public static byte[] EMPTY_PLAN = PlanBuilder.empty().toProtobuf().toByteArray();

    private PlanBuilder() {
    }

    public static PlanNode makePlan(List<FunctionMappingNode> mappingNodes, List<RelNode> relNodes, List<String> outNames, TypeNode outputSchema, AdvancedExtensionNode extension) {
        return new PlanNode(mappingNodes, relNodes, outNames, outputSchema, extension);
    }

    public static PlanNode makePlan(SubstraitContext subCtx, List<RelNode> relNodes, List<String> outNames) {
        return PlanBuilder.makePlan(subCtx, relNodes, outNames, null, null);
    }

    public static PlanNode makePlan(SubstraitContext subCtx, List<RelNode> relNodes, List<String> outNames, TypeNode outputSchema, AdvancedExtensionNode extension) {
        Preconditions.checkNotNull(subCtx, "Cannot execute doTransform due to the SubstraitContext is null.");
        ArrayList<FunctionMappingNode> mappingNodes = new ArrayList<FunctionMappingNode>();
        for (Map.Entry<String, Long> entry : subCtx.registeredFunction().entrySet()) {
            FunctionMappingNode mappingNode = ExtensionBuilder.makeFunctionMapping(entry.getKey(), entry.getValue());
            mappingNodes.add(mappingNode);
        }
        return PlanBuilder.makePlan(mappingNodes, relNodes, outNames, outputSchema, extension);
    }

    public static PlanNode makePlan(SubstraitContext subCtx, ArrayList<RelNode> relNodes) {
        return PlanBuilder.makePlan(subCtx, relNodes, new ArrayList<String>());
    }

    public static PlanNode empty() {
        return PlanBuilder.makePlan(new SubstraitContext(), new ArrayList<RelNode>(), new ArrayList<String>());
    }
}

