/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gluten.substrait.expression;

import io.substrait.proto.Expression;
import org.apache.gluten.substrait.expression.ExpressionBuilder;
import org.apache.gluten.substrait.expression.LiteralNode;
import org.apache.gluten.substrait.expression.LiteralNodeWithValue;
import org.apache.gluten.substrait.type.BinaryTypeNode;
import org.apache.gluten.substrait.type.BooleanTypeNode;
import org.apache.gluten.substrait.type.DateTypeNode;
import org.apache.gluten.substrait.type.DecimalTypeNode;
import org.apache.gluten.substrait.type.FP32TypeNode;
import org.apache.gluten.substrait.type.FP64TypeNode;
import org.apache.gluten.substrait.type.I16TypeNode;
import org.apache.gluten.substrait.type.I32TypeNode;
import org.apache.gluten.substrait.type.I64TypeNode;
import org.apache.gluten.substrait.type.I8TypeNode;
import org.apache.gluten.substrait.type.ListNode;
import org.apache.gluten.substrait.type.MapNode;
import org.apache.gluten.substrait.type.NothingNode;
import org.apache.gluten.substrait.type.StringTypeNode;
import org.apache.gluten.substrait.type.StructNode;
import org.apache.gluten.substrait.type.TimestampTypeNode;
import org.apache.gluten.substrait.type.TypeNode;
import org.apache.spark.sql.catalyst.InternalRow;

public class StructLiteralNode
extends LiteralNodeWithValue<InternalRow> {
    public StructLiteralNode(InternalRow row, TypeNode typeNode) {
        super(row, typeNode);
    }

    public LiteralNode getFieldLiteral(int index) {
        InternalRow value = (InternalRow)this.getValue();
        TypeNode type = ((StructNode)this.getTypeNode()).getFieldTypes().get(index);
        if (value.isNullAt(index)) {
            return ExpressionBuilder.makeNullLiteral(type);
        }
        if (type instanceof BooleanTypeNode) {
            return ExpressionBuilder.makeLiteral(value.getBoolean(index), type);
        }
        if (type instanceof I8TypeNode) {
            return ExpressionBuilder.makeLiteral(value.getByte(index), type);
        }
        if (type instanceof I16TypeNode) {
            return ExpressionBuilder.makeLiteral(value.getShort(index), type);
        }
        if (type instanceof I32TypeNode) {
            return ExpressionBuilder.makeLiteral(value.getInt(index), type);
        }
        if (type instanceof I64TypeNode) {
            return ExpressionBuilder.makeLiteral(value.getLong(index), type);
        }
        if (type instanceof FP32TypeNode) {
            return ExpressionBuilder.makeLiteral(Float.valueOf(value.getFloat(index)), type);
        }
        if (type instanceof FP64TypeNode) {
            return ExpressionBuilder.makeLiteral(value.getDouble(index), type);
        }
        if (type instanceof DateTypeNode) {
            return ExpressionBuilder.makeLiteral(value.getInt(index), type);
        }
        if (type instanceof TimestampTypeNode) {
            return ExpressionBuilder.makeLiteral(value.getLong(index), type);
        }
        if (type instanceof StringTypeNode) {
            return ExpressionBuilder.makeLiteral(value.getUTF8String(index), type);
        }
        if (type instanceof BinaryTypeNode) {
            return ExpressionBuilder.makeLiteral(value.getBinary(index), type);
        }
        if (type instanceof DecimalTypeNode) {
            return ExpressionBuilder.makeLiteral(value.getDecimal(index, ((DecimalTypeNode)type).precision, ((DecimalTypeNode)type).scale), type);
        }
        if (type instanceof ListNode) {
            return ExpressionBuilder.makeLiteral(value.getArray(index), type);
        }
        if (type instanceof MapNode) {
            return ExpressionBuilder.makeLiteral(value.getMap(index), type);
        }
        if (type instanceof StructNode) {
            return ExpressionBuilder.makeLiteral(value.getStruct(index, ((StructNode)type).getFieldTypes().size()), type);
        }
        if (type instanceof NothingNode) {
            return ExpressionBuilder.makeNullLiteral(type);
        }
        throw new UnsupportedOperationException(type.toString() + " is not supported in getFieldLiteral.");
    }

    @Override
    protected void updateLiteralBuilder(Expression.Literal.Builder literalBuilder, InternalRow row) {
        Expression.Literal.Struct.Builder structBuilder = Expression.Literal.Struct.newBuilder();
        StructNode structNode = (StructNode)this.getTypeNode();
        for (int i = 0; i < structNode.getFieldTypes().size(); ++i) {
            structBuilder.addFields(this.getFieldLiteral(i).getLiteral());
            structBuilder.addNames(structNode.getNames().get(i));
        }
        literalBuilder.setStruct(structBuilder.build());
    }
}

