/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gluten.substrait.expression;

import io.substrait.proto.Expression;
import io.substrait.proto.Type;
import org.apache.gluten.expression.ConverterUtils;
import org.apache.gluten.substrait.expression.ExpressionBuilder;
import org.apache.gluten.substrait.expression.LiteralNode;
import org.apache.gluten.substrait.expression.LiteralNodeWithValue;
import org.apache.gluten.substrait.type.MapNode;
import org.apache.gluten.substrait.type.TypeNode;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.MapData;
import org.apache.spark.sql.types.DataType;

public class MapLiteralNode
extends LiteralNodeWithValue<MapData> {
    public MapLiteralNode(MapData map, TypeNode typeNode) {
        super(map, typeNode);
    }

    @Override
    protected void updateLiteralBuilder(Expression.Literal.Builder literalBuilder, MapData map) {
        ArrayData keys = map.keyArray();
        ArrayData values = map.valueArray();
        TypeNode keyType = ((MapNode)this.getTypeNode()).getKeyType();
        TypeNode valueType = ((MapNode)this.getTypeNode()).getValueType();
        DataType keyDataType = ConverterUtils.parseFromTypeNode(keyType);
        DataType valueDataType = ConverterUtils.parseFromTypeNode(valueType);
        if (keys.numElements() > 0) {
            Expression.Literal.Map.Builder mapBuilder = Expression.Literal.Map.newBuilder();
            for (int i = 0; i < keys.numElements(); ++i) {
                LiteralNode keyNode = ExpressionBuilder.makeLiteral(keys.get(i, keyDataType), keyType);
                LiteralNode valueNode = ExpressionBuilder.makeLiteral(values.get(i, valueDataType), valueType);
                Expression.Literal.Map.KeyValue.Builder kvBuilder = Expression.Literal.Map.KeyValue.newBuilder();
                kvBuilder.setKey(keyNode.getLiteral());
                kvBuilder.setValue(valueNode.getLiteral());
                mapBuilder.addKeyValues(kvBuilder.build());
            }
            literalBuilder.setMap(mapBuilder.build());
        } else {
            Type.Map.Builder mapTypeBuilder = Type.Map.newBuilder();
            mapTypeBuilder.setKey(keyType.toProtobuf());
            mapTypeBuilder.setValue(valueType.toProtobuf());
            literalBuilder.setEmptyMap(mapTypeBuilder.build());
        }
    }
}

