/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gluten.substrait.expression;

import io.substrait.proto.Expression;
import io.substrait.proto.Type;
import org.apache.gluten.expression.ConverterUtils;
import org.apache.gluten.substrait.expression.ExpressionBuilder;
import org.apache.gluten.substrait.expression.LiteralNode;
import org.apache.gluten.substrait.expression.LiteralNodeWithValue;
import org.apache.gluten.substrait.type.ListNode;
import org.apache.gluten.substrait.type.TypeNode;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.types.DataType;

public class ListLiteralNode
extends LiteralNodeWithValue<ArrayData> {
    public ListLiteralNode(ArrayData array, TypeNode typeNode) {
        super(array, typeNode);
    }

    @Override
    protected void updateLiteralBuilder(Expression.Literal.Builder literalBuilder, ArrayData array) {
        TypeNode elementType = ((ListNode)this.getTypeNode()).getNestedType();
        DataType elementDataType = ConverterUtils.parseFromTypeNode(elementType);
        if (array.numElements() > 0) {
            Expression.Literal.List.Builder listBuilder = Expression.Literal.List.newBuilder();
            for (int i = 0; i < array.numElements(); ++i) {
                Object element = array.get(i, elementDataType);
                LiteralNode elementNode = ExpressionBuilder.makeLiteral(element, elementType);
                Expression.Literal elementExpr = elementNode.getLiteral();
                listBuilder.addValues(elementExpr);
            }
            literalBuilder.setList(listBuilder.build());
        } else {
            Type.List.Builder listTypeBuilder = Type.List.newBuilder();
            listTypeBuilder.setType(elementType.toProtobuf());
            literalBuilder.setEmptyList(listTypeBuilder.build());
        }
    }
}

