/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gluten.substrait.expression;

import io.substrait.proto.Expression;
import java.io.Serializable;
import org.apache.gluten.substrait.expression.ExpressionNode;
import org.apache.gluten.substrait.type.TypeNode;

public class CastNode
implements ExpressionNode,
Serializable {
    private final TypeNode typeNode;
    private final ExpressionNode expressionNode;
    public final boolean isTryCast;

    CastNode(TypeNode typeNode, ExpressionNode expressionNode, boolean isTryCast) {
        this.typeNode = typeNode;
        this.expressionNode = expressionNode;
        this.isTryCast = isTryCast;
    }

    @Override
    public Expression toProtobuf() {
        Expression.Cast.Builder castBuilder = Expression.Cast.newBuilder();
        castBuilder.setType(this.typeNode.toProtobuf());
        castBuilder.setInput(this.expressionNode.toProtobuf());
        if (!this.isTryCast) {
            castBuilder.setFailureBehaviorValue(2);
        } else {
            castBuilder.setFailureBehaviorValue(1);
        }
        Expression.Builder builder = Expression.newBuilder();
        builder.setCast(castBuilder.build());
        return builder.build();
    }
}

