/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gluten.shaded.org.apache.arrow.vector.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.gluten.shaded.org.apache.arrow.memory.BufferAllocator;
import org.apache.gluten.shaded.org.apache.arrow.vector.FieldVector;
import org.apache.gluten.shaded.org.apache.arrow.vector.dictionary.Dictionary;
import org.apache.gluten.shaded.org.apache.arrow.vector.dictionary.DictionaryProvider;
import org.apache.gluten.shaded.org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.gluten.shaded.org.apache.arrow.vector.types.pojo.DictionaryEncoding;
import org.apache.gluten.shaded.org.apache.arrow.vector.types.pojo.Field;
import org.apache.gluten.shaded.org.apache.arrow.vector.types.pojo.FieldType;

public class DictionaryUtility {
    private DictionaryUtility() {
    }

    public static Field toMessageFormat(Field field, DictionaryProvider provider, Set<Long> dictionaryIdsUsed) {
        List<Field> children;
        ArrowType type;
        if (!DictionaryUtility.needConvertToMessageFormat(field)) {
            return field;
        }
        DictionaryEncoding encoding = field.getDictionary();
        if (encoding == null) {
            type = field.getType();
            children = field.getChildren();
        } else {
            long id = encoding.getId();
            Dictionary dictionary = provider.lookup(id);
            if (dictionary == null) {
                throw new IllegalArgumentException("Could not find dictionary with ID " + id);
            }
            type = dictionary.getVectorType();
            children = dictionary.getVector().getField().getChildren();
            dictionaryIdsUsed.add(id);
        }
        ArrayList<Field> updatedChildren = new ArrayList<Field>(children.size());
        for (Field child : children) {
            updatedChildren.add(DictionaryUtility.toMessageFormat(child, provider, dictionaryIdsUsed));
        }
        return new Field(field.getName(), new FieldType(field.isNullable(), type, encoding, field.getMetadata()), updatedChildren);
    }

    public static boolean needConvertToMessageFormat(Field field) {
        DictionaryEncoding encoding = field.getDictionary();
        if (encoding != null) {
            return true;
        }
        List<Field> children = field.getChildren();
        for (Field child : children) {
            if (!DictionaryUtility.needConvertToMessageFormat(child)) continue;
            return true;
        }
        return false;
    }

    public static Field toMemoryFormat(Field field, BufferAllocator allocator, Map<Long, Dictionary> dictionaries) {
        ArrowType type;
        DictionaryEncoding encoding = field.getDictionary();
        List<Field> children = field.getChildren();
        if (encoding == null && children.isEmpty()) {
            return field;
        }
        ArrayList<Field> updatedChildren = new ArrayList<Field>(children.size());
        for (Field child : children) {
            updatedChildren.add(DictionaryUtility.toMemoryFormat(child, allocator, dictionaries));
        }
        ArrayList<Field> fieldChildren = null;
        if (encoding == null) {
            type = field.getType();
            fieldChildren = updatedChildren;
        } else {
            type = encoding.getIndexType();
            if (type == null) {
                type = new ArrowType.Int(32, true);
            }
            if (!dictionaries.containsKey(encoding.getId())) {
                String dictName = "DICT" + encoding.getId();
                Field dictionaryField = new Field(dictName, new FieldType(field.isNullable(), field.getType(), null, null), updatedChildren);
                FieldVector dictionaryVector = dictionaryField.createVector(allocator);
                dictionaries.put(encoding.getId(), new Dictionary(dictionaryVector, encoding));
            }
        }
        return new Field(field.getName(), new FieldType(field.isNullable(), type, encoding, field.getMetadata()), fieldChildren);
    }
}

