/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gluten.shaded.org.apache.arrow.vector.dictionary;

import org.apache.gluten.shaded.org.apache.arrow.memory.util.hash.ArrowBufHasher;
import org.apache.gluten.shaded.org.apache.arrow.memory.util.hash.SimpleHasher;
import org.apache.gluten.shaded.org.apache.arrow.vector.ValueVector;
import org.apache.gluten.shaded.org.apache.arrow.vector.compare.Range;
import org.apache.gluten.shaded.org.apache.arrow.vector.compare.RangeEqualsVisitor;

public class DictionaryHashTable {
    static final int NULL_VALUE = -1;
    static final int DEFAULT_INITIAL_CAPACITY = 16;
    static final int MAXIMUM_CAPACITY = 0x40000000;
    static final float DEFAULT_LOAD_FACTOR = 0.75f;
    static final Entry[] EMPTY_TABLE = new Entry[0];
    transient Entry[] table = EMPTY_TABLE;
    transient int size;
    int threshold;
    final float loadFactor;
    private final ValueVector dictionary;
    private final ArrowBufHasher hasher;

    public DictionaryHashTable(int initialCapacity, ValueVector dictionary, ArrowBufHasher hasher) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("Illegal initial capacity: " + initialCapacity);
        }
        if (initialCapacity > 0x40000000) {
            initialCapacity = 0x40000000;
        }
        this.loadFactor = 0.75f;
        this.threshold = initialCapacity;
        this.dictionary = dictionary;
        this.hasher = hasher;
        for (int i = 0; i < this.dictionary.getValueCount(); ++i) {
            this.put(i);
        }
    }

    public DictionaryHashTable(ValueVector dictionary, ArrowBufHasher hasher) {
        this(16, dictionary, hasher);
    }

    public DictionaryHashTable(ValueVector dictionary) {
        this(dictionary, SimpleHasher.INSTANCE);
    }

    private void inflateTable(int threshold) {
        int capacity = DictionaryHashTable.roundUpToPowerOf2(threshold);
        this.threshold = (int)Math.min((float)capacity * this.loadFactor, 1.0737418E9f);
        this.table = new Entry[capacity];
    }

    static int indexFor(int h2, int length) {
        return h2 & length - 1;
    }

    static final int roundUpToPowerOf2(int size) {
        int n = size - 1;
        n |= n >>> 1;
        n |= n >>> 2;
        n |= n >>> 4;
        n |= n >>> 8;
        return (n |= n >>> 16) < 0 ? 1 : (n >= 0x40000000 ? 0x40000000 : n + 1);
    }

    public int getIndex(int indexInArray, ValueVector toEncode) {
        int hash = toEncode.hashCode(indexInArray, this.hasher);
        int index = DictionaryHashTable.indexFor(hash, this.table.length);
        RangeEqualsVisitor equalVisitor = new RangeEqualsVisitor(this.dictionary, toEncode, null);
        Range range = new Range(0, 0, 1);
        Entry e = this.table[index];
        while (e != null) {
            if (e.hash == hash) {
                int dictIndex = e.index;
                if (equalVisitor.rangeEquals(range = range.setRightStart(indexInArray).setLeftStart(dictIndex))) {
                    return dictIndex;
                }
            }
            e = e.next;
        }
        return -1;
    }

    private void put(int indexInDictionary) {
        if (this.table == EMPTY_TABLE) {
            this.inflateTable(this.threshold);
        }
        int hash = this.dictionary.hashCode(indexInDictionary, this.hasher);
        int i = DictionaryHashTable.indexFor(hash, this.table.length);
        Entry e = this.table[i];
        while (e != null) {
            if (e.hash == hash && e.index == indexInDictionary) {
                return;
            }
            e = e.next;
        }
        this.addEntry(hash, indexInDictionary, i);
    }

    void createEntry(int hash, int index, int bucketIndex) {
        Entry e = this.table[bucketIndex];
        this.table[bucketIndex] = new Entry(hash, index, e);
        ++this.size;
    }

    void addEntry(int hash, int index, int bucketIndex) {
        if (this.size >= this.threshold && null != this.table[bucketIndex]) {
            this.resize(2 * this.table.length);
            bucketIndex = DictionaryHashTable.indexFor(hash, this.table.length);
        }
        this.createEntry(hash, index, bucketIndex);
    }

    void resize(int newCapacity) {
        Entry[] oldTable = this.table;
        int oldCapacity = oldTable.length;
        if (oldCapacity == 0x40000000) {
            this.threshold = Integer.MAX_VALUE;
            return;
        }
        Entry[] newTable = new Entry[newCapacity];
        this.transfer(newTable);
        this.table = newTable;
        this.threshold = (int)Math.min((float)newCapacity * this.loadFactor, 1.0737418E9f);
    }

    void transfer(Entry[] newTable) {
        int newCapacity = newTable.length;
        for (Entry e : this.table) {
            while (null != e) {
                Entry next = e.next;
                int i = DictionaryHashTable.indexFor(e.hash, newCapacity);
                e.next = newTable[i];
                newTable[i] = e;
                e = next;
            }
        }
    }

    public int size() {
        return this.size;
    }

    public void clear() {
        this.size = 0;
        for (int i = 0; i < this.table.length; ++i) {
            this.table[i] = null;
        }
    }

    static class Entry {
        int index;
        Entry next;
        int hash;

        Entry(int hash, int index, Entry next) {
            this.index = index;
            this.hash = hash;
            this.next = next;
        }

        public final int getIndex() {
            return this.index;
        }

        public int hashCode() {
            return this.hash;
        }

        public final boolean equals(Object o) {
            if (!(o instanceof Entry)) {
                return false;
            }
            Entry e = (Entry)o;
            return this.index == e.getIndex();
        }
    }
}

