/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gluten.shaded.org.apache.arrow.vector.complex.impl;

import org.apache.gluten.shaded.org.apache.arrow.memory.util.LargeMemoryUtil;
import org.apache.gluten.shaded.org.apache.arrow.vector.ValueVector;
import org.apache.gluten.shaded.org.apache.arrow.vector.complex.LargeListViewVector;
import org.apache.gluten.shaded.org.apache.arrow.vector.complex.impl.AbstractFieldReader;
import org.apache.gluten.shaded.org.apache.arrow.vector.complex.reader.FieldReader;
import org.apache.gluten.shaded.org.apache.arrow.vector.holders.UnionHolder;
import org.apache.gluten.shaded.org.apache.arrow.vector.types.Types;
import org.apache.gluten.shaded.org.apache.arrow.vector.types.pojo.Field;

public class UnionLargeListViewReader
extends AbstractFieldReader {
    private final LargeListViewVector vector;
    private final ValueVector data;
    private int currentOffset;
    private int size;

    public UnionLargeListViewReader(LargeListViewVector vector) {
        this.vector = vector;
        this.data = vector.getDataVector();
    }

    @Override
    public Field getField() {
        return this.vector.getField();
    }

    @Override
    public boolean isSet() {
        return !this.vector.isNull(this.idx());
    }

    @Override
    public void setPosition(int index) {
        super.setPosition(index);
        if (this.vector.getOffsetBuffer().capacity() == 0L) {
            this.currentOffset = 0;
            this.size = 0;
        } else {
            this.currentOffset = this.vector.getOffsetBuffer().getInt((long)index * 8L);
            this.size = this.vector.getSizeBuffer().getInt((long)index * 8L);
        }
    }

    @Override
    public FieldReader reader() {
        return this.data.getReader();
    }

    @Override
    public Object readObject() {
        return this.vector.getObject(this.idx());
    }

    @Override
    public Types.MinorType getMinorType() {
        return Types.MinorType.LISTVIEW;
    }

    @Override
    public void read(int index, UnionHolder holder) {
        this.setPosition(this.idx());
        for (int i = -1; i < index; ++i) {
            this.next();
        }
        holder.reader = this.data.getReader();
        holder.isSet = this.data.getReader().isSet() ? 1 : 0;
    }

    @Override
    public int size() {
        return Math.max(this.size, 0);
    }

    @Override
    public boolean next() {
        if (this.currentOffset < this.currentOffset + this.size) {
            this.data.getReader().setPosition(LargeMemoryUtil.checkedCastToInt(this.currentOffset++));
            return true;
        }
        return false;
    }
}

