/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gluten.shaded.org.apache.arrow.vector.complex.impl;

import org.apache.gluten.shaded.org.apache.arrow.memory.ArrowBuf;
import org.apache.gluten.shaded.org.apache.arrow.vector.LargeVarCharVector;
import org.apache.gluten.shaded.org.apache.arrow.vector.complex.impl.AbstractFieldWriter;
import org.apache.gluten.shaded.org.apache.arrow.vector.holders.LargeVarCharHolder;
import org.apache.gluten.shaded.org.apache.arrow.vector.holders.NullableLargeVarCharHolder;
import org.apache.gluten.shaded.org.apache.arrow.vector.types.pojo.Field;
import org.apache.gluten.shaded.org.apache.arrow.vector.util.Text;

public class LargeVarCharWriterImpl
extends AbstractFieldWriter {
    final LargeVarCharVector vector;
    private final Text textBuffer = new Text();

    public LargeVarCharWriterImpl(LargeVarCharVector vector) {
        this.vector = vector;
    }

    @Override
    public Field getField() {
        return this.vector.getField();
    }

    @Override
    public int getValueCapacity() {
        return this.vector.getValueCapacity();
    }

    @Override
    public void allocate() {
        this.vector.allocateNew();
    }

    @Override
    public void close() {
        this.vector.close();
    }

    @Override
    public void clear() {
        this.vector.clear();
    }

    @Override
    protected int idx() {
        return super.idx();
    }

    @Override
    public void write(LargeVarCharHolder h2) {
        this.vector.setSafe(this.idx(), h2);
        this.vector.setValueCount(this.idx() + 1);
    }

    public void write(NullableLargeVarCharHolder h2) {
        this.vector.setSafe(this.idx(), h2);
        this.vector.setValueCount(this.idx() + 1);
    }

    @Override
    public void writeLargeVarChar(long start, long end, ArrowBuf buffer) {
        this.vector.setSafe(this.idx(), 1, start, end, buffer);
        this.vector.setValueCount(this.idx() + 1);
    }

    @Override
    public void writeLargeVarChar(Text value) {
        this.vector.setSafe(this.idx(), value);
        this.vector.setValueCount(this.idx() + 1);
    }

    @Override
    public void writeLargeVarChar(String value) {
        this.textBuffer.set(value);
        this.vector.setSafe(this.idx(), this.textBuffer);
        this.vector.setValueCount(this.idx() + 1);
    }

    @Override
    public void writeNull() {
        this.vector.setNull(this.idx());
        this.vector.setValueCount(this.idx() + 1);
    }
}

