/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gluten.shaded.org.apache.arrow.vector.complex.impl;

import java.time.Duration;
import org.apache.gluten.shaded.org.apache.arrow.vector.complex.impl.AbstractFieldReader;
import org.apache.gluten.shaded.org.apache.arrow.vector.complex.writer.IntervalDayWriter;
import org.apache.gluten.shaded.org.apache.arrow.vector.holders.IntervalDayHolder;
import org.apache.gluten.shaded.org.apache.arrow.vector.holders.NullableIntervalDayHolder;
import org.apache.gluten.shaded.org.apache.arrow.vector.types.Types;

public class IntervalDayHolderReaderImpl
extends AbstractFieldReader {
    private IntervalDayHolder holder;

    public IntervalDayHolderReaderImpl(IntervalDayHolder holder) {
        this.holder = holder;
    }

    @Override
    public int size() {
        throw new UnsupportedOperationException("You can't call size on a Holder value reader.");
    }

    @Override
    public boolean next() {
        throw new UnsupportedOperationException("You can't call next on a single value reader.");
    }

    @Override
    public void setPosition(int index) {
        throw new UnsupportedOperationException("You can't call next on a single value reader.");
    }

    @Override
    public Types.MinorType getMinorType() {
        return Types.MinorType.INTERVALDAY;
    }

    @Override
    public boolean isSet() {
        return true;
    }

    @Override
    public void read(IntervalDayHolder h2) {
        h2.days = this.holder.days;
        h2.milliseconds = this.holder.milliseconds;
    }

    @Override
    public void read(NullableIntervalDayHolder h2) {
        h2.days = this.holder.days;
        h2.milliseconds = this.holder.milliseconds;
        h2.isSet = this.isSet() ? 1 : 0;
    }

    @Override
    public Duration readDuration() {
        return Duration.ofDays(this.holder.days).plusMillis(this.holder.milliseconds);
    }

    @Override
    public Object readObject() {
        return this.readDuration();
    }

    @Override
    public void copyAsValue(IntervalDayWriter writer) {
        writer.write(this.holder);
    }
}

