/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gluten.shaded.org.apache.arrow.vector.complex;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.gluten.shaded.org.apache.arrow.memory.ArrowBuf;
import org.apache.gluten.shaded.org.apache.arrow.memory.BufferAllocator;
import org.apache.gluten.shaded.org.apache.arrow.memory.OutOfMemoryException;
import org.apache.gluten.shaded.org.apache.arrow.memory.util.ByteFunctionHelpers;
import org.apache.gluten.shaded.org.apache.arrow.memory.util.CommonUtil;
import org.apache.gluten.shaded.org.apache.arrow.memory.util.LargeMemoryUtil;
import org.apache.gluten.shaded.org.apache.arrow.memory.util.hash.ArrowBufHasher;
import org.apache.gluten.shaded.org.apache.arrow.util.Preconditions;
import org.apache.gluten.shaded.org.apache.arrow.vector.AddOrGetResult;
import org.apache.gluten.shaded.org.apache.arrow.vector.BaseFixedWidthVector;
import org.apache.gluten.shaded.org.apache.arrow.vector.BaseValueVector;
import org.apache.gluten.shaded.org.apache.arrow.vector.BaseVariableWidthVector;
import org.apache.gluten.shaded.org.apache.arrow.vector.BitVectorHelper;
import org.apache.gluten.shaded.org.apache.arrow.vector.BufferBacked;
import org.apache.gluten.shaded.org.apache.arrow.vector.DensityAwareVector;
import org.apache.gluten.shaded.org.apache.arrow.vector.FieldVector;
import org.apache.gluten.shaded.org.apache.arrow.vector.NullVector;
import org.apache.gluten.shaded.org.apache.arrow.vector.UInt4Vector;
import org.apache.gluten.shaded.org.apache.arrow.vector.ValueIterableVector;
import org.apache.gluten.shaded.org.apache.arrow.vector.ValueVector;
import org.apache.gluten.shaded.org.apache.arrow.vector.ZeroVector;
import org.apache.gluten.shaded.org.apache.arrow.vector.compare.VectorVisitor;
import org.apache.gluten.shaded.org.apache.arrow.vector.complex.PromotableVector;
import org.apache.gluten.shaded.org.apache.arrow.vector.complex.RepeatedValueVector;
import org.apache.gluten.shaded.org.apache.arrow.vector.complex.UnionVector;
import org.apache.gluten.shaded.org.apache.arrow.vector.complex.impl.ComplexCopier;
import org.apache.gluten.shaded.org.apache.arrow.vector.complex.impl.UnionLargeListReader;
import org.apache.gluten.shaded.org.apache.arrow.vector.complex.impl.UnionLargeListWriter;
import org.apache.gluten.shaded.org.apache.arrow.vector.complex.reader.FieldReader;
import org.apache.gluten.shaded.org.apache.arrow.vector.ipc.message.ArrowFieldNode;
import org.apache.gluten.shaded.org.apache.arrow.vector.types.Types;
import org.apache.gluten.shaded.org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.gluten.shaded.org.apache.arrow.vector.types.pojo.Field;
import org.apache.gluten.shaded.org.apache.arrow.vector.types.pojo.FieldType;
import org.apache.gluten.shaded.org.apache.arrow.vector.util.CallBack;
import org.apache.gluten.shaded.org.apache.arrow.vector.util.JsonStringArrayList;
import org.apache.gluten.shaded.org.apache.arrow.vector.util.OversizedAllocationException;
import org.apache.gluten.shaded.org.apache.arrow.vector.util.SchemaChangeRuntimeException;
import org.apache.gluten.shaded.org.apache.arrow.vector.util.TransferPair;

public class LargeListVector
extends BaseValueVector
implements RepeatedValueVector,
FieldVector,
PromotableVector,
ValueIterableVector<List<?>> {
    public static final FieldVector DEFAULT_DATA_VECTOR = ZeroVector.INSTANCE;
    public static final String DATA_VECTOR_NAME = "$data$";
    public static final byte OFFSET_WIDTH = 8;
    protected ArrowBuf offsetBuffer;
    protected FieldVector vector;
    protected final CallBack callBack;
    protected int valueCount;
    protected long offsetAllocationSizeInBytes = 31760L;
    protected String defaultDataVectorName = "$data$";
    protected ArrowBuf validityBuffer;
    protected UnionLargeListReader reader;
    private Field field;
    private int validityAllocationSizeInBytes;
    private int lastSet;

    public static LargeListVector empty(String name, BufferAllocator allocator) {
        return new LargeListVector(name, allocator, FieldType.nullable(ArrowType.LargeList.INSTANCE), null);
    }

    public LargeListVector(String name, BufferAllocator allocator, FieldType fieldType, CallBack callBack) {
        this(new Field(name, fieldType, null), allocator, callBack);
    }

    public LargeListVector(Field field, BufferAllocator allocator, CallBack callBack) {
        super(allocator);
        this.field = field;
        this.validityBuffer = allocator.getEmpty();
        this.callBack = callBack;
        this.validityAllocationSizeInBytes = LargeListVector.getValidityBufferSizeFromCount(3970);
        this.lastSet = -1;
        this.offsetBuffer = allocator.getEmpty();
        this.vector = this.vector == null ? DEFAULT_DATA_VECTOR : this.vector;
        this.valueCount = 0;
    }

    @Override
    public void initializeChildrenFromFields(List<Field> children) {
        Preconditions.checkArgument(children.size() == 1, "Lists have one child Field. Found: %s", children.isEmpty() ? "none" : children);
        Field field = children.get(0);
        AddOrGetResult addOrGetVector = this.addOrGetVector(field.getFieldType());
        Preconditions.checkArgument(addOrGetVector.isCreated(), "Child vector already existed: %s", addOrGetVector.getVector());
        ((FieldVector)addOrGetVector.getVector()).initializeChildrenFromFields(field.getChildren());
        this.field = new Field(this.field.getName(), this.field.getFieldType(), children);
    }

    @Override
    public void setInitialCapacity(int numRecords) {
        this.validityAllocationSizeInBytes = LargeListVector.getValidityBufferSizeFromCount(numRecords);
        this.offsetAllocationSizeInBytes = (long)(numRecords + 1) * 8L;
        if (this.vector instanceof BaseFixedWidthVector || this.vector instanceof BaseVariableWidthVector) {
            this.vector.setInitialCapacity(numRecords * 5);
        } else {
            this.vector.setInitialCapacity(numRecords);
        }
    }

    @Override
    public void setInitialCapacity(int numRecords, double density) {
        this.validityAllocationSizeInBytes = LargeListVector.getValidityBufferSizeFromCount(numRecords);
        if ((double)numRecords * density >= 2.147483647E9) {
            throw new OversizedAllocationException("Requested amount of memory is more than max allowed");
        }
        this.offsetAllocationSizeInBytes = ((long)numRecords + 1L) * 8L;
        int innerValueCapacity = Math.max((int)((double)numRecords * density), 1);
        if (this.vector instanceof DensityAwareVector) {
            ((DensityAwareVector)((Object)this.vector)).setInitialCapacity(innerValueCapacity, density);
        } else {
            this.vector.setInitialCapacity(innerValueCapacity);
        }
    }

    public void setInitialTotalCapacity(int numRecords, int totalNumberOfElements) {
        this.offsetAllocationSizeInBytes = ((long)numRecords + 1L) * 8L;
        this.vector.setInitialCapacity(totalNumberOfElements);
    }

    public double getDensity() {
        if (this.valueCount == 0) {
            return 0.0;
        }
        long startOffset = this.offsetBuffer.getLong(0L);
        long endOffset = this.offsetBuffer.getLong((long)this.valueCount * 8L);
        double totalListSize = endOffset - startOffset;
        return totalListSize / (double)this.valueCount;
    }

    @Override
    public List<FieldVector> getChildrenFromFields() {
        return Collections.singletonList(this.getDataVector());
    }

    @Override
    public void loadFieldBuffers(ArrowFieldNode fieldNode, List<ArrowBuf> ownBuffers) {
        if (ownBuffers.size() != 2) {
            throw new IllegalArgumentException("Illegal buffer count, expected 2, got: " + ownBuffers.size());
        }
        ArrowBuf bitBuffer = ownBuffers.get(0);
        ArrowBuf offBuffer = ownBuffers.get(1);
        this.validityBuffer.getReferenceManager().release();
        this.validityBuffer = BitVectorHelper.loadValidityBuffer(fieldNode, bitBuffer, this.allocator);
        this.offsetBuffer.getReferenceManager().release();
        this.offsetBuffer = offBuffer.getReferenceManager().retain(offBuffer, this.allocator);
        this.validityAllocationSizeInBytes = LargeMemoryUtil.checkedCastToInt(this.validityBuffer.capacity());
        this.offsetAllocationSizeInBytes = this.offsetBuffer.capacity();
        this.lastSet = fieldNode.getLength() - 1;
        this.valueCount = fieldNode.getLength();
    }

    @Override
    public List<ArrowBuf> getFieldBuffers() {
        ArrayList<ArrowBuf> result = new ArrayList<ArrowBuf>(2);
        this.setReaderAndWriterIndex();
        result.add(this.validityBuffer);
        result.add(this.offsetBuffer);
        return result;
    }

    @Override
    public void exportCDataBuffers(List<ArrowBuf> buffers, ArrowBuf buffersPtr, long nullValue) {
        this.exportBuffer(this.validityBuffer, buffers, buffersPtr, nullValue, true);
        if (this.offsetBuffer.capacity() == 0L) {
            this.exportBuffer(this.allocateOffsetBuffer(8L), buffers, buffersPtr, nullValue, false);
        } else {
            this.exportBuffer(this.offsetBuffer, buffers, buffersPtr, nullValue, true);
        }
    }

    private void setReaderAndWriterIndex() {
        this.validityBuffer.readerIndex(0L);
        this.offsetBuffer.readerIndex(0L);
        if (this.valueCount == 0) {
            this.validityBuffer.writerIndex(0L);
            this.offsetBuffer.writerIndex(0L);
        } else {
            this.validityBuffer.writerIndex(LargeListVector.getValidityBufferSizeFromCount(this.valueCount));
            this.offsetBuffer.writerIndex((this.valueCount + 1) * 8);
        }
    }

    @Override
    @Deprecated
    public List<BufferBacked> getFieldInnerVectors() {
        throw new UnsupportedOperationException("There are no inner vectors. Use getFieldBuffers");
    }

    @Override
    public void allocateNew() throws OutOfMemoryException {
        if (!this.allocateNewSafe()) {
            throw new OutOfMemoryException("Failure while allocating memory");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean allocateNewSafe() {
        boolean success = false;
        try {
            this.clear();
            this.allocateValidityBuffer(this.validityAllocationSizeInBytes);
            boolean dataAlloc = false;
            try {
                this.offsetBuffer = this.allocateOffsetBuffer(this.offsetAllocationSizeInBytes);
                dataAlloc = this.vector.allocateNewSafe();
            }
            catch (Exception e) {
                e.printStackTrace();
                this.clear();
                success = false;
            }
            finally {
                if (!dataAlloc) {
                    this.clear();
                }
            }
            success = dataAlloc;
        }
        finally {
            if (!success) {
                this.clear();
            }
        }
        return success;
    }

    private void allocateValidityBuffer(long size) {
        int curSize = (int)size;
        this.validityBuffer = this.allocator.buffer(curSize);
        this.validityBuffer.readerIndex(0L);
        this.validityAllocationSizeInBytes = curSize;
        this.validityBuffer.setZero(0L, this.validityBuffer.capacity());
    }

    protected ArrowBuf allocateOffsetBuffer(long size) {
        ArrowBuf offsetBuffer = this.allocator.buffer(size);
        offsetBuffer.readerIndex(0L);
        this.offsetAllocationSizeInBytes = size;
        offsetBuffer.setZero(0L, offsetBuffer.capacity());
        return offsetBuffer;
    }

    @Override
    public void reAlloc() {
        this.reallocValidityBuffer();
        this.reallocOffsetBuffer();
        this.vector.reAlloc();
    }

    private void reallocValidityAndOffsetBuffers() {
        this.reallocOffsetBuffer();
        this.reallocValidityBuffer();
    }

    protected void reallocOffsetBuffer() {
        long currentBufferCapacity = this.offsetBuffer.capacity();
        long newAllocationSize = currentBufferCapacity * 2L;
        if (newAllocationSize == 0L) {
            newAllocationSize = this.offsetAllocationSizeInBytes > 0L ? this.offsetAllocationSizeInBytes : 63520L;
        }
        newAllocationSize = CommonUtil.nextPowerOfTwo(newAllocationSize);
        newAllocationSize = Math.min(newAllocationSize, 0x3FFFFFFF8L);
        assert (newAllocationSize >= 1L);
        if (newAllocationSize > MAX_ALLOCATION_SIZE || newAllocationSize <= this.offsetBuffer.capacity()) {
            throw new OversizedAllocationException("Unable to expand the buffer");
        }
        ArrowBuf newBuf = this.allocator.buffer(newAllocationSize);
        newBuf.setBytes(0L, this.offsetBuffer, 0L, currentBufferCapacity);
        newBuf.setZero(currentBufferCapacity, newBuf.capacity() - currentBufferCapacity);
        this.offsetBuffer.getReferenceManager().release(1);
        this.offsetBuffer = newBuf;
        this.offsetAllocationSizeInBytes = newAllocationSize;
    }

    private void reallocValidityBuffer() {
        int currentBufferCapacity = LargeMemoryUtil.checkedCastToInt(this.validityBuffer.capacity());
        long newAllocationSize = (long)currentBufferCapacity * 2L;
        if (newAllocationSize == 0L) {
            newAllocationSize = this.validityAllocationSizeInBytes > 0 ? (long)this.validityAllocationSizeInBytes : (long)LargeListVector.getValidityBufferSizeFromCount(3970) * 2L;
        }
        newAllocationSize = CommonUtil.nextPowerOfTwo(newAllocationSize);
        assert (newAllocationSize >= 1L);
        if (newAllocationSize > MAX_ALLOCATION_SIZE) {
            throw new OversizedAllocationException("Unable to expand the buffer");
        }
        ArrowBuf newBuf = this.allocator.buffer(newAllocationSize);
        newBuf.setBytes(0L, this.validityBuffer, 0L, (long)currentBufferCapacity);
        newBuf.setZero(currentBufferCapacity, newBuf.capacity() - (long)currentBufferCapacity);
        this.validityBuffer.getReferenceManager().release(1);
        this.validityBuffer = newBuf;
        this.validityAllocationSizeInBytes = (int)newAllocationSize;
    }

    @Override
    public void copyFromSafe(int inIndex, int outIndex, ValueVector from) {
        this.copyFrom(inIndex, outIndex, from);
    }

    @Override
    public void copyFrom(int inIndex, int outIndex, ValueVector from) {
        Preconditions.checkArgument(this.getMinorType() == from.getMinorType());
        FieldReader in = from.getReader();
        in.setPosition(inIndex);
        UnionLargeListWriter out = this.getWriter();
        out.setPosition(outIndex);
        ComplexCopier.copy(in, out);
    }

    @Override
    @Deprecated
    public UInt4Vector getOffsetVector() {
        throw new UnsupportedOperationException("There is no inner offset vector");
    }

    @Override
    public FieldVector getDataVector() {
        return this.vector;
    }

    @Override
    public TransferPair getTransferPair(String ref, BufferAllocator allocator) {
        return this.getTransferPair(ref, allocator, null);
    }

    @Override
    public TransferPair getTransferPair(Field field, BufferAllocator allocator) {
        return this.getTransferPair(field, allocator, null);
    }

    @Override
    public TransferPair getTransferPair(String ref, BufferAllocator allocator, CallBack callBack) {
        return new TransferImpl(ref, allocator, callBack);
    }

    @Override
    public TransferPair getTransferPair(Field field, BufferAllocator allocator, CallBack callBack) {
        return new TransferImpl(field, allocator, callBack);
    }

    @Override
    public TransferPair makeTransferPair(ValueVector target) {
        return new TransferImpl((LargeListVector)target);
    }

    @Override
    public long getValidityBufferAddress() {
        return this.validityBuffer.memoryAddress();
    }

    @Override
    public long getDataBufferAddress() {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getOffsetBufferAddress() {
        return this.offsetBuffer.memoryAddress();
    }

    @Override
    public ArrowBuf getValidityBuffer() {
        return this.validityBuffer;
    }

    @Override
    public ArrowBuf getDataBuffer() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ArrowBuf getOffsetBuffer() {
        return this.offsetBuffer;
    }

    @Override
    public int getValueCount() {
        return this.valueCount;
    }

    @Override
    public int hashCode(int index) {
        return this.hashCode(index, null);
    }

    @Override
    public int hashCode(int index, ArrowBufHasher hasher) {
        if (this.isSet(index) == 0) {
            return 0;
        }
        int hash = 0;
        long start = this.offsetBuffer.getLong((long)index * 8L);
        long end = this.offsetBuffer.getLong(((long)index + 1L) * 8L);
        for (long i = start; i < end; ++i) {
            hash = ByteFunctionHelpers.combineHash(hash, this.vector.hashCode(LargeMemoryUtil.checkedCastToInt(i), hasher));
        }
        return hash;
    }

    @Override
    public <OUT, IN> OUT accept(VectorVisitor<OUT, IN> visitor, IN value) {
        return visitor.visit(this, value);
    }

    public UnionLargeListWriter getWriter() {
        return new UnionLargeListWriter(this);
    }

    protected void replaceDataVector(FieldVector v) {
        this.vector.clear();
        this.vector = v;
    }

    @Override
    public UnionVector promoteToUnion() {
        UnionVector vector = new UnionVector(DATA_VECTOR_NAME, this.allocator, null, this.callBack);
        this.replaceDataVector(vector);
        this.invalidateReader();
        if (this.callBack != null) {
            this.callBack.doWork();
        }
        return vector;
    }

    @Override
    protected FieldReader getReaderImpl() {
        return new UnionLargeListReader(this);
    }

    @Override
    public UnionLargeListReader getReader() {
        this.reader = (UnionLargeListReader)super.getReader();
        return this.reader;
    }

    @Override
    public <T extends ValueVector> AddOrGetResult<T> addOrGetVector(FieldType fieldType) {
        boolean created = false;
        if (this.vector instanceof NullVector) {
            this.vector = fieldType.createNewSingleVector(this.defaultDataVectorName, this.allocator, this.callBack);
            created = true;
            if (this.callBack != null && fieldType.getType().getTypeID() != ArrowType.ArrowTypeID.Null) {
                this.callBack.doWork();
            }
        }
        if (this.vector.getField().getType().getTypeID() != fieldType.getType().getTypeID()) {
            String msg = String.format("Inner vector type mismatch. Requested type: [%s], actual type: [%s]", new Object[]{fieldType.getType().getTypeID(), this.vector.getField().getType().getTypeID()});
            throw new SchemaChangeRuntimeException(msg);
        }
        this.invalidateReader();
        return new AddOrGetResult<FieldVector>(this.vector, created);
    }

    @Override
    public int getBufferSize() {
        if (this.valueCount == 0) {
            return 0;
        }
        int offsetBufferSize = (this.valueCount + 1) * 8;
        int validityBufferSize = LargeListVector.getValidityBufferSizeFromCount(this.valueCount);
        return offsetBufferSize + validityBufferSize + this.vector.getBufferSize();
    }

    @Override
    public int getBufferSizeFor(int valueCount) {
        if (valueCount == 0) {
            return 0;
        }
        int validityBufferSize = LargeListVector.getValidityBufferSizeFromCount(valueCount);
        long innerVectorValueCount = this.offsetBuffer.getLong((long)valueCount * 8L);
        return (valueCount + 1) * 8 + this.vector.getBufferSizeFor(LargeMemoryUtil.checkedCastToInt(innerVectorValueCount)) + validityBufferSize;
    }

    @Override
    public Field getField() {
        if (this.field.getChildren().contains(this.getDataVector().getField())) {
            return this.field;
        }
        this.field = new Field(this.field.getName(), this.field.getFieldType(), Collections.singletonList(this.getDataVector().getField()));
        return this.field;
    }

    @Override
    public Types.MinorType getMinorType() {
        return Types.MinorType.LARGELIST;
    }

    @Override
    public String getName() {
        return this.field.getName();
    }

    @Override
    public void clear() {
        this.offsetBuffer = this.releaseBuffer(this.offsetBuffer);
        this.vector.clear();
        this.valueCount = 0;
        super.clear();
        this.validityBuffer = this.releaseBuffer(this.validityBuffer);
        this.lastSet = -1;
    }

    @Override
    public void reset() {
        this.offsetBuffer.setZero(0L, this.offsetBuffer.capacity());
        this.vector.reset();
        this.valueCount = 0;
        this.validityBuffer.setZero(0L, this.validityBuffer.capacity());
        this.lastSet = -1;
    }

    @Override
    public ArrowBuf[] getBuffers(boolean clear) {
        ArrowBuf[] buffers;
        this.setReaderAndWriterIndex();
        if (this.getBufferSize() == 0) {
            buffers = new ArrowBuf[]{};
        } else {
            ArrayList<ArrowBuf> list = new ArrayList<ArrowBuf>();
            list.add(this.offsetBuffer);
            list.add(this.validityBuffer);
            list.addAll(Arrays.asList(this.vector.getBuffers(false)));
            buffers = list.toArray(new ArrowBuf[list.size()]);
        }
        if (clear) {
            for (ArrowBuf buffer : buffers) {
                buffer.getReferenceManager().retain();
            }
            this.clear();
        }
        return buffers;
    }

    protected void invalidateReader() {
        this.reader = null;
    }

    @Override
    public List<?> getObject(int index) {
        if (this.isSet(index) == 0) {
            return null;
        }
        JsonStringArrayList<Object> vals = new JsonStringArrayList<Object>();
        long start = this.offsetBuffer.getLong((long)index * 8L);
        long end = this.offsetBuffer.getLong(((long)index + 1L) * 8L);
        FieldVector vv = this.getDataVector();
        for (long i = start; i < end; ++i) {
            vals.add(vv.getObject(LargeMemoryUtil.checkedCastToInt(i)));
        }
        return vals;
    }

    @Override
    public boolean isNull(int index) {
        return this.isSet(index) == 0;
    }

    public boolean isEmpty(int index) {
        long end;
        if (this.isNull(index)) {
            return true;
        }
        long start = this.offsetBuffer.getLong((long)index * 8L);
        return start == (end = this.offsetBuffer.getLong(((long)index + 1L) * 8L));
    }

    public int isSet(int index) {
        int byteIndex = index >> 3;
        byte b = this.validityBuffer.getByte(byteIndex);
        int bitIndex = index & 7;
        return b >> bitIndex & 1;
    }

    @Override
    public int getNullCount() {
        return BitVectorHelper.getNullCount(this.validityBuffer, this.valueCount);
    }

    @Override
    public int getValueCapacity() {
        return this.getValidityAndOffsetValueCapacity();
    }

    protected int getOffsetBufferValueCapacity() {
        return LargeMemoryUtil.checkedCastToInt(this.offsetBuffer.capacity() / 8L);
    }

    private int getValidityAndOffsetValueCapacity() {
        int offsetValueCapacity = Math.max(this.getOffsetBufferValueCapacity() - 1, 0);
        return Math.min(offsetValueCapacity, this.getValidityBufferValueCapacity());
    }

    private int getValidityBufferValueCapacity() {
        return LargeMemoryUtil.capAtMaxInt(this.validityBuffer.capacity() * 8L);
    }

    public void setNotNull(int index) {
        while (index >= this.getValidityAndOffsetValueCapacity()) {
            this.reallocValidityAndOffsetBuffers();
        }
        BitVectorHelper.setBit(this.validityBuffer, index);
        this.lastSet = index;
    }

    @Override
    public void setNull(int index) {
        while (index >= this.getValidityAndOffsetValueCapacity()) {
            this.reallocValidityAndOffsetBuffers();
        }
        if (this.lastSet >= index) {
            this.lastSet = index - 1;
        }
        for (int i = this.lastSet + 1; i <= index; ++i) {
            int currentOffset = this.offsetBuffer.getInt(i * 8);
            this.offsetBuffer.setInt((i + 1) * 8, currentOffset);
        }
        BitVectorHelper.unsetBit(this.validityBuffer, index);
    }

    public long startNewValue(long index) {
        while (index >= (long)this.getValidityAndOffsetValueCapacity()) {
            this.reallocValidityAndOffsetBuffers();
        }
        int i = this.lastSet + 1;
        while ((long)i <= index) {
            long currentOffset = this.offsetBuffer.getLong((long)i * 8L);
            this.offsetBuffer.setLong(((long)i + 1L) * 8L, currentOffset);
            ++i;
        }
        BitVectorHelper.setBit(this.validityBuffer, index);
        this.lastSet = LargeMemoryUtil.checkedCastToInt(index);
        return this.offsetBuffer.getLong(((long)this.lastSet + 1L) * 8L);
    }

    public void endValue(int index, long size) {
        long currentOffset = this.offsetBuffer.getLong(((long)index + 1L) * 8L);
        this.offsetBuffer.setLong(((long)index + 1L) * 8L, currentOffset + size);
    }

    @Override
    public void setValueCount(int valueCount) {
        this.valueCount = valueCount;
        if (valueCount > 0) {
            while (valueCount > this.getValidityAndOffsetValueCapacity()) {
                this.reallocValidityAndOffsetBuffers();
            }
            for (int i = this.lastSet + 1; i < valueCount; ++i) {
                long currentOffset = this.offsetBuffer.getLong((long)i * 8L);
                this.offsetBuffer.setLong(((long)i + 1L) * 8L, currentOffset);
            }
        }
        long childValueCount = valueCount == 0 ? 0L : this.offsetBuffer.getLong(((long)this.lastSet + 1L) * 8L);
        Preconditions.checkArgument(childValueCount <= Integer.MAX_VALUE || childValueCount >= Integer.MIN_VALUE, "LargeListVector doesn't yet support 64-bit allocations: %s", childValueCount);
        this.vector.setValueCount((int)childValueCount);
    }

    public void setLastSet(int value) {
        this.lastSet = value;
    }

    public int getLastSet() {
        return this.lastSet;
    }

    public long getElementStartIndex(int index) {
        return this.offsetBuffer.getLong((long)index * 8L);
    }

    public long getElementEndIndex(int index) {
        return this.offsetBuffer.getLong(((long)index + 1L) * 8L);
    }

    private class TransferImpl
    implements TransferPair {
        LargeListVector to;
        TransferPair dataTransferPair;

        public TransferImpl(String name, BufferAllocator allocator, CallBack callBack) {
            this(new LargeListVector(name, allocator, largeListVector.field.getFieldType(), callBack));
        }

        public TransferImpl(Field field, BufferAllocator allocator, CallBack callBack) {
            this(new LargeListVector(field, allocator, callBack));
        }

        public TransferImpl(LargeListVector to) {
            this.to = to;
            to.addOrGetVector(LargeListVector.this.vector.getField().getFieldType());
            if (to.getDataVector() instanceof ZeroVector) {
                to.addOrGetVector(LargeListVector.this.vector.getField().getFieldType());
            }
            this.dataTransferPair = LargeListVector.this.getDataVector().makeTransferPair(to.getDataVector());
        }

        @Override
        public void transfer() {
            this.to.clear();
            this.dataTransferPair.transfer();
            this.to.validityBuffer = BaseValueVector.transferBuffer(LargeListVector.this.validityBuffer, this.to.allocator);
            this.to.offsetBuffer = BaseValueVector.transferBuffer(LargeListVector.this.offsetBuffer, this.to.allocator);
            this.to.lastSet = LargeListVector.this.lastSet;
            if (LargeListVector.this.valueCount > 0) {
                this.to.setValueCount(LargeListVector.this.valueCount);
            }
            LargeListVector.this.clear();
        }

        @Override
        public void splitAndTransfer(int startIndex, int length) {
            Preconditions.checkArgument(startIndex >= 0 && length >= 0 && startIndex + length <= LargeListVector.this.valueCount, "Invalid parameters startIndex: %s, length: %s for valueCount: %s", (Object)startIndex, (Object)length, (Object)LargeListVector.this.valueCount);
            long startPoint = LargeListVector.this.offsetBuffer.getLong((long)startIndex * 8L);
            long sliceLength = LargeListVector.this.offsetBuffer.getLong((long)(startIndex + length) * 8L) - startPoint;
            this.to.clear();
            this.to.offsetBuffer = this.to.allocateOffsetBuffer((length + 1) * 8);
            for (int i = 0; i < length + 1; ++i) {
                long relativeOffset = LargeListVector.this.offsetBuffer.getLong((long)(startIndex + i) * 8L) - startPoint;
                this.to.offsetBuffer.setLong((long)i * 8L, relativeOffset);
            }
            this.splitAndTransferValidityBuffer(startIndex, length, this.to);
            this.dataTransferPair.splitAndTransfer(LargeMemoryUtil.checkedCastToInt(startPoint), LargeMemoryUtil.checkedCastToInt(sliceLength));
            this.to.lastSet = length - 1;
            this.to.setValueCount(length);
        }

        private void splitAndTransferValidityBuffer(int startIndex, int length, LargeListVector target) {
            int firstByteSource = BitVectorHelper.byteIndex(startIndex);
            int lastByteSource = BitVectorHelper.byteIndex(LargeListVector.this.valueCount - 1);
            int byteSizeTarget = LargeListVector.getValidityBufferSizeFromCount(length);
            int offset = startIndex % 8;
            if (length > 0) {
                if (offset == 0) {
                    if (target.validityBuffer != null) {
                        target.validityBuffer.getReferenceManager().release();
                    }
                    target.validityBuffer = LargeListVector.this.validityBuffer.slice(firstByteSource, byteSizeTarget);
                    target.validityBuffer.getReferenceManager().retain(1);
                } else {
                    byte b1;
                    target.allocateValidityBuffer(byteSizeTarget);
                    for (int i = 0; i < byteSizeTarget - 1; ++i) {
                        byte b12 = BitVectorHelper.getBitsFromCurrentByte(LargeListVector.this.validityBuffer, firstByteSource + i, offset);
                        byte b2 = BitVectorHelper.getBitsFromNextByte(LargeListVector.this.validityBuffer, firstByteSource + i + 1, offset);
                        target.validityBuffer.setByte((long)i, b12 + b2);
                    }
                    if (firstByteSource + byteSizeTarget - 1 < lastByteSource) {
                        b1 = BitVectorHelper.getBitsFromCurrentByte(LargeListVector.this.validityBuffer, firstByteSource + byteSizeTarget - 1, offset);
                        byte b2 = BitVectorHelper.getBitsFromNextByte(LargeListVector.this.validityBuffer, firstByteSource + byteSizeTarget, offset);
                        target.validityBuffer.setByte((long)(byteSizeTarget - 1), b1 + b2);
                    } else {
                        b1 = BitVectorHelper.getBitsFromCurrentByte(LargeListVector.this.validityBuffer, firstByteSource + byteSizeTarget - 1, offset);
                        target.validityBuffer.setByte((long)(byteSizeTarget - 1), b1);
                    }
                }
            }
        }

        @Override
        public ValueVector getTo() {
            return this.to;
        }

        @Override
        public void copyValueSafe(int from, int to) {
            this.to.copyFrom(from, to, LargeListVector.this);
        }
    }
}

