/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gluten.shaded.org.apache.arrow.vector;

import org.apache.gluten.shaded.org.apache.arrow.memory.BufferAllocator;
import org.apache.gluten.shaded.org.apache.arrow.memory.ReusableBuffer;
import org.apache.gluten.shaded.org.apache.arrow.vector.BaseVariableWidthVector;
import org.apache.gluten.shaded.org.apache.arrow.vector.BitVectorHelper;
import org.apache.gluten.shaded.org.apache.arrow.vector.NullCheckingForGet;
import org.apache.gluten.shaded.org.apache.arrow.vector.ValueIterableVector;
import org.apache.gluten.shaded.org.apache.arrow.vector.ValueVector;
import org.apache.gluten.shaded.org.apache.arrow.vector.complex.impl.VarCharReaderImpl;
import org.apache.gluten.shaded.org.apache.arrow.vector.complex.reader.FieldReader;
import org.apache.gluten.shaded.org.apache.arrow.vector.holders.NullableVarCharHolder;
import org.apache.gluten.shaded.org.apache.arrow.vector.holders.VarCharHolder;
import org.apache.gluten.shaded.org.apache.arrow.vector.types.Types;
import org.apache.gluten.shaded.org.apache.arrow.vector.types.pojo.Field;
import org.apache.gluten.shaded.org.apache.arrow.vector.types.pojo.FieldType;
import org.apache.gluten.shaded.org.apache.arrow.vector.util.Text;
import org.apache.gluten.shaded.org.apache.arrow.vector.util.TransferPair;
import org.apache.gluten.shaded.org.apache.arrow.vector.validate.ValidateUtil;

public final class VarCharVector
extends BaseVariableWidthVector
implements ValueIterableVector<Text> {
    public VarCharVector(String name, BufferAllocator allocator) {
        this(name, FieldType.nullable(Types.MinorType.VARCHAR.getType()), allocator);
    }

    public VarCharVector(String name, FieldType fieldType, BufferAllocator allocator) {
        this(new Field(name, fieldType, null), allocator);
    }

    public VarCharVector(Field field, BufferAllocator allocator) {
        super(field, allocator);
    }

    @Override
    protected FieldReader getReaderImpl() {
        return new VarCharReaderImpl(this);
    }

    @Override
    public Types.MinorType getMinorType() {
        return Types.MinorType.VARCHAR;
    }

    @Override
    public byte[] get(int index) {
        assert (index >= 0);
        if (NullCheckingForGet.NULL_CHECKING_ENABLED && this.isSet(index) == 0) {
            return null;
        }
        int startOffset = this.getStartOffset(index);
        int dataLength = this.getEndOffset(index) - startOffset;
        byte[] result = new byte[dataLength];
        this.valueBuffer.getBytes((long)startOffset, result, 0, dataLength);
        return result;
    }

    @Override
    public Text getObject(int index) {
        assert (index >= 0);
        if (NullCheckingForGet.NULL_CHECKING_ENABLED && this.isSet(index) == 0) {
            return null;
        }
        Text result = new Text();
        this.read(index, result);
        return result;
    }

    @Override
    public void read(int index, ReusableBuffer<?> buffer) {
        int startOffset = this.getStartOffset(index);
        int dataLength = this.getEndOffset(index) - startOffset;
        buffer.set(this.valueBuffer, (long)startOffset, (long)dataLength);
    }

    public void get(int index, NullableVarCharHolder holder) {
        assert (index >= 0);
        if (this.isSet(index) == 0) {
            holder.isSet = 0;
            return;
        }
        holder.isSet = 1;
        holder.start = this.getStartOffset(index);
        holder.end = this.getEndOffset(index);
        holder.buffer = this.valueBuffer;
    }

    public void set(int index, VarCharHolder holder) {
        assert (index >= 0);
        this.fillHoles(index);
        BitVectorHelper.setBit(this.validityBuffer, index);
        int dataLength = holder.end - holder.start;
        int startOffset = this.getStartOffset(index);
        this.offsetBuffer.setInt((long)(index + 1) * 4L, startOffset + dataLength);
        this.valueBuffer.setBytes((long)startOffset, holder.buffer, (long)holder.start, (long)dataLength);
        this.lastSet = index;
    }

    public void setSafe(int index, VarCharHolder holder) {
        assert (index >= 0);
        int dataLength = holder.end - holder.start;
        this.handleSafe(index, dataLength);
        this.fillHoles(index);
        BitVectorHelper.setBit(this.validityBuffer, index);
        int startOffset = this.getStartOffset(index);
        this.offsetBuffer.setInt((long)(index + 1) * 4L, startOffset + dataLength);
        this.valueBuffer.setBytes((long)startOffset, holder.buffer, (long)holder.start, (long)dataLength);
        this.lastSet = index;
    }

    public void set(int index, NullableVarCharHolder holder) {
        assert (index >= 0);
        this.fillHoles(index);
        BitVectorHelper.setValidityBit(this.validityBuffer, index, holder.isSet);
        int startOffset = this.getStartOffset(index);
        if (holder.isSet != 0) {
            int dataLength = holder.end - holder.start;
            this.offsetBuffer.setInt((long)(index + 1) * 4L, startOffset + dataLength);
            this.valueBuffer.setBytes((long)startOffset, holder.buffer, (long)holder.start, (long)dataLength);
        } else {
            this.offsetBuffer.setInt((long)(index + 1) * 4L, startOffset);
        }
        this.lastSet = index;
    }

    public void setSafe(int index, NullableVarCharHolder holder) {
        assert (index >= 0);
        if (holder.isSet != 0) {
            int dataLength = holder.end - holder.start;
            this.handleSafe(index, dataLength);
            this.fillHoles(index);
            int startOffset = this.getStartOffset(index);
            this.offsetBuffer.setInt((long)(index + 1) * 4L, startOffset + dataLength);
            this.valueBuffer.setBytes((long)startOffset, holder.buffer, (long)holder.start, (long)dataLength);
        } else {
            this.fillEmpties(index + 1);
        }
        BitVectorHelper.setValidityBit(this.validityBuffer, index, holder.isSet);
        this.lastSet = index;
    }

    public void set(int index, Text text) {
        this.set(index, text.getBytes(), 0, (int)text.getLength());
    }

    public void setSafe(int index, Text text) {
        this.setSafe(index, text.getBytes(), 0, (int)text.getLength());
    }

    @Override
    public void validateScalars() {
        for (int i = 0; i < this.getValueCount(); ++i) {
            byte[] value = this.get(i);
            if (value == null) continue;
            ValidateUtil.validateOrThrow(Text.validateUTF8NoThrow(value), "Non-UTF-8 data in VarCharVector at position " + i + ".");
        }
    }

    @Override
    public TransferPair getTransferPair(String ref, BufferAllocator allocator) {
        return new TransferImpl(ref, allocator);
    }

    @Override
    public TransferPair getTransferPair(Field field, BufferAllocator allocator) {
        return new TransferImpl(field, allocator);
    }

    @Override
    public TransferPair makeTransferPair(ValueVector to) {
        return new TransferImpl((VarCharVector)to);
    }

    private class TransferImpl
    implements TransferPair {
        VarCharVector to;

        public TransferImpl(String ref, BufferAllocator allocator) {
            this.to = new VarCharVector(ref, VarCharVector.this.field.getFieldType(), allocator);
        }

        public TransferImpl(Field field, BufferAllocator allocator) {
            this.to = new VarCharVector(field, allocator);
        }

        public TransferImpl(VarCharVector to) {
            this.to = to;
        }

        @Override
        public VarCharVector getTo() {
            return this.to;
        }

        @Override
        public void transfer() {
            VarCharVector.this.transferTo(this.to);
        }

        @Override
        public void splitAndTransfer(int startIndex, int length) {
            VarCharVector.this.splitAndTransferTo(startIndex, length, this.to);
        }

        @Override
        public void copyValueSafe(int fromIndex, int toIndex) {
            this.to.copyFromSafe(fromIndex, toIndex, VarCharVector.this);
        }
    }
}

