/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gluten.shaded.com.google.common.io;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.Set;
import org.apache.gluten.shaded.com.google.common.annotations.GwtIncompatible;
import org.apache.gluten.shaded.com.google.common.annotations.J2ktIncompatible;
import org.apache.gluten.shaded.com.google.common.base.StandardSystemProperty;
import org.apache.gluten.shaded.com.google.common.io.ElementTypesAreNonnullByDefault;
import org.apache.gluten.shaded.com.google.common.io.IgnoreJRERequirement;

@ElementTypesAreNonnullByDefault
@J2ktIncompatible
@GwtIncompatible
abstract class TempFileCreator {
    static final TempFileCreator INSTANCE = TempFileCreator.pickSecureCreator();

    abstract File createTempDir();

    abstract File createTempFile(String var1) throws IOException;

    private static TempFileCreator pickSecureCreator() {
        try {
            Class.forName("java.nio.file.Path");
            return new JavaNioCreator();
        }
        catch (ClassNotFoundException classNotFoundException) {
            try {
                int version = (Integer)Class.forName("android.os.Build$VERSION").getField("SDK_INT").get(null);
                int jellyBean = (Integer)Class.forName("android.os.Build$VERSION_CODES").getField("JELLY_BEAN").get(null);
                if (version < jellyBean) {
                    return new ThrowingCreator();
                }
            }
            catch (NoSuchFieldException e) {
                return new ThrowingCreator();
            }
            catch (ClassNotFoundException e) {
                return new ThrowingCreator();
            }
            catch (IllegalAccessException e) {
                return new ThrowingCreator();
            }
            return new JavaIoCreator();
        }
    }

    private TempFileCreator() {
    }

    private static final class ThrowingCreator
    extends TempFileCreator {
        private static final String MESSAGE = "Guava cannot securely create temporary files or directories under SDK versions before Jelly Bean. You can create one yourself, either in the insecure default directory or in a more secure directory, such as context.getCacheDir(). For more information, see the Javadoc for Files.createTempDir().";

        private ThrowingCreator() {
        }

        @Override
        File createTempDir() {
            throw new IllegalStateException(MESSAGE);
        }

        @Override
        File createTempFile(String prefix) throws IOException {
            throw new IOException(MESSAGE);
        }
    }

    private static final class JavaIoCreator
    extends TempFileCreator {
        private static final int TEMP_DIR_ATTEMPTS = 10000;

        private JavaIoCreator() {
        }

        @Override
        File createTempDir() {
            File baseDir = new File(StandardSystemProperty.JAVA_IO_TMPDIR.value());
            String baseName = System.currentTimeMillis() + "-";
            for (int counter = 0; counter < 10000; ++counter) {
                File tempDir = new File(baseDir, baseName + counter);
                if (!tempDir.mkdir()) continue;
                return tempDir;
            }
            throw new IllegalStateException("Failed to create directory within 10000 attempts (tried " + baseName + "0 to " + baseName + 9999 + ')');
        }

        @Override
        File createTempFile(String prefix) throws IOException {
            return File.createTempFile(prefix, null, null);
        }
    }

    @IgnoreJRERequirement
    private static final class JavaNioCreator
    extends TempFileCreator {
        private static final FileAttribute<Set<PosixFilePermission>> RWX_USER_ONLY = PosixFilePermissions.asFileAttribute(PosixFilePermissions.fromString("rwx------"));
        private static final FileAttribute<Set<PosixFilePermission>> RW_USER_ONLY = PosixFilePermissions.asFileAttribute(PosixFilePermissions.fromString("rw-------"));

        private JavaNioCreator() {
        }

        @Override
        File createTempDir() {
            try {
                return Files.createTempDirectory(Paths.get(StandardSystemProperty.JAVA_IO_TMPDIR.value(), new String[0]), null, RWX_USER_ONLY).toFile();
            }
            catch (IOException e) {
                throw new IllegalStateException("Failed to create directory", e);
            }
        }

        @Override
        File createTempFile(String prefix) throws IOException {
            return Files.createTempFile(Paths.get(StandardSystemProperty.JAVA_IO_TMPDIR.value(), new String[0]), prefix, null, RW_USER_ONLY).toFile();
        }
    }
}

