/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gluten.shaded.com.google.common.hash;

import java.util.concurrent.atomic.AtomicLong;
import org.apache.gluten.shaded.com.google.common.base.Supplier;
import org.apache.gluten.shaded.com.google.common.hash.ElementTypesAreNonnullByDefault;
import org.apache.gluten.shaded.com.google.common.hash.LongAddable;
import org.apache.gluten.shaded.com.google.common.hash.LongAdder;

@ElementTypesAreNonnullByDefault
final class LongAddables {
    private static final Supplier<LongAddable> SUPPLIER;

    LongAddables() {
    }

    public static LongAddable create() {
        return SUPPLIER.get();
    }

    static {
        Supplier<LongAddable> supplier;
        try {
            LongAdder unused = new LongAdder();
            supplier = new Supplier<LongAddable>(){

                @Override
                public LongAddable get() {
                    return new LongAdder();
                }
            };
        }
        catch (Throwable t2) {
            supplier = new Supplier<LongAddable>(){

                @Override
                public LongAddable get() {
                    return new PureJavaLongAddable();
                }
            };
        }
        SUPPLIER = supplier;
    }

    private static final class PureJavaLongAddable
    extends AtomicLong
    implements LongAddable {
        private PureJavaLongAddable() {
        }

        @Override
        public void increment() {
            this.getAndIncrement();
        }

        @Override
        public void add(long x) {
            this.getAndAdd(x);
        }

        @Override
        public long sum() {
            return this.get();
        }
    }
}

