/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gluten.runtime;

import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.gluten.config.GlutenConfig$;
import org.apache.gluten.exception.GlutenException;
import org.apache.gluten.memory.NativeMemoryManager;
import org.apache.gluten.memory.NativeMemoryManager$;
import org.apache.gluten.runtime.RuntimeJniWrapper;
import org.apache.gluten.utils.ConfigUtil;
import org.apache.spark.sql.internal.GlutenConfigUtil$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.task.TaskResource;
import scala.collection.IterableOnce;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u0005maa\u0002\r\u001a!\u0003\r\nA\t\u0005\u0006S\u00011\tA\u000b\u0005\u0006c\u00011\tAM\u0004\u0006meA\ta\u000e\u0004\u00061eA\t!\u000f\u0005\u0006u\u0011!\ta\u000f\u0005\u0007y\u0011!\t!G\u001f\t\rq\"A\u0011A\rZ\r\u0011AG\u0001B5\t\u0011-C!\u0011!Q\u0001\n1C\u0001\u0002\u0017\u0005\u0003\u0002\u0003\u0006I\u0001\u0014\u0005\t?\"\u0011\t\u0011)A\u0005A\")!\b\u0003C\u0001U\"9\u0001\u000f\u0003b\u0001\n\u0013\t\bB\u0002:\tA\u0003%1\u0006C\u0004t\u0011\t\u0007I\u0011\u0002;\t\rUD\u0001\u0015!\u00034\u0011\u001d1\bB1A\u0005\n]Dq!!\u0001\tA\u0003%\u0001\u0010C\u00032\u0011\u0011\u0005#\u0007C\u0003*\u0011\u0011\u0005#\u0006C\u0004\u0002\u0004!!\t%!\u0002\t\u000f\u00055\u0001\u0002\"\u0011\u0002\u0010!9\u0011q\u0003\u0005\u0005B\u0005e!a\u0002*v]RLW.\u001a\u0006\u00035m\tqA];oi&lWM\u0003\u0002\u001d;\u00051q\r\\;uK:T!AH\u0010\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\u0001\u0013aA8sO\u000e\u00011C\u0001\u0001$!\t!s%D\u0001&\u0015\u00051\u0013!B:dC2\f\u0017B\u0001\u0015&\u0005\u0019\te.\u001f*fM\u0006iQ.Z7pefl\u0015M\\1hKJ$\u0012a\u000b\t\u0003Y=j\u0011!\f\u0006\u0003]m\ta!\\3n_JL\u0018B\u0001\u0019.\u0005Mq\u0015\r^5wK6+Wn\u001c:z\u001b\u0006t\u0017mZ3s\u0003%9W\r\u001e%b]\u0012dW\rF\u00014!\t!C'\u0003\u00026K\t!Aj\u001c8h\u0003\u001d\u0011VO\u001c;j[\u0016\u0004\"\u0001\u000f\u0003\u000e\u0003e\u0019\"\u0001B\u0012\u0002\rqJg.\u001b;?)\u00059\u0014!B1qa2LHc\u0001 K/J\u0019q(\u0011\"\u0007\t\u0001#\u0001A\u0010\u0002\ryI,g-\u001b8f[\u0016tGO\u0010\t\u0003q\u0001\u0001\"a\u0011%\u000e\u0003\u0011S!!\u0012$\u0002\tQ\f7o\u001b\u0006\u0003\u000fv\tQa\u001d9be.L!!\u0013#\u0003\u0019Q\u000b7o\u001b*fg>,(oY3\t\u000b-3\u0001\u0019\u0001'\u0002\u0017\t\f7m[3oI:\u000bW.\u001a\t\u0003\u001bRs!A\u0014*\u0011\u0005=+S\"\u0001)\u000b\u0005E\u000b\u0013A\u0002\u001fs_>$h(\u0003\u0002TK\u00051\u0001K]3eK\u001aL!!\u0016,\u0003\rM#(/\u001b8h\u0015\t\u0019V\u0005C\u0003Y\r\u0001\u0007A*\u0001\u0003oC6,G\u0003\u0002.];z\u00132aW!C\r\u0011\u0001E\u0001\u0001.\t\u000b-;\u0001\u0019\u0001'\t\u000ba;\u0001\u0019\u0001'\t\u000b};\u0001\u0019\u00011\u0002\u0013\u0015DHO]1D_:4\u0007\u0003B1g\u00192k\u0011A\u0019\u0006\u0003G\u0012\fA!\u001e;jY*\tQ-\u0001\u0003kCZ\f\u0017BA4c\u0005\ri\u0015\r\u001d\u0002\f%VtG/[7f\u00136\u0004Hn\u0005\u0003\tG\u0005\u0013E\u0003B6n]>\u0004\"\u0001\u001c\u0005\u000e\u0003\u0011AQa\u0013\u0007A\u00021CQ\u0001\u0017\u0007A\u00021CQa\u0018\u0007A\u0002\u0001\f1A\\7n+\u0005Y\u0013\u0001\u00028n[\u0002\na\u0001[1oI2,W#A\u001a\u0002\u000f!\fg\u000e\u001a7fA\u0005A!/\u001a7fCN,G-F\u0001y!\tIh0D\u0001{\u0015\tYH0\u0001\u0004bi>l\u0017n\u0019\u0006\u0003{\n\f!bY8oGV\u0014(/\u001a8u\u0013\ty(PA\u0007Bi>l\u0017n\u0019\"p_2,\u0017M\\\u0001\ne\u0016dW-Y:fI\u0002\nqA]3mK\u0006\u001cX\r\u0006\u0002\u0002\bA\u0019A%!\u0003\n\u0007\u0005-QE\u0001\u0003V]&$\u0018\u0001\u00039sS>\u0014\u0018\u000e^=\u0015\u0005\u0005E\u0001c\u0001\u0013\u0002\u0014%\u0019\u0011QC\u0013\u0003\u0007%sG/\u0001\u0007sKN|WO]2f\u001d\u0006lW\rF\u0001M\u0001")
public interface Runtime {
    public NativeMemoryManager memoryManager();

    public long getHandle();

    private static class RuntimeImpl
    implements Runtime,
    TaskResource {
        private final NativeMemoryManager nmm;
        private final long handle;
        private final AtomicBoolean released;

        private NativeMemoryManager nmm() {
            return this.nmm;
        }

        private long handle() {
            return this.handle;
        }

        private AtomicBoolean released() {
            return this.released;
        }

        @Override
        public long getHandle() {
            return this.handle();
        }

        @Override
        public NativeMemoryManager memoryManager() {
            return this.nmm();
        }

        @Override
        public void release() {
            if (!this.released().compareAndSet(false, true)) {
                throw new GlutenException("Runtime instance already released: " + this.handle() + ", " + this.resourceName() + ", " + this.priority());
            }
            RuntimeJniWrapper.releaseRuntime(this.handle());
        }

        @Override
        public int priority() {
            return 30;
        }

        @Override
        public String resourceName() {
            return "runtime";
        }

        public RuntimeImpl(String backendName, String name, java.util.Map<String, String> extraConf) {
            TaskResource.$init$(this);
            this.nmm = NativeMemoryManager$.MODULE$.apply(backendName, name);
            this.handle = RuntimeJniWrapper.createRuntime(backendName, this.nmm().getHandle(), ConfigUtil.serialize((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)GlutenConfig$.MODULE$.getNativeSessionConf(backendName, GlutenConfigUtil$.MODULE$.parseConfig((scala.collection.immutable.Map<String, String>)SQLConf$.MODULE$.get().getAllConfs())).$plus$plus((IterableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter(extraConf).asScala())).asJava()));
            this.released = new AtomicBoolean(false);
        }
    }
}

