/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gluten.memory.memtarget.spark;

import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.gluten.config.GlutenCoreConfig;
import org.apache.gluten.memory.memtarget.Spillers;
import org.apache.gluten.memory.memtarget.TreeMemoryTarget;
import org.apache.gluten.memory.memtarget.spark.TreeMemoryConsumer;
import org.apache.gluten.shaded.com.google.common.base.Preconditions;
import org.apache.spark.memory.MemoryMode;
import org.apache.spark.memory.TaskMemoryManager;
import org.apache.spark.task.TaskResource;
import org.apache.spark.task.TaskResources;
import org.apache.spark.util.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;

public final class TreeMemoryConsumers {
    private TreeMemoryConsumers() {
    }

    public static Factory factory(final MemoryMode mode) {
        Factory factory = TaskResources.addResourceIfNotRegistered(Factory.class.getName(), new Function0<Factory>(){

            public Factory apply() {
                return new Factory(TaskResources.getLocalTaskContext().taskMemoryManager(), mode);
            }
        });
        MemoryMode foundMode = factory.sparkConsumer.getMode();
        Preconditions.checkState(foundMode == mode, "An existing Spark memory consumer already exists but is of the different memory mode: %s", (Object)foundMode);
        return factory;
    }

    public static class Factory
    implements TaskResource {
        private static final Logger LOG = LoggerFactory.getLogger(Factory.class);
        private final TreeMemoryConsumer sparkConsumer;
        private final Map<Long, TreeMemoryTarget> roots = new ConcurrentHashMap<Long, TreeMemoryTarget>();

        private Factory(TaskMemoryManager tmm, MemoryMode mode) {
            this.sparkConsumer = new TreeMemoryConsumer(tmm, mode);
        }

        private TreeMemoryTarget ofCapacity(long capacity) {
            return this.roots.computeIfAbsent(capacity, cap -> this.sparkConsumer.newChild(String.format("Capacity[%s]", Utils.bytesToString((long)cap)), (long)cap, Spillers.NOOP, Collections.emptyMap()));
        }

        public TreeMemoryTarget legacyRoot() {
            return this.ofCapacity(Long.MAX_VALUE);
        }

        public TreeMemoryTarget isolatedRoot() {
            return this.ofCapacity(GlutenCoreConfig.get().conservativeTaskOffHeapMemorySize());
        }

        @Override
        public void release() throws Exception {
            if (this.sparkConsumer.usedBytes() != 0L) {
                LOG.warn("{} still used {} bytes when task is ending, this may cause memory leak", (Object)this.resourceName(), (Object)this.sparkConsumer.usedBytes());
            }
        }

        @Override
        public int priority() {
            return 5;
        }

        @Override
        public String resourceName() {
            return Factory.class.getSimpleName();
        }
    }
}

