/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gluten.memory.memtarget.spark;

import java.util.Map;
import java.util.stream.Collectors;
import org.apache.gluten.memory.MemoryUsageRecorder;
import org.apache.gluten.memory.MemoryUsageStatsBuilder;
import org.apache.gluten.memory.SimpleMemoryUsageRecorder;
import org.apache.gluten.memory.memtarget.KnownNameAndStats;
import org.apache.gluten.memory.memtarget.MemoryTarget;
import org.apache.gluten.memory.memtarget.MemoryTargetUtil;
import org.apache.gluten.memory.memtarget.MemoryTargetVisitor;
import org.apache.gluten.memory.memtarget.Spiller;
import org.apache.gluten.proto.MemoryUsageStats;
import org.apache.gluten.shaded.com.google.common.base.Preconditions;
import org.apache.spark.memory.MemoryConsumer;
import org.apache.spark.memory.MemoryMode;
import org.apache.spark.memory.TaskMemoryManager;
import org.apache.spark.task.TaskResources;

@Deprecated
public class RegularMemoryConsumer
extends MemoryConsumer
implements MemoryTarget,
KnownNameAndStats {
    private final TaskMemoryManager taskMemoryManager;
    private final Spiller spiller;
    private final String name;
    private final Map<String, MemoryUsageStatsBuilder> virtualChildren;
    private final MemoryUsageRecorder selfRecorder = new SimpleMemoryUsageRecorder();

    public RegularMemoryConsumer(TaskMemoryManager taskMemoryManager, String name, Spiller spiller, Map<String, MemoryUsageStatsBuilder> virtualChildren) {
        super(taskMemoryManager, taskMemoryManager.pageSizeBytes(), MemoryMode.OFF_HEAP);
        this.taskMemoryManager = taskMemoryManager;
        this.spiller = spiller;
        this.name = MemoryTargetUtil.toUniqueName("Gluten.Regular." + name);
        this.virtualChildren = virtualChildren;
    }

    public long spill(long size, MemoryConsumer trigger) {
        long remainingBytes = size;
        for (Spiller.Phase phase : Spiller.Phase.values()) {
            if (remainingBytes <= 0L) break;
            remainingBytes -= this.spiller.spill(this, phase, size);
        }
        long spilledOut = size - remainingBytes;
        if (TaskResources.inSparkTask()) {
            TaskResources.getLocalTaskContext().taskMetrics().incMemoryBytesSpilled(spilledOut);
        }
        return spilledOut;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public long usedBytes() {
        return this.getUsed();
    }

    @Override
    public <T> T accept(MemoryTargetVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    public MemoryUsageStats stats() {
        MemoryUsageStats stats = this.selfRecorder.toStats();
        Preconditions.checkState(stats.getCurrent() == this.getUsed(), "Used bytes mismatch between gluten memory consumer and Spark task memory manager");
        return MemoryUsageStats.newBuilder().setCurrent(stats.getCurrent()).setPeak(stats.getPeak()).putAllChildren(this.virtualChildren.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((MemoryUsageStatsBuilder)e.getValue()).toStats()))).build();
    }

    @Override
    public long borrow(long size) {
        if (size == 0L) {
            return 0L;
        }
        long acquired = this.acquireMemory(size);
        this.selfRecorder.inc(acquired);
        return acquired;
    }

    @Override
    public long repay(long size) {
        if (size == 0L) {
            return 0L;
        }
        long toFree = Math.min(this.getUsed(), size);
        this.freeMemory(toFree);
        Preconditions.checkArgument(this.getUsed() >= 0L);
        this.selfRecorder.inc(-toFree);
        return toFree;
    }

    public String toString() {
        return this.name();
    }

    public TaskMemoryManager getTaskMemoryManager() {
        return this.taskMemoryManager;
    }
}

