/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gluten.memory.memtarget;

import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import org.apache.gluten.config.GlutenCoreConfig;
import org.apache.gluten.memory.memtarget.MemoryTarget;
import org.apache.gluten.memory.memtarget.MemoryTargetVisitor;
import org.apache.spark.memory.SparkMemoryUtil;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.task.TaskResources;
import org.apache.spark.util.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThrowOnOomMemoryTarget
implements MemoryTarget {
    private static final Logger LOG = LoggerFactory.getLogger(ThrowOnOomMemoryTarget.class);
    private static final int MAX_SLEEPS = 9;
    private static final int MAX_WAIT_MS = 1000;
    private static final List<String> PRINTED_NON_BYTES_CONFIGURATIONS = Arrays.asList(GlutenCoreConfig.SPARK_OFFHEAP_ENABLED_KEY(), GlutenCoreConfig.DYNAMIC_OFFHEAP_SIZING_ENABLED().key());
    private static final List<String> PRINTED_BYTES_CONFIGURATIONS = Arrays.asList(GlutenCoreConfig.COLUMNAR_OFFHEAP_SIZE_IN_BYTES().key(), GlutenCoreConfig.COLUMNAR_TASK_OFFHEAP_SIZE_IN_BYTES().key(), GlutenCoreConfig.COLUMNAR_CONSERVATIVE_TASK_OFFHEAP_SIZE_IN_BYTES().key());
    private final MemoryTarget target;

    public ThrowOnOomMemoryTarget(MemoryTarget target) {
        this.target = target;
    }

    @Override
    public long borrow(long size) {
        long granted = this.target.borrow(size);
        if (granted >= size) {
            return granted;
        }
        if (granted != 0L) {
            this.target.repay(granted);
        }
        LOG.warn("Off-heap reservation of {} bytes failed.", (Object)size);
        LOG.warn("Invoking GC to try reclaiming some off-heap memory space if applicable...");
        System.gc();
        long start = System.currentTimeMillis();
        int sleeps = 0;
        long sleepTime = 1L;
        while (true) {
            long elapsedMs;
            if ((elapsedMs = System.currentTimeMillis() - start) >= 1000L) {
                LOG.warn("Max wait time (in ms) {} has reached. ", (Object)1000);
                break;
            }
            LOG.warn("Retrying reserving {} bytes (finished {}/{} number of sleeps, elapsed {}/{} ms)... ", new Object[]{size, sleeps, 9, elapsedMs, 1000});
            granted = this.target.borrow(size);
            if (granted >= size) {
                return granted;
            }
            if (granted != 0L) {
                this.target.repay(granted);
            }
            if (sleeps >= 9) {
                LOG.warn("Max number of sleeps {} has reached. ", (Object)9);
                break;
            }
            try {
                Thread.sleep(sleepTime);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                break;
            }
            sleepTime *= 2L;
            ++sleeps;
        }
        if (TaskResources.inSparkTask()) {
            TaskResources.getLocalTaskContext().taskMemoryManager().showMemoryUsage();
        }
        StringBuilder errorBuilder = new StringBuilder();
        errorBuilder.append(String.format("Not enough spark off-heap execution memory. Acquired: %s, granted: %s. Try tweaking config option spark.memory.offHeap.size to get larger space to run this application (if spark.gluten.memory.dynamic.offHeap.sizing.enabled is not enabled). %n", Utils.bytesToString((long)size), Utils.bytesToString((long)granted))).append("Current config settings: ").append(System.lineSeparator());
        for (String confKey : PRINTED_NON_BYTES_CONFIGURATIONS) {
            errorBuilder.append(String.format("\t%s=%s", confKey, ThrowOnOomMemoryTarget.getSqlConfStringOrNa(confKey, v -> v))).append(System.lineSeparator());
        }
        for (String confKey : PRINTED_BYTES_CONFIGURATIONS) {
            errorBuilder.append(String.format("\t%s=%s", confKey, ThrowOnOomMemoryTarget.getSqlConfStringOrNa(confKey, ThrowOnOomMemoryTarget::reformatBytes))).append(System.lineSeparator());
        }
        errorBuilder.append(SparkMemoryUtil.dumpMemoryTargetStats(this.target));
        errorBuilder.append(System.lineSeparator());
        throw new OutOfMemoryException(errorBuilder.toString());
    }

    private static String getSqlConfStringOrNa(String confKey, Function<String, String> ifPresent) {
        SQLConf sqlConf = SQLConf.get();
        if (!sqlConf.contains(confKey)) {
            return "N/A";
        }
        return ifPresent.apply(sqlConf.getConfString(confKey));
    }

    private static String reformatBytes(String in) {
        return Utils.bytesToString((long)Utils.byteStringAsBytes((String)in));
    }

    @Override
    public long repay(long size) {
        return this.target.repay(size);
    }

    @Override
    public long usedBytes() {
        return this.target.usedBytes();
    }

    @Override
    public <T> T accept(MemoryTargetVisitor<T> visitor) {
        return visitor.visit(this);
    }

    public MemoryTarget target() {
        return this.target;
    }

    public static class OutOfMemoryException
    extends RuntimeException {
        public OutOfMemoryException(String message) {
            super(message);
        }
    }
}

