/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gluten.memory.memtarget;

import org.apache.gluten.memory.memtarget.MemoryTarget;
import org.apache.gluten.memory.memtarget.MemoryTargetVisitor;
import org.apache.gluten.shaded.com.google.common.base.Preconditions;

public class OverAcquire
implements MemoryTarget {
    private final MemoryTarget target;
    private final MemoryTarget overTarget;
    private final double ratio;

    OverAcquire(MemoryTarget target, MemoryTarget overTarget, double ratio) {
        Preconditions.checkArgument(ratio >= 0.0);
        this.overTarget = overTarget;
        this.target = target;
        this.ratio = ratio;
    }

    @Override
    public long borrow(long size) {
        if (size == 0L) {
            return 0L;
        }
        Preconditions.checkState(this.overTarget.usedBytes() == 0L);
        long granted = this.target.borrow(size);
        if (granted >= size) {
            long majorSize = this.target.usedBytes();
            long overSize = (long)(this.ratio * (double)majorSize);
            long overAcquired = this.overTarget.borrow(overSize);
            Preconditions.checkState(overAcquired == this.overTarget.usedBytes());
            long releasedOverSize = this.overTarget.repay(overAcquired);
            Preconditions.checkState(releasedOverSize == overAcquired);
            Preconditions.checkState(this.overTarget.usedBytes() == 0L);
        }
        return granted;
    }

    @Override
    public long repay(long size) {
        if (size == 0L) {
            return 0L;
        }
        return this.target.repay(size);
    }

    @Override
    public long usedBytes() {
        return this.target.usedBytes() + this.overTarget.usedBytes();
    }

    @Override
    public <T> T accept(MemoryTargetVisitor<T> visitor) {
        return visitor.visit(this);
    }

    public MemoryTarget getTarget() {
        return this.target;
    }
}

