/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gluten.memory.memtarget;

import java.util.Map;
import org.apache.gluten.config.GlutenCoreConfig;
import org.apache.gluten.memory.MemoryUsageStatsBuilder;
import org.apache.gluten.memory.memtarget.DynamicOffHeapSizingMemoryTarget;
import org.apache.gluten.memory.memtarget.MemoryTarget;
import org.apache.gluten.memory.memtarget.OverAcquire;
import org.apache.gluten.memory.memtarget.RetryOnOomMemoryTarget;
import org.apache.gluten.memory.memtarget.Spiller;
import org.apache.gluten.memory.memtarget.ThrowOnOomMemoryTarget;
import org.apache.gluten.memory.memtarget.TreeMemoryTarget;
import org.apache.gluten.memory.memtarget.TreeMemoryTargets;
import org.apache.gluten.memory.memtarget.spark.TreeMemoryConsumers;
import org.apache.spark.SparkEnv;
import org.apache.spark.annotation.Experimental;
import org.apache.spark.memory.GlobalOffHeapMemoryTarget;
import org.apache.spark.memory.MemoryMode;
import org.apache.spark.util.SparkResourceUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MemoryTargets {
    private static final Logger LOGGER = LoggerFactory.getLogger(MemoryTargets.class);

    private MemoryTargets() {
    }

    public static MemoryTarget global() {
        return new GlobalOffHeapMemoryTarget();
    }

    public static MemoryTarget throwOnOom(MemoryTarget target) {
        return new ThrowOnOomMemoryTarget(target);
    }

    public static MemoryTarget overAcquire(MemoryTarget target, MemoryTarget overTarget, double overAcquiredRatio) {
        if (overAcquiredRatio == 0.0) {
            return target;
        }
        return new OverAcquire(target, overTarget, overAcquiredRatio);
    }

    @Experimental
    public static MemoryTarget dynamicOffHeapSizingIfEnabled(MemoryTarget memoryTarget) {
        if (GlutenCoreConfig.get().dynamicOffHeapSizingEnabled()) {
            return new DynamicOffHeapSizingMemoryTarget(memoryTarget);
        }
        return memoryTarget;
    }

    public static TreeMemoryTarget newConsumer(String name, Spiller spiller, Map<String, MemoryUsageStatsBuilder> virtualChildren) {
        MemoryMode mode = GlutenCoreConfig.get().dynamicOffHeapSizingEnabled() ? MemoryMode.ON_HEAP : MemoryMode.OFF_HEAP;
        TreeMemoryConsumers.Factory factory = TreeMemoryConsumers.factory(mode);
        if (GlutenCoreConfig.get().memoryIsolation()) {
            return TreeMemoryTargets.newChild(factory.isolatedRoot(), name, spiller, virtualChildren);
        }
        TreeMemoryTarget root = factory.legacyRoot();
        TreeMemoryTarget consumer = TreeMemoryTargets.newChild(root, name, spiller, virtualChildren);
        if (SparkEnv.get() == null) {
            LOGGER.info("SparkEnv not found. We are likely in test code.");
            return consumer;
        }
        int taskSlots = SparkResourceUtil.getTaskSlots(SparkEnv.get().conf());
        if (taskSlots == 1) {
            return consumer;
        }
        return new RetryOnOomMemoryTarget(consumer, () -> {
            LOGGER.info("Request for spilling on consumer {}...", (Object)consumer.name());
            long spilled = TreeMemoryTargets.spillTree(root, Long.MAX_VALUE);
            LOGGER.info("Consumer {} gets {} bytes from spilling.", (Object)consumer.name(), (Object)spilled);
        });
    }
}

