/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gluten.memory.memtarget;

import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import javax.management.MBeanServer;
import org.apache.gluten.memory.SimpleMemoryUsageRecorder;
import org.apache.gluten.memory.memtarget.KnownNameAndStats;
import org.apache.gluten.memory.memtarget.MemoryTarget;
import org.apache.gluten.memory.memtarget.MemoryTargetUtil;
import org.apache.gluten.memory.memtarget.MemoryTargetVisitor;
import org.apache.gluten.proto.MemoryUsageStats;
import org.apache.spark.annotation.Experimental;
import org.apache.spark.util.SparkThreadPoolUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Experimental
public class DynamicOffHeapSizingMemoryTarget
implements MemoryTarget,
KnownNameAndStats {
    private static final Logger LOG = LoggerFactory.getLogger(DynamicOffHeapSizingMemoryTarget.class);
    private static final long TOTAL_MEMORY_SHARED;
    private static final double ASYNC_GC_MAX_TOTAL_MEMORY_USAGE_RATIO = 0.85;
    private static final double ASYNC_GC_MAX_ON_HEAP_MEMORY_RATIO = 0.65;
    private static final double GC_MAX_HEAP_FREE_RATIO = 0.05;
    private static final int MAX_GC_RETRY_TIMES = 3;
    private static final AtomicBoolean ASYNC_GC_SUSPEND;
    private static final Object JVM_SHRINK_SYNC_OBJECT;
    private static final int ORIGINAL_MAX_HEAP_FREE_RATIO;
    private static final int ORIGINAL_MIN_HEAP_FREE_RATIO;
    private static final AtomicLong USED_OFF_HEAP_BYTES;
    private static final AtomicLong TOTAL_EXPLICIT_GC_COUNT;
    private final String name = MemoryTargetUtil.toUniqueName("DynamicOffHeapSizing");
    private final SimpleMemoryUsageRecorder recorder = new SimpleMemoryUsageRecorder();
    private final MemoryTarget target;

    public DynamicOffHeapSizingMemoryTarget(MemoryTarget target) {
        this.target = target;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long borrow(final long size) {
        if (size == 0L) {
            return 0L;
        }
        long totalHeapMemory = Runtime.getRuntime().totalMemory();
        long freeHeapMemory = Runtime.getRuntime().freeMemory();
        final long usedOffHeapMemory = USED_OFF_HEAP_BYTES.get();
        if (DynamicOffHeapSizingMemoryTarget.exceedsMaxMemoryUsage(totalHeapMemory, usedOffHeapMemory, size, 1.0)) {
            Object object = JVM_SHRINK_SYNC_OBJECT;
            synchronized (object) {
                totalHeapMemory = Runtime.getRuntime().totalMemory();
                freeHeapMemory = Runtime.getRuntime().freeMemory();
                if (DynamicOffHeapSizingMemoryTarget.exceedsMaxMemoryUsage(totalHeapMemory, usedOffHeapMemory, size, 1.0)) {
                    DynamicOffHeapSizingMemoryTarget.shrinkOnHeapMemory(totalHeapMemory, freeHeapMemory, false);
                    totalHeapMemory = Runtime.getRuntime().totalMemory();
                    freeHeapMemory = Runtime.getRuntime().freeMemory();
                }
            }
            if (DynamicOffHeapSizingMemoryTarget.exceedsMaxMemoryUsage(totalHeapMemory, usedOffHeapMemory, size, 1.0)) {
                LOG.warn(String.format("Failing allocation as unified memory is OOM. Used Off-heap: %d, Used On-Heap: %d, Free On-heap: %d, Total On-heap: %d, Max On-heap: %d, Allocation: %d.", usedOffHeapMemory, totalHeapMemory - freeHeapMemory, freeHeapMemory, totalHeapMemory, TOTAL_MEMORY_SHARED, size));
                return 0L;
            }
        } else if (DynamicOffHeapSizingMemoryTarget.shouldTriggerAsyncOnHeapMemoryShrink(totalHeapMemory, freeHeapMemory, usedOffHeapMemory, size)) {
            SparkThreadPoolUtil.triggerGCInThreadPool(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Object object = JVM_SHRINK_SYNC_OBJECT;
                    synchronized (object) {
                        long totalJvmMem = Runtime.getRuntime().totalMemory();
                        long freeJvmMem = Runtime.getRuntime().freeMemory();
                        if (DynamicOffHeapSizingMemoryTarget.shouldTriggerAsyncOnHeapMemoryShrink(totalJvmMem, freeJvmMem, usedOffHeapMemory, size)) {
                            DynamicOffHeapSizingMemoryTarget.shrinkOnHeapMemory(totalJvmMem, freeJvmMem, true);
                        }
                    }
                }
            });
        }
        USED_OFF_HEAP_BYTES.addAndGet(size);
        this.recorder.inc(size);
        this.target.borrow(size);
        return size;
    }

    @Override
    public long repay(long size) {
        USED_OFF_HEAP_BYTES.addAndGet(-size);
        this.recorder.inc(-size);
        this.target.repay(size);
        return size;
    }

    @Override
    public long usedBytes() {
        return this.recorder.current();
    }

    @Override
    public <T> T accept(MemoryTargetVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public MemoryUsageStats stats() {
        return this.recorder.toStats();
    }

    public MemoryTarget target() {
        return this.target;
    }

    public static boolean isJava9OrLater() {
        String spec = System.getProperty("java.specification.version", "1.8");
        if (spec.startsWith("1.")) {
            spec = spec.substring(2);
        }
        try {
            return Integer.parseInt(spec) >= 9;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public static boolean canShrinkJVMMemory(long totalMemory, long freeMemory) {
        return (double)freeMemory > (double)totalMemory * 0.05;
    }

    public static long getTotalExplicitGCCount() {
        return TOTAL_EXPLICIT_GC_COUNT.get();
    }

    private static boolean exceedsMaxMemoryUsage(long totalOnHeapMemory, long totalOffHeapMemory, long requestedSize, double ratio) {
        return (double)(requestedSize + totalOffHeapMemory + totalOnHeapMemory) >= (double)TOTAL_MEMORY_SHARED * ratio;
    }

    private static boolean shouldTriggerAsyncOnHeapMemoryShrink(long totalOnHeapMemory, long freeOnHeapMemory, long totalOffHeapMemory, long requestedSize) {
        boolean exceedsMaxMemoryUsageRatio = DynamicOffHeapSizingMemoryTarget.exceedsMaxMemoryUsage(totalOnHeapMemory, totalOffHeapMemory, requestedSize, 0.85);
        return exceedsMaxMemoryUsageRatio && DynamicOffHeapSizingMemoryTarget.canShrinkJVMMemory(totalOnHeapMemory, freeOnHeapMemory) && (double)totalOnHeapMemory > (double)TOTAL_MEMORY_SHARED * 0.65 && (!ASYNC_GC_SUSPEND.get() || (double)freeOnHeapMemory > (double)totalOnHeapMemory * ((double)ORIGINAL_MIN_HEAP_FREE_RATIO / 100.0));
    }

    private static long shrinkOnHeapMemoryInternal(long totalMemory, long freeMemory, boolean isAsyncGc) {
        int gcRetryTimes;
        long totalOffHeapMemory = USED_OFF_HEAP_BYTES.get();
        LOG.warn(String.format("Starting %sfull gc to shrink JVM memory: Total On-heap: %d, Free On-heap: %d, Total Off-heap: %d, Used On-Heap: %d, Executor memory: %d.", isAsyncGc ? "async " : "", totalMemory, freeMemory, totalOffHeapMemory, totalMemory - freeMemory, TOTAL_MEMORY_SHARED));
        System.gc();
        long newTotalMemory = Runtime.getRuntime().totalMemory();
        long newFreeMemory = Runtime.getRuntime().freeMemory();
        for (gcRetryTimes = 0; !isAsyncGc && gcRetryTimes < 3 && newTotalMemory >= totalMemory && DynamicOffHeapSizingMemoryTarget.canShrinkJVMMemory(newTotalMemory, newFreeMemory); ++gcRetryTimes) {
            System.gc();
            newTotalMemory = Runtime.getRuntime().totalMemory();
            newFreeMemory = Runtime.getRuntime().freeMemory();
        }
        if (isAsyncGc) {
            ASYNC_GC_SUSPEND.set((double)(totalMemory - newTotalMemory) < (double)totalMemory * ((double)ORIGINAL_MIN_HEAP_FREE_RATIO / 100.0));
        }
        TOTAL_EXPLICIT_GC_COUNT.getAndAdd(1L);
        LOG.warn(String.format("Finished %sfull gc to shrink JVM memory: Total On-heap: %d, Free On-heap: %d, Total Off-heap: %d, Used On-Heap: %d, Executor memory: %d, [GC Retry times: %d].", isAsyncGc ? "async " : "", newTotalMemory, newFreeMemory, totalOffHeapMemory, newTotalMemory - newFreeMemory, TOTAL_MEMORY_SHARED, gcRetryTimes));
        return newTotalMemory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static long shrinkOnHeapMemory(long totalMemory, long freeMemory, boolean isAsyncGc) {
        long l;
        String maxHeapFreeRatioName;
        Object hotSpotBean;
        boolean updateMaxHeapFreeRatio;
        block13: {
            updateMaxHeapFreeRatio = false;
            hotSpotBean = null;
            maxHeapFreeRatioName = "MaxHeapFreeRatio";
            String minHeapFreeRatioName = "MinHeapFreeRatio";
            int newValue = 5;
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            Class<?> beanClass = Class.forName("com.sun.management.HotSpotDiagnosticMXBean");
            hotSpotBean = ManagementFactory.newPlatformMXBeanProxy(mbs, "com.sun.management:type=HotSpotDiagnostic", beanClass);
            Method setOption = beanClass.getMethod("setVMOption", String.class, String.class);
            if (newValue < ORIGINAL_MIN_HEAP_FREE_RATIO) {
                setOption.invoke(hotSpotBean, minHeapFreeRatioName, Integer.toString(newValue));
            }
            if (newValue < ORIGINAL_MAX_HEAP_FREE_RATIO) {
                setOption.invoke(hotSpotBean, maxHeapFreeRatioName, Integer.toString(newValue));
                updateMaxHeapFreeRatio = true;
                LOG.info(String.format("Updated VM flags: MaxHeapFreeRatio from %d to %d.", ORIGINAL_MAX_HEAP_FREE_RATIO, newValue));
            }
            l = DynamicOffHeapSizingMemoryTarget.shrinkOnHeapMemoryInternal(totalMemory, freeMemory, isAsyncGc);
            if (hotSpotBean == null || !updateMaxHeapFreeRatio) break block13;
            try {
                Class<?> beanClass2 = Class.forName("com.sun.management.HotSpotDiagnosticMXBean");
                Method setOption2 = beanClass2.getMethod("setVMOption", String.class, String.class);
                setOption2.invoke(hotSpotBean, maxHeapFreeRatioName, Integer.toString(ORIGINAL_MAX_HEAP_FREE_RATIO));
                LOG.info("Reverted VM flags back.");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return l;
        catch (Exception e) {
            long l2;
            block14: {
                try {
                    LOG.warn("Failed to update JVM heap free ratio via HotSpotDiagnosticMXBean: {}", (Object)e.toString());
                    l2 = totalMemory;
                    if (hotSpotBean == null || !updateMaxHeapFreeRatio) break block14;
                }
                catch (Throwable throwable) {
                    if (hotSpotBean != null && updateMaxHeapFreeRatio) {
                        try {
                            Class<?> beanClass2 = Class.forName("com.sun.management.HotSpotDiagnosticMXBean");
                            Method setOption2 = beanClass2.getMethod("setVMOption", String.class, String.class);
                            setOption2.invoke(hotSpotBean, maxHeapFreeRatioName, Integer.toString(ORIGINAL_MAX_HEAP_FREE_RATIO));
                            LOG.info("Reverted VM flags back.");
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    throw throwable;
                }
                try {
                    Class<?> beanClass3 = Class.forName("com.sun.management.HotSpotDiagnosticMXBean");
                    Method setOption3 = beanClass3.getMethod("setVMOption", String.class, String.class);
                    setOption3.invoke(hotSpotBean, maxHeapFreeRatioName, Integer.toString(ORIGINAL_MAX_HEAP_FREE_RATIO));
                    LOG.info("Reverted VM flags back.");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return l2;
        }
    }

    static {
        ASYNC_GC_SUSPEND = new AtomicBoolean(false);
        JVM_SHRINK_SYNC_OBJECT = new Object();
        RuntimeMXBean runtimeMxBean = ManagementFactory.getRuntimeMXBean();
        List<String> jvmArgs = runtimeMxBean.getInputArguments();
        int originalMaxHeapFreeRatio = 70;
        int originalMinHeapFreeRatio = 40;
        for (String arg : jvmArgs) {
            String valuePart;
            if (arg.startsWith("-XX:MaxHeapFreeRatio=")) {
                valuePart = arg.substring(arg.indexOf(61) + 1);
                try {
                    originalMaxHeapFreeRatio = Integer.parseInt(valuePart);
                }
                catch (NumberFormatException e) {
                    LOG.warn("Failed to parse MaxHeapFreeRatio from JVM argument: {}. Using default value: {}.", (Object)arg, (Object)originalMaxHeapFreeRatio);
                }
                continue;
            }
            if (arg.startsWith("-XX:MinHeapFreeRatio=")) {
                valuePart = arg.substring(arg.indexOf(61) + 1);
                try {
                    originalMinHeapFreeRatio = Integer.parseInt(valuePart);
                }
                catch (NumberFormatException e) {
                    LOG.warn("Failed to parse MinHeapFreeRatio from JVM argument: {}. Using default value: {}.", (Object)arg, (Object)originalMinHeapFreeRatio);
                }
                continue;
            }
            if (Objects.equals(arg, "-XX:+ExplicitGCInvokesConcurrent")) {
                LOG.error("Explicit JVM shrinking is not effective because -XX:+ExplicitGCInvokesConcurrent is set. Please check the JVM arguments: {}. ", (Object)arg);
                continue;
            }
            if (!Objects.equals(arg, "-XX:+DisableExplicitGC")) continue;
            LOG.error("Explicit JVM shrinking is disabled because -XX:+DisableExplicitGC is set. System.gc() calls will be ignored and JVM shrinking will not work. Please check the JVM arguments: {}. ", (Object)arg);
        }
        ORIGINAL_MIN_HEAP_FREE_RATIO = originalMinHeapFreeRatio;
        ORIGINAL_MAX_HEAP_FREE_RATIO = originalMaxHeapFreeRatio;
        if (!DynamicOffHeapSizingMemoryTarget.isJava9OrLater()) {
            LOG.error("Dynamic off-heap sizing is not supported before JDK 9.");
        }
        TOTAL_MEMORY_SHARED = Runtime.getRuntime().maxMemory();
        LOG.info("Initialized DynamicOffHeapSizingMemoryTarget with MAX_MEMORY_IN_BYTES = {}, ASYNC_GC_MAX_TOTAL_MEMORY_USAGE_RATIO = {}, ASYNC_GC_MAX_ON_HEAP_MEMORY_RATIO = {}, GC_MAX_HEAP_FREE_RATIO = {}.", new Object[]{TOTAL_MEMORY_SHARED, 0.85, 0.65, 0.05});
        USED_OFF_HEAP_BYTES = new AtomicLong();
        TOTAL_EXPLICIT_GC_COUNT = new AtomicLong(0L);
    }
}

