/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gluten.memory.listener;

import java.util.Collections;
import java.util.Map;
import org.apache.gluten.config.GlutenConfig;
import org.apache.gluten.memory.MemoryUsageStatsBuilder;
import org.apache.gluten.memory.SimpleMemoryUsageRecorder;
import org.apache.gluten.memory.listener.ManagedReservationListener;
import org.apache.gluten.memory.listener.ReservationListener;
import org.apache.gluten.memory.memtarget.MemoryTarget;
import org.apache.gluten.memory.memtarget.MemoryTargets;
import org.apache.gluten.memory.memtarget.NoopMemoryTarget;
import org.apache.gluten.memory.memtarget.Spiller;
import org.apache.gluten.memory.memtarget.Spillers;
import org.apache.gluten.memory.memtarget.TreeMemoryTarget;
import org.apache.spark.memory.TaskMemoryManager;
import org.apache.spark.task.TaskResources;

public final class ReservationListeners {
    public static ReservationListener create(String name, Spiller spiller, Map<String, MemoryUsageStatsBuilder> mutableStats) {
        if (!TaskResources.inSparkTask()) {
            throw new IllegalStateException("Spillable reservation listener must be used in a Spark task.");
        }
        return ReservationListeners.create0(name, spiller, mutableStats);
    }

    private static ReservationListener create0(String name, Spiller spiller, Map<String, MemoryUsageStatsBuilder> mutableStats) {
        if (GlutenConfig.get().memoryUntracked()) {
            return ReservationListeners.noop();
        }
        double overAcquiredRatio = GlutenConfig.get().memoryOverAcquiredRatio();
        long reservationBlockSize = GlutenConfig.get().memoryReservationBlockSize();
        TaskMemoryManager tmm = TaskResources.getLocalTaskContext().taskMemoryManager();
        TreeMemoryTarget consumer = MemoryTargets.newConsumer(name, Spillers.withMinSpillSize(spiller, reservationBlockSize), mutableStats);
        TreeMemoryTarget overConsumer = MemoryTargets.newConsumer(consumer.name() + ".OverAcquire", Spillers.NOOP, Collections.emptyMap());
        MemoryTarget target = MemoryTargets.throwOnOom(MemoryTargets.overAcquire(MemoryTargets.dynamicOffHeapSizingIfEnabled(consumer), MemoryTargets.dynamicOffHeapSizingIfEnabled(overConsumer), overAcquiredRatio));
        return new ManagedReservationListener(target, TaskResources.getSharedUsage(), tmm);
    }

    private static ManagedReservationListener noop() {
        return new ManagedReservationListener(new NoopMemoryTarget(), new SimpleMemoryUsageRecorder(), new Object());
    }
}

