/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gluten.memory.listener;

import org.apache.gluten.memory.SimpleMemoryUsageRecorder;
import org.apache.gluten.memory.listener.ReservationListener;
import org.apache.gluten.memory.memtarget.MemoryTarget;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManagedReservationListener
implements ReservationListener {
    private static final Logger LOG = LoggerFactory.getLogger(ManagedReservationListener.class);
    private final MemoryTarget target;
    private final SimpleMemoryUsageRecorder sharedUsage;
    private final Object sharedLock;

    public ManagedReservationListener(MemoryTarget target, SimpleMemoryUsageRecorder sharedUsage, Object sharedLock) {
        this.target = target;
        this.sharedUsage = sharedUsage;
        this.sharedLock = sharedLock;
    }

    @Override
    public long reserve(long size) {
        Object object = this.sharedLock;
        synchronized (object) {
            try {
                long granted = this.target.borrow(size);
                this.sharedUsage.inc(granted);
                return granted;
            }
            catch (Exception e) {
                LOG.warn("Error reserving memory from target", (Throwable)e);
                throw e;
            }
        }
    }

    @Override
    public long unreserve(long size) {
        Object object = this.sharedLock;
        synchronized (object) {
            try {
                long freed = this.target.repay(size);
                this.sharedUsage.inc(-freed);
                return freed;
            }
            catch (Exception e) {
                LOG.warn("Error unreserving memory from target", (Throwable)e);
                throw e;
            }
        }
    }

    @Override
    public long getUsedBytes() {
        return this.target.usedBytes();
    }
}

