/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gluten.memory.arrow.pool;

import org.apache.arrow.dataset.jni.NativeMemoryPool;
import org.apache.gluten.memory.arrow.pool.ArrowReservationListener;
import org.apache.spark.task.TaskResource;
import org.apache.spark.task.TaskResources;
import org.apache.spark.util.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArrowNativeMemoryPool
implements TaskResource {
    private static final Logger LOGGER = LoggerFactory.getLogger(ArrowNativeMemoryPool.class);
    private final NativeMemoryPool arrowPool;
    private final ArrowReservationListener listener = new ArrowReservationListener(TaskResources.getSharedUsage());

    public ArrowNativeMemoryPool() {
        this.arrowPool = NativeMemoryPool.createListenable(this.listener);
    }

    public static NativeMemoryPool arrowPool(String name) {
        if (!TaskResources.inSparkTask()) {
            throw new IllegalStateException("This method must be called in a Spark task.");
        }
        String id = "ArrowNativeMemoryPool:" + name;
        return ((ArrowNativeMemoryPool)TaskResources.addResourceIfNotRegistered(id, () -> ArrowNativeMemoryPool.createArrowNativeMemoryPool(name))).getArrowPool();
    }

    private static ArrowNativeMemoryPool createArrowNativeMemoryPool(String name) {
        return new ArrowNativeMemoryPool();
    }

    @Override
    public void release() throws Exception {
        if (this.arrowPool.getBytesAllocated() != 0L) {
            LOGGER.warn(String.format("Arrow pool still reserved non-zero bytes, which may cause memory leak, size: %s. ", Utils.bytesToString((long)this.arrowPool.getBytesAllocated())));
        }
        this.arrowPool.close();
    }

    @Override
    public int priority() {
        return 10;
    }

    @Override
    public String resourceName() {
        return "arrow_mem";
    }

    public NativeMemoryPool getArrowPool() {
        return this.arrowPool;
    }
}

