/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gluten.memory.arrow.alloc;

import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.gluten.config.GlutenConfig;
import org.apache.gluten.memory.SimpleMemoryUsageRecorder;
import org.apache.gluten.memory.memtarget.MemoryTarget;
import org.apache.gluten.shaded.org.apache.arrow.memory.AllocationListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManagedAllocationListener
implements AllocationListener,
AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(ManagedAllocationListener.class);
    public static long BLOCK_SIZE = GlutenConfig.get().memoryReservationBlockSize();
    private final MemoryTarget target;
    private final SimpleMemoryUsageRecorder sharedUsage;
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private long bytesReserved = 0L;
    private long blocksReserved = 0L;

    public ManagedAllocationListener(MemoryTarget target, SimpleMemoryUsageRecorder sharedUsage) {
        this.target = target;
        this.sharedUsage = sharedUsage;
    }

    @Override
    public void onPreAllocation(long size) {
        if (this.closed.get()) {
            LOG.warn("ManagedAllocationListener: already closed");
            return;
        }
        long requiredBlocks = this.updateReservation(size);
        if (requiredBlocks < 0L) {
            throw new IllegalStateException();
        }
        if (requiredBlocks == 0L) {
            return;
        }
        long toBeAcquired = requiredBlocks * BLOCK_SIZE;
        long granted = this.target.borrow(toBeAcquired);
        this.sharedUsage.inc(granted);
    }

    @Override
    public void onRelease(long size) {
        if (this.closed.get()) {
            LOG.warn("ManagedAllocationListener: already closed");
            return;
        }
        long requiredBlocks = this.updateReservation(-size);
        if (requiredBlocks > 0L) {
            throw new IllegalStateException();
        }
        if (requiredBlocks == 0L) {
            return;
        }
        long toBeReleased = -requiredBlocks * BLOCK_SIZE;
        long freed = this.target.repay(toBeReleased);
        this.sharedUsage.inc(-freed);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long updateReservation(long bytesToAdd) {
        ManagedAllocationListener managedAllocationListener = this;
        synchronized (managedAllocationListener) {
            long newBytesReserved = this.bytesReserved + bytesToAdd;
            long newBlocksReserved = newBytesReserved == 0L ? 0L : (newBytesReserved - 1L) / BLOCK_SIZE + 1L;
            long requiredBlocks = newBlocksReserved - this.blocksReserved;
            this.bytesReserved = newBytesReserved;
            this.blocksReserved = newBlocksReserved;
            return requiredBlocks;
        }
    }

    @Override
    public void close() throws Exception {
        this.closed.set(true);
    }
}

