/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gluten.memory.arrow.alloc;

import java.lang.invoke.LambdaMetafactory;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import org.apache.gluten.config.GlutenConfig;
import org.apache.gluten.memory.SimpleMemoryUsageRecorder;
import org.apache.gluten.memory.arrow.alloc.ManagedAllocationListener;
import org.apache.gluten.memory.memtarget.MemoryTargets;
import org.apache.gluten.memory.memtarget.Spillers;
import org.apache.gluten.shaded.org.apache.arrow.memory.AllocationListener;
import org.apache.gluten.shaded.org.apache.arrow.memory.BufferAllocator;
import org.apache.gluten.shaded.org.apache.arrow.memory.RootAllocator;
import org.apache.spark.memory.GlobalOffHeapMemory;
import org.apache.spark.task.TaskResource;
import org.apache.spark.task.TaskResources;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;

public class ArrowBufferAllocators {
    private static final SimpleMemoryUsageRecorder GLOBAL_USAGE = new SimpleMemoryUsageRecorder();
    private static final BufferAllocator GLOBAL_INSTANCE;

    private ArrowBufferAllocators() {
    }

    public static BufferAllocator contextInstance() {
        return ArrowBufferAllocators.contextInstance("Default");
    }

    public static BufferAllocator contextInstance(String name) {
        if (!TaskResources.inSparkTask()) {
            throw new IllegalStateException("This method must be called in a Spark task.");
        }
        String id = "ArrowBufferAllocatorManager:" + name;
        return ((ArrowBufferAllocatorManager)TaskResources.addResourceIfNotRegistered((String)id, (Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$contextInstance$0(java.lang.String ), ()Lorg/apache/gluten/memory/arrow/alloc/ArrowBufferAllocators$ArrowBufferAllocatorManager;)((String)name))).managed;
    }

    public static BufferAllocator globalInstance() {
        return GLOBAL_INSTANCE;
    }

    private static /* synthetic */ ArrowBufferAllocatorManager lambda$contextInstance$0(String name) {
        return new ArrowBufferAllocatorManager(name);
    }

    static {
        ManagedAllocationListener listener = new ManagedAllocationListener(GlobalOffHeapMemory.target(), GLOBAL_USAGE);
        GLOBAL_INSTANCE = new RootAllocator(listener, Long.MAX_VALUE);
    }

    public static class ArrowBufferAllocatorManager
    implements TaskResource {
        private static Logger LOGGER = LoggerFactory.getLogger(ArrowBufferAllocatorManager.class);
        private static final List<BufferAllocator> LEAKED = new Vector<BufferAllocator>();
        private final AllocationListener listener = GlutenConfig.get().memoryUntracked() ? AllocationListener.NOOP : new ManagedAllocationListener(MemoryTargets.throwOnOom(MemoryTargets.dynamicOffHeapSizingIfEnabled(MemoryTargets.newConsumer("ArrowContextInstance", Spillers.NOOP, Collections.emptyMap()))), TaskResources.getSharedUsage());
        private final String name;
        private final BufferAllocator managed = new RootAllocator(this.listener, Long.MAX_VALUE);

        public ArrowBufferAllocatorManager(String name) {
            this.name = name;
        }

        private void close() {
            this.managed.close();
        }

        private void softClose() {
            long leakBytes = this.managed.getAllocatedMemory();
            long accumulated = TaskResources.ACCUMULATED_LEAK_BYTES().addAndGet(leakBytes);
            LOGGER.warn(String.format("Detected leaked Arrow allocator [%s], size: %d, process accumulated leaked size: %d...", this.resourceName(), leakBytes, accumulated));
            if (TaskResources.DEBUG()) {
                LOGGER.warn(String.format("Leaked allocator stack %s", this.managed.toVerboseString()));
                LEAKED.add(this.managed);
            }
        }

        @Override
        public void release() throws Exception {
            if (this.managed.getAllocatedMemory() != 0L) {
                this.softClose();
            } else {
                this.close();
            }
        }

        @Override
        public int priority() {
            return 10;
        }

        @Override
        public String resourceName() {
            return this.name;
        }
    }
}

