/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gluten.memory;

import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.gluten.config.GlutenConfig$;
import org.apache.gluten.exception.GlutenException;
import org.apache.gluten.memory.MemoryUsageStatsBuilder;
import org.apache.gluten.memory.NativeMemoryManager$;
import org.apache.gluten.memory.NativeMemoryManagerJniWrapper;
import org.apache.gluten.memory.listener.ReservationListener;
import org.apache.gluten.memory.listener.ReservationListeners;
import org.apache.gluten.memory.memtarget.KnownNameAndStats;
import org.apache.gluten.memory.memtarget.MemoryTarget;
import org.apache.gluten.memory.memtarget.Spiller;
import org.apache.gluten.memory.memtarget.Spillers;
import org.apache.gluten.proto.MemoryUsageStats;
import org.apache.gluten.utils.ConfigUtil;
import org.apache.spark.memory.SparkMemoryUtil$;
import org.apache.spark.sql.internal.GlutenConfigUtil$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.task.TaskResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Predef;
import scala.Predef$;
import scala.collection.JavaConverters$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u0005MdaB\u0010!!\u0003\r\n!\u000b\u0005\u0006a\u00011\t!\r\u0005\u0006{\u00011\tA\u0010\u0005\u0006\u007f\u00011\t\u0001Q\u0004\u0006\t\u0002B\t!\u0012\u0004\u0006?\u0001B\ta\u0012\u0005\u0006\u0011\u0016!\t!\u0013\u0004\u0005\u0015\u0016!1\n\u0003\u0005V\u000f\t\u0005\t\u0015!\u0003W\u0011!\twA!A!\u0002\u00131\u0006\"\u0002%\b\t\u0003\u0011\u0007bB4\b\u0005\u0004%I\u0001\u001b\u0005\u0007_\u001e\u0001\u000b\u0011B5\t\u000fA<!\u0019!C\u0005c\"1\u0011p\u0002Q\u0001\nIDqA_\u0004C\u0002\u0013%1\u0010C\u0004\u0002\u0010\u001d\u0001\u000b\u0011\u0002?\t\u0013\u0005EqA1A\u0005\n\u0005M\u0001\u0002CA\u0011\u000f\u0001\u0006I!!\u0006\t\u0013\u0005\rrA1A\u0005\n\u0005\u0015\u0002bBA\u0014\u000f\u0001\u0006I!\u0011\u0005\b\u0003S9A\u0011BA\u0016\u0011%\tId\u0002b\u0001\n\u0013\tY\u0004\u0003\u0005\u0002V\u001d\u0001\u000b\u0011BA\u001f\u0011\u0019\u0001t\u0001\"\u0011\u0002X!)Qh\u0002C!}!)qh\u0002C!\u0001\"1\u00111L\u0004\u0005ByBq!!\u0018\b\t\u0003\ny\u0006C\u0004\u0002h\u001d!\t%!\u001b\t\u000f\u0005-T\u0001\"\u0001\u0002n\t\u0019b*\u0019;jm\u0016lU-\\8ss6\u000bg.Y4fe*\u0011\u0011EI\u0001\u0007[\u0016lwN]=\u000b\u0005\r\"\u0013AB4mkR,gN\u0003\u0002&M\u00051\u0011\r]1dQ\u0016T\u0011aJ\u0001\u0004_J<7\u0001A\n\u0003\u0001)\u0002\"a\u000b\u0018\u000e\u00031R\u0011!L\u0001\u0006g\u000e\fG.Y\u0005\u0003_1\u0012a!\u00118z%\u00164\u0017AC1eIN\u0003\u0018\u000e\u001c7feR\u0011!'\u000e\t\u0003WMJ!\u0001\u000e\u0017\u0003\tUs\u0017\u000e\u001e\u0005\u0006m\u0005\u0001\raN\u0001\bgBLG\u000e\\3s!\tA4(D\u0001:\u0015\tQ\u0004%A\u0005nK6$\u0018M]4fi&\u0011A(\u000f\u0002\b'BLG\u000e\\3s\u0003\u0011Aw\u000e\u001c3\u0015\u0003I\n\u0011bZ3u\u0011\u0006tG\r\\3\u0015\u0003\u0005\u0003\"a\u000b\"\n\u0005\rc#\u0001\u0002'p]\u001e\f1CT1uSZ,W*Z7pefl\u0015M\\1hKJ\u0004\"AR\u0003\u000e\u0003\u0001\u001a\"!\u0002\u0016\u0002\rqJg.\u001b;?)\u0005)%\u0001B%na2\u001cBa\u0002\u0016M\u001bB\u0011a\t\u0001\t\u0003\u001dNk\u0011a\u0014\u0006\u0003!F\u000bA\u0001^1tW*\u0011!\u000bJ\u0001\u0006gB\f'o[\u0005\u0003)>\u0013A\u0002V1tWJ+7o\\;sG\u0016\f1BY1dW\u0016tGMT1nKB\u0011qK\u0018\b\u00031r\u0003\"!\u0017\u0017\u000e\u0003iS!a\u0017\u0015\u0002\rq\u0012xn\u001c;?\u0013\tiF&\u0001\u0004Qe\u0016$WMZ\u0005\u0003?\u0002\u0014aa\u0015;sS:<'BA/-\u0003\u0011q\u0017-\\3\u0015\u0007\r,g\r\u0005\u0002e\u000f5\tQ\u0001C\u0003V\u0015\u0001\u0007a\u000bC\u0003b\u0015\u0001\u0007a+\u0001\u0004M\u001f\u001e;UIU\u000b\u0002SB\u0011!.\\\u0007\u0002W*\u0011ANJ\u0001\u0006g24GG[\u0005\u0003].\u0014a\u0001T8hO\u0016\u0014\u0018a\u0002'P\u000f\u001e+%\u000bI\u0001\tgBLG\u000e\\3sgV\t!\u000f\u0005\u0002tm:\u0011\u0001\b^\u0005\u0003kf\n\u0001b\u00159jY2,'o]\u0005\u0003ob\u0014Q#\u00119qK:$\u0017M\u00197f'BLG\u000e\\3s\u0019&\u001cHO\u0003\u0002vs\u0005I1\u000f]5mY\u0016\u00148\u000fI\u0001\r[V$\u0018M\u00197f'R\fGo]\u000b\u0002yB1Q0!\u0002W\u0003\u0013i\u0011A \u0006\u0004\u007f\u0006\u0005\u0011aB7vi\u0006\u0014G.\u001a\u0006\u0004\u0003\u0007a\u0013AC2pY2,7\r^5p]&\u0019\u0011q\u0001@\u0003\u00075\u000b\u0007\u000fE\u0002G\u0003\u0017I1!!\u0004!\u0005]iU-\\8ssV\u001b\u0018mZ3Ti\u0006$8OQ;jY\u0012,'/A\u0007nkR\f'\r\\3Ti\u0006$8\u000fI\u0001\u0003e2,\"!!\u0006\u0011\t\u0005]\u0011QD\u0007\u0003\u00033Q1!a\u0007!\u0003!a\u0017n\u001d;f]\u0016\u0014\u0018\u0002BA\u0010\u00033\u00111CU3tKJ4\u0018\r^5p]2K7\u000f^3oKJ\f1A\u001d7!\u0003\u0019A\u0017M\u001c3mKV\t\u0011)A\u0004iC:$G.\u001a\u0011\u0002\u0019\r|G\u000e\\3diV\u001b\u0018mZ3\u0015\u0005\u00055\u0002\u0003BA\u0018\u0003ki!!!\r\u000b\u0007\u0005M\"%A\u0003qe>$x.\u0003\u0003\u00028\u0005E\"\u0001E'f[>\u0014\u00180V:bO\u0016\u001cF/\u0019;t\u0003!\u0011X\r\\3bg\u0016$WCAA\u001f!\u0011\ty$!\u0015\u000e\u0005\u0005\u0005#\u0002BA\"\u0003\u000b\na!\u0019;p[&\u001c'\u0002BA$\u0003\u0013\n!bY8oGV\u0014(/\u001a8u\u0015\u0011\tY%!\u0014\u0002\tU$\u0018\u000e\u001c\u0006\u0003\u0003\u001f\nAA[1wC&!\u00111KA!\u00055\tEo\\7jG\n{w\u000e\\3b]\u0006I!/\u001a7fCN,G\r\t\u000b\u0004e\u0005e\u0003\"\u0002\u001c\u0019\u0001\u00049\u0014a\u0002:fY\u0016\f7/Z\u0001\taJLwN]5usR\u0011\u0011\u0011\r\t\u0004W\u0005\r\u0014bAA3Y\t\u0019\u0011J\u001c;\u0002\u0019I,7o\\;sG\u0016t\u0015-\\3\u0015\u0003Y\u000bQ!\u00199qYf$R\u0001TA8\u0003cBQ!\u0016\u0010A\u0002YCQ!\u0019\u0010A\u0002Y\u0003")
public interface NativeMemoryManager {
    public static NativeMemoryManager apply(String backendName, String name) {
        return NativeMemoryManager$.MODULE$.apply(backendName, name);
    }

    public void addSpiller(Spiller var1);

    public void hold();

    public long getHandle();

    private static class Impl
    implements NativeMemoryManager,
    TaskResource {
        private final String name;
        private final Logger org$apache$gluten$memory$NativeMemoryManager$Impl$$LOGGER;
        private final Spillers.AppendableSpillerList spillers;
        private final Map<String, MemoryUsageStatsBuilder> mutableStats;
        private final ReservationListener rl;
        private final long org$apache$gluten$memory$NativeMemoryManager$Impl$$handle;
        private final AtomicBoolean released;

        public Logger org$apache$gluten$memory$NativeMemoryManager$Impl$$LOGGER() {
            return this.org$apache$gluten$memory$NativeMemoryManager$Impl$$LOGGER;
        }

        private Spillers.AppendableSpillerList spillers() {
            return this.spillers;
        }

        private Map<String, MemoryUsageStatsBuilder> mutableStats() {
            return this.mutableStats;
        }

        private ReservationListener rl() {
            return this.rl;
        }

        public long org$apache$gluten$memory$NativeMemoryManager$Impl$$handle() {
            return this.org$apache$gluten$memory$NativeMemoryManager$Impl$$handle;
        }

        public MemoryUsageStats org$apache$gluten$memory$NativeMemoryManager$Impl$$collectUsage() {
            return MemoryUsageStats.parseFrom(NativeMemoryManagerJniWrapper.collectUsage(this.org$apache$gluten$memory$NativeMemoryManager$Impl$$handle()));
        }

        private AtomicBoolean released() {
            return this.released;
        }

        @Override
        public void addSpiller(Spiller spiller) {
            this.spillers().append(spiller);
        }

        @Override
        public void hold() {
            NativeMemoryManagerJniWrapper.hold(this.org$apache$gluten$memory$NativeMemoryManager$Impl$$handle());
        }

        @Override
        public long getHandle() {
            return this.org$apache$gluten$memory$NativeMemoryManager$Impl$$handle();
        }

        @Override
        public void release() {
            if (!this.released().compareAndSet(false, true)) {
                throw new GlutenException("Memory manager instance already released: " + this.org$apache$gluten$memory$NativeMemoryManager$Impl$$handle() + ", " + this.resourceName() + ", " + this.priority());
            }
            if (this.org$apache$gluten$memory$NativeMemoryManager$Impl$$LOGGER().isDebugEnabled()) {
                this.org$apache$gluten$memory$NativeMemoryManager$Impl$$LOGGER().debug("About to release memory manager, " + this.dump$1());
            }
            NativeMemoryManagerJniWrapper.release(this.org$apache$gluten$memory$NativeMemoryManager$Impl$$handle());
            if (this.rl().getUsedBytes() != 0L) {
                this.org$apache$gluten$memory$NativeMemoryManager$Impl$$LOGGER().warn(String.format("%s Reservation listener %s still reserved non-zero bytes, which may cause memory leak, size: %s.", this.name, this.rl().toString(), SparkMemoryUtil$.MODULE$.bytesToString(this.rl().getUsedBytes())));
                return;
            }
        }

        @Override
        public int priority() {
            return 10;
        }

        @Override
        public String resourceName() {
            return "nmm";
        }

        private final String dump$1() {
            return SparkMemoryUtil$.MODULE$.prettyPrintStats("[" + this.resourceName() + "]", new KnownNameAndStats(this){
                private final /* synthetic */ Impl $outer;

                public String name() {
                    return this.$outer.resourceName();
                }

                public MemoryUsageStats stats() {
                    return this.$outer.org$apache$gluten$memory$NativeMemoryManager$Impl$$collectUsage();
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
        }

        public Impl(String backendName, String name) {
            this.name = name;
            TaskResource.$init$(this);
            this.org$apache$gluten$memory$NativeMemoryManager$Impl$$LOGGER = LoggerFactory.getLogger(NativeMemoryManager.class);
            this.spillers = Spillers.appendable();
            this.mutableStats = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
            this.rl = ReservationListeners.create(name, this.spillers(), (java.util.Map)JavaConverters$.MODULE$.mutableMapAsJavaMapConverter(this.mutableStats()).asJava());
            this.org$apache$gluten$memory$NativeMemoryManager$Impl$$handle = NativeMemoryManagerJniWrapper.create(backendName, this.rl(), ConfigUtil.serialize((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(GlutenConfig$.MODULE$.getNativeSessionConf(backendName, GlutenConfigUtil$.MODULE$.parseConfig((scala.collection.immutable.Map<String, String>)SQLConf$.MODULE$.get().getAllConfs()))).asJava()));
            this.spillers().append(new Spiller(this){
                private final /* synthetic */ Impl $outer;

                public long spill(MemoryTarget self, Spiller.Phase phase, long size) {
                    Spiller.Phase phase2 = phase;
                    if (((Object)((Object)Spiller.Phase.SHRINK)).equals((Object)((Object)phase2))) {
                        long shrunk = NativeMemoryManagerJniWrapper.shrink(this.$outer.org$apache$gluten$memory$NativeMemoryManager$Impl$$handle(), size);
                        this.$outer.org$apache$gluten$memory$NativeMemoryManager$Impl$$LOGGER().info("NativeMemoryManager: Shrunk " + shrunk + " / " + size + " bytes of data.");
                        return shrunk;
                    }
                    return 0L;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
            this.mutableStats().$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"single"), (Object)new MemoryUsageStatsBuilder(this){
                private final /* synthetic */ Impl $outer;

                public MemoryUsageStats toStats() {
                    return this.$outer.org$apache$gluten$memory$NativeMemoryManager$Impl$$collectUsage();
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            }));
            this.released = new AtomicBoolean(false);
        }
    }
}

