/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gluten.jni;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import org.apache.commons.io.FileUtils;
import org.apache.gluten.exception.GlutenException;
import org.apache.gluten.jni.JniLibLoader;
import org.apache.gluten.shaded.com.google.common.base.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JniWorkspace {
    private static final Logger LOG = LoggerFactory.getLogger(JniWorkspace.class);
    private static final Map<String, JniWorkspace> INSTANCES = new ConcurrentHashMap<String, JniWorkspace>();
    private static JniWorkspace DEFAULT_INSTANCE = null;
    private static final Object DEFAULT_INSTANCE_INIT_LOCK = new Object();
    private static JniWorkspace DEBUG_INSTANCE = null;
    private final String workDir;
    private final JniLibLoader jniLibLoader;

    private JniWorkspace(String rootDir) {
        try {
            LOG.info("Creating JNI workspace in root directory {}", (Object)rootDir);
            Path root = Paths.get(rootDir, new String[0]);
            Path created = Files.createTempDirectory(root, "gluten-", new FileAttribute[0]);
            this.workDir = created.toAbsolutePath().toString();
            this.jniLibLoader = new JniLibLoader(this.workDir);
            LOG.info("JNI workspace {} created in root directory {}", (Object)this.workDir, (Object)rootDir);
        }
        catch (Exception e) {
            throw new GlutenException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void enableDebug(String debugDir) {
        Object object = DEFAULT_INSTANCE_INIT_LOCK;
        synchronized (object) {
            if (DEBUG_INSTANCE == null) {
                File tempRoot = Paths.get(debugDir, new String[0]).resolve("gluten-jni-debug-" + String.valueOf(UUID.randomUUID())).toFile();
                try {
                    FileUtils.forceMkdir((File)tempRoot);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                DEBUG_INSTANCE = JniWorkspace.createOrGet(tempRoot.getAbsolutePath());
            }
            Preconditions.checkNotNull(DEBUG_INSTANCE);
            if (DEFAULT_INSTANCE == null) {
                DEFAULT_INSTANCE = DEBUG_INSTANCE;
            }
            Preconditions.checkNotNull(DEFAULT_INSTANCE);
            if (DEFAULT_INSTANCE != DEBUG_INSTANCE) {
                throw new IllegalStateException("Default instance is already set to a non-debug instance");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initializeDefault(Supplier<String> rootDir) {
        Object object = DEFAULT_INSTANCE_INIT_LOCK;
        synchronized (object) {
            if (DEFAULT_INSTANCE == null) {
                DEFAULT_INSTANCE = JniWorkspace.createOrGet(rootDir.get());
            }
        }
    }

    public static JniWorkspace getDefault() {
        Preconditions.checkNotNull(DEFAULT_INSTANCE, "Not call initializeDefault yet");
        return DEFAULT_INSTANCE;
    }

    private static JniWorkspace createOrGet(String rootDir) {
        return INSTANCES.computeIfAbsent(rootDir, JniWorkspace::new);
    }

    public String getWorkDir() {
        return this.workDir;
    }

    public JniLibLoader libLoader() {
        return this.jniLibLoader;
    }
}

