/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gluten.jni;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.HashSet;
import java.util.Set;
import org.apache.gluten.exception.GlutenException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JniLibLoader {
    private static final Logger LOG = LoggerFactory.getLogger(JniLibLoader.class);
    private static final Set<String> LOADED_LIBRARY_PATHS = new HashSet<String>();
    private final String workDir;
    private final Set<String> loadedLibraries = new HashSet<String>();

    JniLibLoader(String workDir) {
        this.workDir = workDir;
    }

    private static String toRealPath(String libPath) {
        String realPath = libPath;
        try {
            while (Files.isSymbolicLink(Paths.get(realPath, new String[0]))) {
                realPath = Files.readSymbolicLink(Paths.get(realPath, new String[0])).toString();
            }
            LOG.info("Read real path {} for libPath {}", (Object)realPath, (Object)libPath);
            return realPath;
        }
        catch (Throwable th) {
            throw new GlutenException("Error to read real path for libPath: " + libPath, th);
        }
    }

    private static void loadFromPath0(String libPath) {
        if (LOADED_LIBRARY_PATHS.contains(libPath = JniLibLoader.toRealPath(libPath))) {
            LOG.debug("Library in path {} has already been loaded, skipping", (Object)libPath);
        } else {
            System.load(libPath);
            LOADED_LIBRARY_PATHS.add(libPath);
            LOG.info("Library {} has been loaded using path-loading method", (Object)libPath);
        }
    }

    public static synchronized void loadFromPath(String libPath) {
        File file = new File(libPath);
        if (!file.isFile() || !file.exists()) {
            throw new GlutenException("library at path: " + libPath + " is not a file or does not exist");
        }
        JniLibLoader.loadFromPath0(file.getAbsolutePath());
    }

    public synchronized void load(String libPath) {
        try {
            if (this.loadedLibraries.contains(libPath)) {
                LOG.debug("Library {} has already been loaded, skipping", (Object)libPath);
                return;
            }
            File file = this.moveToWorkDir(this.workDir, libPath);
            this.loadWithLink(file.getAbsolutePath(), null);
            this.loadedLibraries.add(libPath);
            LOG.info("Successfully loaded library {}", (Object)libPath);
        }
        catch (IOException e) {
            throw new GlutenException(e);
        }
    }

    public synchronized void loadAndCreateLink(String libPath, String linkName) {
        try {
            if (this.loadedLibraries.contains(libPath)) {
                LOG.debug("Library {} has already been loaded, skipping", (Object)libPath);
            }
            File file = this.moveToWorkDir(this.workDir, libPath);
            this.loadWithLink(file.getAbsolutePath(), linkName);
            this.loadedLibraries.add(libPath);
            LOG.info("Successfully loaded library {}", (Object)libPath);
        }
        catch (IOException e) {
            throw new GlutenException(e);
        }
    }

    private File moveToWorkDir(String workDir, String libraryToLoad) throws IOException {
        File temp;
        Path libPath = Paths.get(workDir, libraryToLoad);
        if (Files.exists(libPath, new LinkOption[0])) {
            Files.delete(libPath);
        }
        if (!(temp = libPath.toFile()).getParentFile().exists()) {
            temp.getParentFile().mkdirs();
        }
        try (InputStream is = JniLibLoader.class.getClassLoader().getResourceAsStream(libraryToLoad);){
            if (is == null) {
                throw new FileNotFoundException(libraryToLoad);
            }
            try {
                Files.copy(is, temp.toPath(), new CopyOption[0]);
            }
            catch (Exception e) {
                throw new GlutenException(e);
            }
        }
        return temp;
    }

    private void loadWithLink(String libPath, String linkName) throws IOException {
        JniLibLoader.loadFromPath0(libPath);
        LOG.info("Library {} has been loaded", (Object)libPath);
        if (linkName != null) {
            Path target = Paths.get(libPath, new String[0]);
            Path link = Paths.get(this.workDir, linkName);
            if (Files.exists(link, new LinkOption[0])) {
                LOG.info("Symbolic link already exists for library {}, deleting", (Object)libPath);
                Files.delete(link);
            }
            Files.createSymbolicLink(link, target, new FileAttribute[0]);
            LOG.info("Symbolic link {} created for library {}", (Object)link, (Object)libPath);
        }
    }
}

