/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gluten.init;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.gluten.backendsapi.BackendsApiManager;
import org.apache.gluten.config.GlutenConfig;
import org.apache.gluten.memory.listener.ReservationListener;
import org.apache.gluten.utils.ConfigUtil;
import org.apache.spark.util.SparkShutdownManagerUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.collection.Map;
import scala.runtime.BoxedUnit;

public final class NativeBackendInitializer {
    private static final Logger LOG = LoggerFactory.getLogger(NativeBackendInitializer.class);
    private static final java.util.Map<String, NativeBackendInitializer> instances = new ConcurrentHashMap<String, NativeBackendInitializer>();
    private final AtomicBoolean initialized = new AtomicBoolean(false);
    private final String backendName;

    private NativeBackendInitializer(String backendName) {
        this.backendName = backendName;
    }

    public static NativeBackendInitializer forBackend(String backendName) {
        return instances.computeIfAbsent(backendName, k -> new NativeBackendInitializer(backendName));
    }

    public void initialize(ReservationListener rl, Map<String, String> conf) {
        if (!this.initialized.compareAndSet(false, true)) {
            throw new IllegalStateException("Already initialized");
        }
        this.initialize0(rl, conf);
        SparkShutdownManagerUtil.addHook((Function0<BoxedUnit>)((Function0)() -> {
            this.shutdown();
            return BoxedUnit.UNIT;
        }));
    }

    private void initialize0(ReservationListener rl, Map<String, String> conf) {
        try {
            java.util.Map<String, String> nativeConfMap = GlutenConfig.getNativeBackendConf(this.backendName, conf);
            BackendsApiManager.getTransformerApiInstance().postProcessNativeConfig(nativeConfMap, GlutenConfig.prefixOf(BackendsApiManager.getBackendName()));
            this.initialize(rl, ConfigUtil.serialize(nativeConfMap));
        }
        catch (Exception e) {
            LOG.error("Failed to call native backend's initialize method", (Throwable)e);
            throw e;
        }
    }

    private native void initialize(ReservationListener var1, byte[] var2);

    private native void shutdown();
}

