/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gluten.hash;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.codec.digest.MurmurHash3;
import org.apache.gluten.shaded.com.google.common.base.Preconditions;

@ThreadSafe
public class ConsistentHash<T extends Node> {
    private final ReadWriteLock lock = new ReentrantReadWriteLock(true);
    private final Map<T, Set<Partition<T>>> nodes = new HashMap<T, Set<Partition<T>>>();
    private final SortedMap<Long, Partition<T>> ring = new TreeMap<Long, Partition<T>>();
    private final int replicate;
    private final Hasher hasher;

    public ConsistentHash(int replicate) {
        Preconditions.checkArgument(replicate > 0, "HashRing require positive replicate number.");
        this.replicate = replicate;
        this.hasher = (key, seed) -> {
            byte[] data = key.getBytes();
            return MurmurHash3.hash32x86((byte[])data, (int)0, (int)data.length, (int)seed);
        };
    }

    public ConsistentHash(int replicate, Hasher hasher) {
        Preconditions.checkArgument(replicate > 0, "HashRing require positive replicate number.");
        Preconditions.checkArgument(hasher != null, "HashRing require non-null hasher.");
        this.replicate = replicate;
        this.hasher = hasher;
    }

    public boolean addNode(T node) {
        this.lock.writeLock().lock();
        try {
            boolean bl = this.add(node);
            return bl;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeNode(T node) {
        this.lock.writeLock().lock();
        boolean removed = false;
        try {
            if (this.nodes.containsKey(node)) {
                Set<Partition<Partition>> partitions = this.nodes.remove(node);
                partitions.forEach(p -> this.ring.remove(p.getSlot()));
                removed = true;
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
        return removed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<T> allocateNodes(String key, int count) {
        this.lock.readLock().lock();
        try {
            HashSet<T> res = new HashSet<T>();
            if (key != null && count > 0) {
                if (count < this.nodes.size()) {
                    long slot = this.hasher.hash(key, 0);
                    AllocateIterator it = new AllocateIterator(slot);
                    while (it.hasNext() && res.size() < count) {
                        Partition part = (Partition)it.next();
                        res.add(part.getNode());
                    }
                } else {
                    res.addAll(this.nodes.keySet());
                }
            }
            HashSet<T> hashSet = res;
            return hashSet;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Set<T> getNodes() {
        this.lock.readLock().lock();
        try {
            HashSet<T> hashSet = new HashSet<T>(this.nodes.keySet());
            return hashSet;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Set<Partition<T>> getPartition(T node) {
        this.lock.readLock().lock();
        try {
            Set<Partition<T>> set = this.nodes.get(node);
            return set;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public boolean contains(T node) {
        this.lock.readLock().lock();
        try {
            boolean bl = this.nodes.containsKey(node);
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean ringContain(long slot) {
        this.lock.readLock().lock();
        try {
            boolean bl = this.ring.containsKey(slot);
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    private boolean add(T node) {
        boolean added = false;
        if (node != null && !this.nodes.containsKey(node)) {
            Set partitions = IntStream.range(0, this.replicate).mapToObj(idx -> new Partition<Node>((Node)node, idx)).collect(Collectors.toSet());
            this.nodes.put(node, partitions);
            for (Partition partition : partitions) {
                long slot;
                int seed = 0;
                while (this.ring.containsKey(slot = this.hasher.hash(partition.getPartitionKey(), seed++))) {
                }
                partition.setSlot(slot);
                this.ring.put(slot, partition);
            }
            added = true;
        }
        return added;
    }

    public static interface Hasher {
        public long hash(String var1, int var2);
    }

    public static interface Node {
        public String key();
    }

    private class AllocateIterator
    implements Iterator<Partition<T>> {
        private final Iterator<Partition<T>> head;
        private final Iterator<Partition<T>> tail;

        AllocateIterator(long slot) {
            this.head = ConsistentHash.this.ring.headMap(slot).values().iterator();
            this.tail = ConsistentHash.this.ring.tailMap(slot).values().iterator();
        }

        @Override
        public boolean hasNext() {
            return this.head.hasNext() || this.tail.hasNext();
        }

        @Override
        public Partition<T> next() {
            return this.tail.hasNext() ? this.tail.next() : this.head.next();
        }
    }

    public static class Partition<T extends Node> {
        private final T node;
        private final int index;
        private long slot;

        public Partition(T node, int index) {
            this.node = node;
            this.index = index;
        }

        public String getPartitionKey() {
            return String.format("%s:%d", this.node, this.index);
        }

        public T getNode() {
            return this.node;
        }

        public void setSlot(long slot) {
            this.slot = slot;
        }

        public long getSlot() {
            return this.slot;
        }
    }
}

